/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.project.Project;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramColorManager
extends DiagramColorManagerBase {
    public Color getEdgeColor(DiagramEdge edge) {
        if (edge instanceof SpringDiagramEdge) {
            SpringDependencyType type = ((SpringDiagramEdge)edge).getDependencyType();
            switch (type) {
                case PROPERTY_INJECTION: 
                case CONSTRUCTOR_INJECTION: 
                case LOOKUP_METHOD_INJECTION: 
                case FACTORY_BEAN: 
                case DEPENDS_ON: 
                case INNER: 
                case IMPORTED: {
                    return DEFAULT_EDGE_COLOR;
                }
                case PARENT: {
                    return JBColor.RED.darker();
                }
                case SCANNED: {
                    return JBColor.GREEN.darker();
                }
                case AUTOWIRE: 
                case ANNO_AUTOWIRED: 
                case ANNO_RESOURCE_AUTOWIRED: 
                case ANNO_INJECT_AUTOWIRED: 
                case JAVA_BEAN: 
                case UNKNOWN: {
                    return JBColor.BLUE.brighter();
                }
            }
        }
        return super.getEdgeColor(edge);
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        return JBColor.background();
    }

    public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
        return JBColor.background();
    }
}

