/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.FinderRecursivePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringModulesPanelBase
extends FinderRecursivePanel<Module> {
    protected SpringModulesPanelBase(Project project, String groupId) {
        super(project, groupId);
    }

    @NotNull
    public List<Module> getListItems() {
        Module[] modules;
        boolean autoConfigurationMode = SpringGeneralSettings.getInstance(this.getProject()).isAllowAutoConfigurationMode();
        if (!SpringCommonUtils.hasSpringFacets(this.getProject()) && !autoConfigurationMode) {
            List<Module> list = Collections.emptyList();
            if (list == null) {
                SpringModulesPanelBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<Module> items = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (!autoConfigurationMode && !SpringCommonUtils.hasSpringFacet(module)) continue;
            items.add(module);
        }
        Collections.sort(items, ModulesAlphaComparator.INSTANCE);
        ArrayList<Module> arrayList = items;
        if (arrayList == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public String getItemText(Module module) {
        String string = module.getName();
        if (string == null) {
            SpringModulesPanelBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Icon getItemIcon(Module module) {
        return module.isDisposed() ? null : ModuleType.get((Module)module).getIcon();
    }

    public boolean performEditAction() {
        Module module = (Module)this.getSelectedValue();
        if (module != null) {
            ModulesConfigurator.showDialog((Project)this.getProject(), (String)module.getName(), null);
        }
        return true;
    }

    public boolean hasChildren(Module module) {
        if (module.isDisposed()) {
            return false;
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            return false;
        }
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            return false;
        }
        return !SpringFileSetService.getInstance().getAllSets(springFacet).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/toolWindow/SpringModulesPanelBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

