/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeansGroupingRule
extends SingleParentUsageGroupingRule {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.usages.SpringBeansGroupingRule");

    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        DomSpringBean springBean;
        DomElement domElement;
        PsiElement psiElement;
        PsiFile psiFile;
        if (usage == null) {
            SpringBeansGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            SpringBeansGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof PsiElementUsage && (psiFile = (psiElement = ((PsiElementUsage)usage).getElement()).getContainingFile()) instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)psiFile) && (domElement = DomUtil.getDomElement((PsiElement)psiElement)) != null && (springBean = (DomSpringBean)domElement.getParentOfType(DomSpringBean.class, false)) != null) {
            return new SpringBeansUsageGroup(springBean);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/usages/SpringBeansGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SpringBeansUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final String myName;
        private final DomSpringBean myBean;

        SpringBeansUsageGroup(@NotNull DomSpringBean bean) {
            if (bean == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(0);
            }
            this.myBean = bean;
            String beanName = bean.getPresentation().getElementName();
            this.myName = beanName == null ? SpringApiBundle.message("spring.bean.with.unknown.name", new Object[0]) : beanName;
            this.update();
        }

        public void update() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringBeansUsageGroup that = (SpringBeansUsageGroup)o;
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            if (!this.isValid()) {
                return false;
            }
            if (!that.isValid()) {
                return false;
            }
            return this.myBean.equals(that.myBean);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myBean.hashCode();
            return result;
        }

        public Icon getIcon(boolean isOpen) {
            return this.isValid() ? SpringPresentationProvider.getSpringIcon(this.myBean) : null;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myName;
            if (string == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public DomSpringBean getBean() {
            DomSpringBean domSpringBean = this.myBean;
            if (domSpringBean == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(2);
            }
            return domSpringBean;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)DomUtil.getFile((DomElement)this.getBean())) : null;
        }

        public boolean isValid() {
            return this.getBean().isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                SpringDomUtils.navigate(this.myBean);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(3);
            }
            if (!(usageGroup instanceof SpringBeansUsageGroup)) {
                LOG.error("SpringBeansUsageGroup expected but " + usageGroup.getClass() + " found");
                return 0;
            }
            return this.myName.compareToIgnoreCase(((SpringBeansUsageGroup)usageGroup).myName);
        }

        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            XmlElement element;
            if (key == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(4);
            }
            if (sink == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(5);
            }
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key && (element = this.getPsiElement()) != null && element.isValid()) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)element);
            }
            if (UsageView.USAGE_INFO_KEY == key && (element = this.getPsiElement()) != null && element.isValid()) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)element));
            }
        }

        @Nullable
        private XmlElement getPsiElement() {
            return this.getBean().getXmlElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/usages/SpringBeansGroupingRule$SpringBeansUsageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/usages/SpringBeansGroupingRule$SpringBeansUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

