/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.SyncService;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidDbUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDbUtil");
    public static final Object DB_SYNC_LOCK = new Object();
    public static final String TEMP_REMOTE_DB_PATH = "/data/local/tmp/intellij_temp_db_file";
    public static final String TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH = "/data/local/tmp/intellij_native_tools/get_modification_time";
    public static final long DB_COPYING_TIMEOUT_SEC = 30L;
    public static final int SHELL_COMMAND_TIMEOUT_SECONDS = 2;
    private static final String DEVICE_ID_EMULATOR_PREFIX = "EMULATOR_";
    private static final String DEVICE_ID_SERIAL_NUMBER_PREFIX = "SERIAL_NUMBER_";
    private static final Pattern RUN_AS_UNKNOWN_PACKAGE_ERROR_PATTERN = Pattern.compile("run-as: Package '\\S+' is unknown");

    private AndroidDbUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadDatabase(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull String localDbPath, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(1);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(2);
        }
        if (localDbPath == null) {
            AndroidDbUtil.$$$reportNull$$$0(3);
        }
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(4);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(5);
        }
        try {
            try (SyncService syncService = device.getSyncService();){
                syncService.pushFile(localDbPath, TEMP_REMOTE_DB_PATH, (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
            String remoteDbPath = AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external);
            String remoteDbDirPath = remoteDbPath.substring(0, remoteDbPath.lastIndexOf(47));
            MyShellOutputReceiver outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "mkdir " + remoteDbDirPath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
            String output = outputReceiver.getOutput();
            if (!output.isEmpty() && !output.startsWith("mkdir failed")) {
                errorReporter.reportError(output);
                return false;
            }
            if (!external && !AndroidDbUtil.recreateRemoteFile(device, packageName, remoteDbPath, errorReporter, progressIndicator)) {
                return false;
            }
            outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "cat " + TEMP_REMOTE_DB_PATH + " >" + remoteDbPath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
            output = outputReceiver.getOutput();
            if (!output.isEmpty()) {
                errorReporter.reportError(output);
                return false;
            }
            progressIndicator.checkCanceled();
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return false;
        }
        return true;
    }

    @NotNull
    private static String getRunAsPrefix(@NotNull String packageName, boolean external) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(6);
        }
        String string = external ? "" : "run-as " + packageName + " ";
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean recreateRemoteFile(IDevice device, String packageName, String remotePath, AndroidDbErrorReporter errorReporter, ProgressIndicator progressIndicator) throws Exception {
        MyShellOutputReceiver outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
        device.executeShellCommand("run-as " + packageName + " rm " + remotePath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
        String output = outputReceiver.getOutput();
        if (!output.isEmpty() && !output.startsWith("rm failed")) {
            errorReporter.reportError(output);
            return false;
        }
        outputReceiver = new MyShellOutputReceiver(progressIndicator, device);
        device.executeShellCommand("run-as " + packageName + " touch " + remotePath, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
        output = outputReceiver.getOutput();
        if (!output.isEmpty()) {
            errorReporter.reportError(output);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadDatabase(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull File localDbFile, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(8);
        }
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(9);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(10);
        }
        if (localDbFile == null) {
            AndroidDbUtil.$$$reportNull$$$0(11);
        }
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(12);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(13);
        }
        try {
            MyShellOutputReceiver receiver = new MyShellOutputReceiver(progressIndicator, device);
            device.executeShellCommand(AndroidDbUtil.getRunAsPrefix(packageName, external) + "cat " + AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external) + " >" + TEMP_REMOTE_DB_PATH, (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
            String output = receiver.getOutput();
            if (!output.isEmpty()) {
                errorReporter.reportError(output);
                return false;
            }
            progressIndicator.checkCanceled();
            File parent = localDbFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                errorReporter.reportError("cannot create directory '" + parent.getPath() + "'");
                return false;
            }
            try (SyncService syncService = device.getSyncService();){
                syncService.pullFile(TEMP_REMOTE_DB_PATH, localDbFile.getPath(), (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static AndroidDbConnectionInfo checkDataSource(@NotNull AndroidDataSource dataSource, @NotNull AndroidDebugBridge debugBridge, @NotNull AndroidDbErrorReporter errorReporter) {
        if (dataSource == null) {
            AndroidDbUtil.$$$reportNull$$$0(14);
        }
        if (debugBridge == null) {
            AndroidDbUtil.$$$reportNull$$$0(15);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(16);
        }
        AndroidDataSource.State state = dataSource.getState();
        String deviceId = state.deviceId;
        if (deviceId == null) {
            errorReporter.reportError("device is not specified");
            return null;
        }
        IDevice device = AndroidDbUtil.getDeviceById(debugBridge, deviceId);
        if (device == null) {
            errorReporter.reportError("device '" + AndroidDbUtil.getPresentableNameFromDeviceId(deviceId) + "' is not connected");
            return null;
        }
        if (!device.isOnline()) {
            errorReporter.reportError("the device is not online");
            return null;
        }
        String packageName = dataSource.getState().packageName;
        if (packageName == null || packageName.length() == 0) {
            errorReporter.reportError("package name is not specified");
            return null;
        }
        String dbName = dataSource.getState().databaseName;
        if (dbName == null || dbName.length() == 0) {
            errorReporter.reportError("database name is not specified");
            return null;
        }
        return new AndroidDbConnectionInfo(device, packageName, dbName, dataSource.getState().external);
    }

    @Nullable
    private static IDevice getDeviceById(@NotNull AndroidDebugBridge debugBridge, @NotNull String deviceId) {
        if (debugBridge == null) {
            AndroidDbUtil.$$$reportNull$$$0(17);
        }
        if (deviceId == null) {
            AndroidDbUtil.$$$reportNull$$$0(18);
        }
        for (IDevice device : debugBridge.getDevices()) {
            if (!deviceId.equals(AndroidDbUtil.getDeviceId(device))) continue;
            return device;
        }
        return null;
    }

    private static boolean installGetModificationTimeTool(@NotNull IDevice device, @NotNull AndroidDbErrorReporter reporter, @NotNull ProgressIndicator progressIndicator) {
        String abi;
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(19);
        }
        if (reporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(20);
        }
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(21);
        }
        if ((abi = device.getProperty("ro.product.cpu.abi")) == null) {
            abi = "armeabi";
        }
        String pieDir = AndroidDbUtil.arePositionIndependentExecutablesSupported(device) ? "pie" : "non_pie";
        String urlStr = "/native_tools/" + pieDir + "/" + abi + "/get_modification_time";
        URL url = AndroidDbUtil.class.getResource(urlStr);
        if (url == null) {
            LOG.error("Cannot find resource " + urlStr);
            return false;
        }
        String remoteToolPath = TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH;
        if (!AndroidDbUtil.pushGetModificationTimeTool(device, url, reporter, progressIndicator, TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH)) {
            return false;
        }
        String chmodResult = AndroidDbUtil.executeSingleCommand(device, reporter, "chmod 755 /data/local/tmp/intellij_native_tools/get_modification_time");
        if (chmodResult == null) {
            return false;
        }
        if (!chmodResult.isEmpty()) {
            reporter.reportError(chmodResult);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pushGetModificationTimeTool(@NotNull IDevice device, @NotNull URL url, @NotNull AndroidDbErrorReporter reporter, @NotNull ProgressIndicator progressIndicator, @NotNull String remotePath) {
        File toolLocalCopy;
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(22);
        }
        if (url == null) {
            AndroidDbUtil.$$$reportNull$$$0(23);
        }
        if (reporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(24);
        }
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(25);
        }
        if (remotePath == null) {
            AndroidDbUtil.$$$reportNull$$$0(26);
        }
        try {
            toolLocalCopy = FileUtil.createTempFile((String)"android_get_modification_time_tool", (String)"tmp");
        }
        catch (IOException e) {
            reporter.reportError(e);
            return false;
        }
        try {
            if (!AndroidDbUtil.copyResourceToFile(url, toolLocalCopy, reporter)) {
                boolean e = false;
                return e;
            }
            try (SyncService service = device.getSyncService();){
                service.pushFile(toolLocalCopy.getPath(), remotePath, (SyncService.ISyncProgressMonitor)new MySyncProgressMonitor(progressIndicator));
            }
            catch (Exception e) {
                reporter.reportError(e);
                boolean bl = false;
                FileUtil.delete((File)toolLocalCopy);
                return bl;
            }
        }
        finally {
            FileUtil.delete((File)toolLocalCopy);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyResourceToFile(@NotNull URL url, @NotNull File file, @NotNull AndroidDbErrorReporter reporter) {
        if (url == null) {
            AndroidDbUtil.$$$reportNull$$$0(27);
        }
        if (file == null) {
            AndroidDbUtil.$$$reportNull$$$0(28);
        }
        if (reporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(29);
        }
        try {
            BufferedInputStream is = new BufferedInputStream(URLUtil.openStream((URL)url));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((InputStream)is).close();
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            reporter.reportError(e);
            return false;
        }
        return true;
    }

    @Nullable
    public static Long getModificationTime(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull AndroidDbErrorReporter errorReporter, @NotNull ProgressIndicator progressIndicator) {
        Long l;
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(30);
        }
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(31);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(32);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(33);
        }
        if (progressIndicator == null) {
            AndroidDbUtil.$$$reportNull$$$0(34);
        }
        String path = TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH;
        String lsResult = AndroidDbUtil.executeSingleCommand(device, errorReporter, "ls /data/local/tmp/intellij_native_tools/get_modification_time");
        if (lsResult == null) {
            return null;
        }
        boolean reinstalled = false;
        if (!lsResult.equals(TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH)) {
            if (!AndroidDbUtil.installGetModificationTimeTool(device, errorReporter, progressIndicator)) {
                return null;
            }
            reinstalled = true;
        }
        if ((l = AndroidDbUtil.doGetModificationTime(device, packageName, dbName, external, errorReporter)) != null) {
            return l;
        }
        if (!reinstalled) {
            AndroidDbUtil.installGetModificationTimeTool(device, errorReporter, progressIndicator);
        }
        return null;
    }

    @Nullable
    private static Long doGetModificationTime(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external, @NotNull AndroidDbErrorReporter errorReporter) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(35);
        }
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(36);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(37);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(38);
        }
        String databaseRemoteFilePath = AndroidDbUtil.getDatabaseRemoteFilePath(packageName, dbName, external);
        String command = AndroidDbUtil.getRunAsPrefix(packageName, external) + TEMP_REMOTE_GET_MODIFICATION_TIME_TOOL_PATH + " " + databaseRemoteFilePath;
        String s = AndroidDbUtil.executeSingleCommand(device, errorReporter, command);
        if (s != null && s.contains("Permission denied")) {
            s = AndroidDbUtil.executeSingleCommand(device, errorReporter, "/data/local/tmp/intellij_native_tools/get_modification_time " + databaseRemoteFilePath);
        }
        if (s == null) {
            return null;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            errorReporter.reportError(s);
            return null;
        }
    }

    @Nullable
    private static String executeSingleCommand(@NotNull IDevice device, @NotNull AndroidDbErrorReporter errorReporter, @NotNull String command) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(39);
        }
        if (errorReporter == null) {
            AndroidDbUtil.$$$reportNull$$$0(40);
        }
        if (command == null) {
            AndroidDbUtil.$$$reportNull$$$0(41);
        }
        MyShellOutputReceiver receiver = new MyShellOutputReceiver(null, device);
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            errorReporter.reportError(e);
            return null;
        }
        return receiver.getOutput();
    }

    @Nullable
    public static String getDeviceId(@NotNull IDevice device) {
        if (device == null) {
            AndroidDbUtil.$$$reportNull$$$0(42);
        }
        if (device.isEmulator()) {
            String avdName = device.getAvdName();
            return avdName == null ? null : DEVICE_ID_EMULATOR_PREFIX + AndroidDbUtil.replaceByDirAllowedName(avdName);
        }
        String serialNumber = device.getSerialNumber();
        if (serialNumber != null && serialNumber.length() > 0) {
            return DEVICE_ID_SERIAL_NUMBER_PREFIX + AndroidDbUtil.replaceByDirAllowedName(serialNumber);
        }
        String manufacturer = DevicePropertyUtil.getManufacturer((IDevice)device, (String)"");
        String model = DevicePropertyUtil.getModel((IDevice)device, (String)"");
        if (manufacturer.length() > 0 || model.length() > 0) {
            return AndroidDbUtil.replaceByDirAllowedName(manufacturer + "_" + model);
        }
        return null;
    }

    @NotNull
    public static String getPresentableNameFromDeviceId(@NotNull String deviceId) {
        if (deviceId == null) {
            AndroidDbUtil.$$$reportNull$$$0(43);
        }
        if (deviceId.startsWith(DEVICE_ID_EMULATOR_PREFIX)) {
            String string = "emulator: " + deviceId.substring(DEVICE_ID_EMULATOR_PREFIX.length());
            if (string == null) {
                AndroidDbUtil.$$$reportNull$$$0(44);
            }
            return string;
        }
        if (deviceId.startsWith(DEVICE_ID_SERIAL_NUMBER_PREFIX)) {
            String string = "serial: " + deviceId.substring(DEVICE_ID_SERIAL_NUMBER_PREFIX.length());
            if (string == null) {
                AndroidDbUtil.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = deviceId;
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    private static String replaceByDirAllowedName(@NotNull String s) {
        if (s == null) {
            AndroidDbUtil.$$$reportNull$$$0(47);
        }
        StringBuilder builder = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            builder.append(c);
        }
        String string = builder.toString();
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    private static boolean arePositionIndependentExecutablesSupported(IDevice device) {
        try {
            return Integer.parseInt(device.getProperty("ro.build.version.sdk")) >= 16;
        }
        catch (NumberFormatException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static String getInternalDatabasesRemoteDirPath(@NotNull String packageName) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(49);
        }
        String string = "/data/data/" + packageName + "/databases";
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    public static String getDatabaseRemoteFilePath(@NotNull String packageName, @NotNull String dbName, boolean external) {
        if (packageName == null) {
            AndroidDbUtil.$$$reportNull$$$0(51);
        }
        if (dbName == null) {
            AndroidDbUtil.$$$reportNull$$$0(52);
        }
        dbName = StringUtil.trimStart((String)dbName, (String)"/");
        if (!external) {
            String string = AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName) + "/" + dbName;
            if (string == null) {
                AndroidDbUtil.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = "$EXTERNAL_STORAGE/Android/data/" + packageName + "/" + dbName;
        if (string == null) {
            AndroidDbUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 31: 
            case 36: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDbPath";
                break;
            }
            case 4: 
            case 12: 
            case 21: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 33: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 7: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDbUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDbFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugBridge";
                break;
            }
            case 18: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
            case 20: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDbUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAsPrefix";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameFromDeviceId";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceByDirAllowedName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalDatabasesRemoteDirPath";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseRemoteFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uploadDatabase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunAsPrefix";
                break;
            }
            case 7: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "downloadDatabase";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkDataSource";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceById";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installGetModificationTimeTool";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "pushGetModificationTimeTool";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copyResourceToFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTime";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doGetModificationTime";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "executeSingleCommand";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceId";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameFromDeviceId";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "replaceByDirAllowedName";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInternalDatabasesRemoteDirPath";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseRemoteFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySyncProgressMonitor
    implements SyncService.ISyncProgressMonitor {
        private final ProgressIndicator myProgressIndicator;

        MySyncProgressMonitor(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                MySyncProgressMonitor.$$$reportNull$$$0(0);
            }
            this.myProgressIndicator = progressIndicator;
        }

        public void start(int totalWork) {
        }

        public void stop() {
        }

        public boolean isCanceled() {
            return this.myProgressIndicator.isCanceled();
        }

        public void startSubTask(String name) {
        }

        public void advance(int work) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/android/database/AndroidDbUtil$MySyncProgressMonitor", "<init>"));
        }
    }

    private static class MyShellOutputReceiver
    extends MultiLineReceiver {
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        private final StringBuilder myOutputBuilder;
        private final boolean myAndroid43;

        MyShellOutputReceiver(@Nullable ProgressIndicator progressIndicator, @NotNull IDevice device) {
            if (device == null) {
                MyShellOutputReceiver.$$$reportNull$$$0(0);
            }
            this.myOutputBuilder = new StringBuilder();
            this.myProgressIndicator = progressIndicator;
            this.myAndroid43 = "18".equals(device.getProperty("ro.build.version.sdk"));
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                String s = line.trim();
                if (s.length() <= 0) continue;
                LOG.debug("ADB_SHELL: " + s);
                if (this.myOutputBuilder.length() > 0) {
                    this.myOutputBuilder.append('\n');
                }
                this.myOutputBuilder.append(s);
                if (!this.myAndroid43 || !RUN_AS_UNKNOWN_PACKAGE_ERROR_PATTERN.matcher(s).matches()) continue;
                this.myOutputBuilder.append(". \nUnfortunately database support doesn't work for Android 4.3 devices because of the bug https://code.google.com/p/android/issues/detail?id=58373");
            }
        }

        public boolean isCancelled() {
            return this.myProgressIndicator != null && this.myProgressIndicator.isCanceled();
        }

        @NotNull
        public String getOutput() {
            String string = this.myOutputBuilder.toString();
            if (string == null) {
                MyShellOutputReceiver.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/database/AndroidDbUtil$MyShellOutputReceiver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/database/AndroidDbUtil$MyShellOutputReceiver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

