/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdcommon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.ScrollingInfo;
import com.jetbrains.ide.model.SelectionRange;
import com.jetbrains.ide.model.SelectionRangeWithVersion;
import com.jetbrains.ide.model.SelectionVersion;
import com.jetbrains.ide.model.TextControlModel;
import com.jetbrains.ide.model.VisibleRange;
import com.jetbrains.rdcommon.DisposableExKt;
import com.jetbrains.rdcommon.FrontendEditorSuppressor;
import com.jetbrains.rdcommon.SelectionVersionExKt;
import com.jetbrains.rdcommon.TextControlsUtilsKt;
import com.jetbrains.rider.framework.impl.RdOptionalProperty;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IOptProperty;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001BB-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u0010-\u001a\u000202H\u0016J\u0006\u00103\u001a\u00020,J\u0010\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\u0011H\u0002J\u000e\u00106\u001a\u00020,2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020,2\u0006\u00105\u001a\u00020:J\u0010\u0010;\u001a\u00020,2\u0006\u0010-\u001a\u00020<H\u0016J\u0006\u0010=\u001a\u00020,J\u000e\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\u000eJ\u0010\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020AH\u0016R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/jetbrains/rdcommon/FrontendEditorSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "textControlLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorModel", "Lcom/jetbrains/ide/model/TextControlModel;", "suppressor", "Lcom/jetbrains/rdcommon/FrontendEditorSuppressor;", "isMaster", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/ide/model/TextControlModel;Lcom/jetbrains/rdcommon/FrontendEditorSuppressor;Z)V", "<set-?>", "Lcom/jetbrains/ide/model/SelectionRange;", "currentSelection", "getCurrentSelection", "()Lcom/jetbrains/ide/model/SelectionRange;", "setCurrentSelection", "(Lcom/jetbrains/ide/model/SelectionRange;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "hasQueuedChanges", "indentSize", "", "getIndentSize", "()Ljava/lang/Integer;", "getSuppressor", "()Lcom/jetbrains/rdcommon/FrontendEditorSuppressor;", "tabSize", "getTabSize", "updatingFromBackend", "updatingFromFrontend", "useTab", "getUseTab", "()Ljava/lang/Boolean;", "version", "Lcom/jetbrains/ide/model/SelectionVersion;", "visibleAreaChangesQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "caretAdded", "", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretPositionChanged", "caretRemoved", "documentChanged", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "flushSuppressedChanges", "performSend", "model", "receiveScrollingRequest", "backendScrolling", "Lcom/jetbrains/ide/model/ScrollingInfo;", "receiveSelection", "Lcom/jetbrains/ide/model/SelectionRangeWithVersion;", "selectionChanged", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "sendSelection", "setVisible", "value", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Companion", "intellij.platform.commercial.rdcommon"})
public final class FrontendEditorSynchronizer
implements CaretListener,
SelectionListener,
VisibleAreaListener,
DocumentListener {
    private final Disposable disposable;
    private final MergingUpdateQueue visibleAreaChangesQueue;
    private boolean updatingFromBackend;
    private boolean updatingFromFrontend;
    private boolean hasQueuedChanges;
    private SelectionVersion version;
    @NotNull
    private SelectionRange currentSelection;
    private final Editor editor;
    private final TextControlModel editorModel;
    @NotNull
    private final FrontendEditorSuppressor suppressor;
    private final boolean isMaster;
    private static final Logger logger;
    @NotNull
    public static final String PARANOID_CATEGORY = "#com.jetbrains.rider.editors@paranoid";
    private static final Logger paranoidLogger;
    public static final Companion Companion;

    @NotNull
    public final SelectionRange getCurrentSelection() {
        return this.currentSelection;
    }

    private final void setCurrentSelection(SelectionRange selectionRange) {
        this.currentSelection = selectionRange;
    }

    public final void flushSuppressedChanges() {
        if (!this.hasQueuedChanges) {
            return;
        }
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Flushing last queued selection range: " + this.currentSelection + '.';
            logger.trace(string);
        }
        this.performSend(this.currentSelection);
    }

    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Caret is added: selection = ");
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            String string = stringBuilder.append(TextControlsUtilsKt.createSelectionRange(caretModel)).append(", updatingFromBackend = ").append(this.updatingFromBackend).append('.').toString();
            logger.trace(string);
        }
        this.sendSelection();
    }

    public void caretRemoved(@NotNull CaretEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Caret is removed: selection = ");
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            String string = stringBuilder.append(TextControlsUtilsKt.createSelectionRange(caretModel)).append(", updatingFromBackend = ").append(this.updatingFromBackend).append('.').toString();
            logger.trace(string);
        }
        this.sendSelection();
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Caret position changed from frontend to ");
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            String string = stringBuilder.append(TextControlsUtilsKt.createSelectionRange(caretModel)).append(". updatingFromBackend = ").append(this.updatingFromBackend).toString();
            logger.trace(string);
        }
        this.sendSelection();
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Selection changed from frontend to ");
            Editor editor = e.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.editor");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"e.editor.caretModel");
            String string = stringBuilder.append(TextControlsUtilsKt.createSelectionRange(caretModel)).append(". updatingFromBackend = ").append(this.updatingFromBackend).toString();
            logger.trace(string);
        }
        this.sendSelection();
    }

    public final void sendSelection() {
        String string;
        Logger logger;
        if (this.updatingFromBackend) {
            return;
        }
        Logger $receiver$iv = paranoidLogger;
        if ($receiver$iv.isTraceEnabled()) {
            logger = $receiver$iv;
            String string2 = ExceptionUtil.currentStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ExceptionUtil.currentStackTrace()");
            string = string2;
            logger.trace(string);
        }
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        SelectionRange modelSelection = TextControlsUtilsKt.createSelectionRange(caretModel);
        boolean isMajorChange = false;
        this.version = this.isMaster ? SelectionVersionExKt.incrementMaster(this.version, isMajorChange) : SelectionVersionExKt.incrementSlave(this.version);
        this.currentSelection = modelSelection;
        if (this.suppressor.shouldSuppressSendSelection()) {
            Logger $receiver$iv2 = FrontendEditorSynchronizer.logger;
            if ($receiver$iv2.isTraceEnabled()) {
                logger = $receiver$iv2;
                string = "Suppressing selection: " + modelSelection + '.';
                logger.trace(string);
            }
            this.hasQueuedChanges = true;
        } else {
            this.performSend(modelSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performSend(SelectionRange model) {
        try {
            this.updatingFromFrontend = true;
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Sending selection with version " + this.version + " for " + this.editorModel.getContent() + " to anchor: " + model.getSelectionAnchor() + " end:" + model.getActivePosition();
                logger.trace(string);
            }
            this.editorModel.getSelection().set((Object)new SelectionRangeWithVersion(model, this.version));
        }
        finally {
            this.updatingFromFrontend = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveSelection(@NotNull SelectionRangeWithVersion model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        if (this.updatingFromFrontend) {
            return;
        }
        if (this.suppressor.shouldSuppressSendSelection()) {
            logger.debug("Receive change during editor suppressing for " + this.editorModel.getContent().getFilePath() + '.');
        }
        if (SelectionVersionExKt.compareTo(this.version, model.getVersion()) > 0) {
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Rejecting selection (" + model.getSelection().getActivePosition() + " - " + model.getSelection().getSelectionAnchor() + ") with version " + model.getVersion() + '.';
                logger.trace(string);
            }
            return;
        }
        this.version = model.getVersion();
        SelectionRange backendSelection = model.getSelection();
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        if (Intrinsics.areEqual((Object)TextControlsUtilsKt.createSelectionRange(caretModel), (Object)backendSelection)) {
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Skipping equal selection: " + model + '.';
                logger.trace(string);
            }
            return;
        }
        try {
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Applying backend caret change to (" + backendSelection.getActivePosition() + " - " + backendSelection.getSelectionAnchor() + ") with version " + this.version + '.';
                logger.trace(string);
            }
            this.updatingFromBackend = true;
            this.currentSelection = backendSelection;
            TextControlsUtilsKt.applyTo(backendSelection, this.editor);
        }
        finally {
            this.updatingFromBackend = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveScrollingRequest(@NotNull ScrollingInfo backendScrolling) {
        Intrinsics.checkParameterIsNotNull((Object)backendScrolling, (String)"backendScrolling");
        try {
            Logger $receiver$iv = logger;
            if ($receiver$iv.isTraceEnabled()) {
                Logger logger = $receiver$iv;
                String string = "applying backend scrolling to (" + backendScrolling + ')';
                logger.trace(string);
            }
            this.updatingFromBackend = true;
            Integer offset = backendScrolling.getDocOffset();
            ScrollType scrollType = TextControlsUtilsKt.toScrollType(backendScrolling.getKind());
            if (offset != null) {
                LogicalPosition logicalPosition = this.editor.offsetToLogicalPosition(offset.intValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"editor.offsetToLogicalPosition(offset)");
                LogicalPosition pos = logicalPosition;
                this.editor.getScrollingModel().scrollTo(pos, scrollType);
            } else {
                this.editor.getScrollingModel().scrollToCaret(scrollType);
            }
        }
        finally {
            this.updatingFromBackend = false;
        }
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.visibleAreaChangesQueue.queue(new Update(this, "SendViewport"){
            final /* synthetic */ FrontendEditorSynchronizer this$0;

            public void run() {
                VisibleRange value = TextControlsUtilsKt.calculateVisibleRange(FrontendEditorSynchronizer.access$getEditor$p(this.this$0));
                Logger $receiver$iv = FrontendEditorSynchronizer.access$getLogger$cp();
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string = "Sending viewport for: " + FrontendEditorSynchronizer.access$getEditorModel$p(this.this$0).getContent() + " to start: " + value.getStartOffset() + " end:" + value.getEndOffset();
                    logger.trace(string);
                }
                FrontendEditorSynchronizer.access$getEditorModel$p(this.this$0).getVisibleRange().set((Object)value);
            }

            public boolean isDisposed() {
                return FrontendEditorSynchronizer.access$getEditor$p(this.this$0).isDisposed();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Logger $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.editor.isDisposed()) {
            Editor editor = this.editor;
            if (!(editor instanceof EditorImpl)) {
                editor = null;
            }
            EditorImpl editorImpl = (EditorImpl)editor;
            if (editorImpl != null) {
                editorImpl.throwDisposalError("Editor is already disposed");
            } else {
                logger.error("Editor is already disposed.");
            }
        }
        if (($receiver$iv = logger).isTraceEnabled()) {
            Logger logger = $receiver$iv;
            StringBuilder stringBuilder = new StringBuilder().append("Document changed: selection: ");
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            String string = stringBuilder.append(TextControlsUtilsKt.createSelectionRange(caretModel)).append(", updatingFromBackend = ").append(this.updatingFromBackend).append('.').toString();
            logger.trace(string);
        }
        this.sendSelection();
    }

    @Nullable
    public final Integer getTabSize() {
        return (Integer)this.editorModel.getTabSize().getValueOrNull();
    }

    @Nullable
    public final Integer getIndentSize() {
        return (Integer)this.editorModel.getIndentSize().getValueOrNull();
    }

    @Nullable
    public final Boolean getUseTab() {
        return (Boolean)this.editorModel.getUseTab().getValueOrNull();
    }

    public final void setVisible(boolean value) {
        this.editorModel.isVisible().set((Object)value);
    }

    @NotNull
    public final FrontendEditorSuppressor getSuppressor() {
        return this.suppressor;
    }

    public FrontendEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull Editor editor, @NotNull TextControlModel editorModel, @NotNull FrontendEditorSuppressor suppressor, boolean isMaster) {
        Intrinsics.checkParameterIsNotNull((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)editorModel, (String)"editorModel");
        Intrinsics.checkParameterIsNotNull((Object)suppressor, (String)"suppressor");
        this.editor = editor;
        this.editorModel = editorModel;
        this.suppressor = suppressor;
        this.isMaster = isMaster;
        this.disposable = DisposableExKt.createNestedDisposable(textControlLifetime, "textControlLifetime");
        this.visibleAreaChangesQueue = new MergingUpdateQueue("updateViewportQueue", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, this.editor.getComponent(), true);
        this.version = SelectionVersionExKt.getInitVersion();
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        this.currentSelection = TextControlsUtilsKt.createSelectionRange(caretModel);
        this.visibleAreaChangesQueue.setRestartTimerOnAdd(true);
        IOptProperty iOptProperty = this.editorModel.getSelection();
        if (iOptProperty == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.framework.impl.RdOptionalProperty<*>");
        }
        ((RdOptionalProperty)iOptProperty).slave();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FrontendEditorSynchronizer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        FrontendEditorSynchronizer.logger = logger;
        Logger logger2 = Logger.getInstance((String)PARANOID_CATEGORY);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(PARANOID_CATEGORY)");
        paranoidLogger = logger2;
    }

    @NotNull
    public static final /* synthetic */ Editor access$getEditor$p(FrontendEditorSynchronizer $this) {
        return $this.editor;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @NotNull
    public static final /* synthetic */ TextControlModel access$getEditorModel$p(FrontendEditorSynchronizer $this) {
        return $this.editorModel;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdcommon/FrontendEditorSynchronizer$Companion;", "", "()V", "PARANOID_CATEGORY", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "paranoidLogger", "intellij.platform.commercial.rdcommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

