/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.jetbrains.ide.model.CodeStructureTreeNode;
import com.jetbrains.ide.model.CodeStructureTreeNodesList;
import com.jetbrains.ide.model.CodeStructureTree_GeneratedKt;
import com.jetbrains.ide.model.EditableEntityId;
import com.jetbrains.ide.model.EditableEntityPathId;
import com.jetbrains.ide.model.Icon;
import com.jetbrains.ide.model.Solution;
import com.jetbrains.rdserver.LastStructureViewData;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rider.util.reactive.IOptProperty;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/FileStructureHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "solution", "Lcom/jetbrains/ide/model/Solution;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/Solution;)V", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "idToElementMap", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "lastStructureViewData", "Lcom/jetbrains/rdserver/LastStructureViewData;", "convertStructureTree", "", "node", "nodeList", "", "Lcom/jetbrains/ide/model/CodeStructureTreeNode;", "sendFileStructureToFrontend", "", "model", "Lcom/intellij/ide/structureView/StructureViewModel;", "path", "", "updateFileStructure", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Companion", "intellij.platform.commercial.rdserver"})
public final class FileStructureHost {
    private final AtomicInteger idCounter;
    private final TIntObjectHashMap<TreeElement> idToElementMap;
    private LastStructureViewData lastStructureViewData;
    private final Project project;
    private final Solution solution;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    private final void updateFileStructure(VirtualFile file, FileEditor editor) {
        this.idToElementMap.clear();
        StructureViewBuilder structureViewBuilder = StructureViewBuilder.PROVIDER.getStructureViewBuilder(file.getFileType(), file, this.project);
        if (structureViewBuilder == null) {
            IOptProperty iOptProperty = CodeStructureTree_GeneratedKt.getCodeStructureTree((Solution)this.solution).getTreeNodes();
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            iOptProperty.set((Object)new CodeStructureTreeNodesList((EditableEntityId)new EditableEntityPathId(string), CollectionsKt.emptyList()));
            this.lastStructureViewData = null;
            return;
        }
        StructureView structureView = structureViewBuilder.createStructureView(editor, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)structureView, (String)"structureViewBuilder.cre\u2026tureView(editor, project)");
        StructureView structureView2 = structureView;
        StructureViewModel structureViewModel = structureView2.getTreeModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)structureViewModel, (String)"structureView.treeModel");
        StructureViewModel model = structureViewModel;
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        this.lastStructureViewData = new LastStructureViewData(model, string);
        String string2 = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
        this.sendFileStructureToFrontend(model, string2);
    }

    private final void sendFileStructureToFrontend(StructureViewModel model, String path) {
        List nodeList = new ArrayList();
        StructureViewTreeElement structureViewTreeElement = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)structureViewTreeElement, (String)"model.root");
        this.convertStructureTree((TreeElement)structureViewTreeElement, nodeList);
        List finalNodeList = CollectionsKt.filterNotNull((Iterable)nodeList);
        if (finalNodeList.size() != nodeList.size()) {
            LOG.error("Error in tree construction: node list size differs");
            CodeStructureTree_GeneratedKt.getCodeStructureTree((Solution)this.solution).getTreeNodes().set((Object)new CodeStructureTreeNodesList((EditableEntityId)new EditableEntityPathId(path), CollectionsKt.emptyList()));
            return;
        }
        CodeStructureTree_GeneratedKt.getCodeStructureTree((Solution)this.solution).getTreeNodes().set((Object)new CodeStructureTreeNodesList((EditableEntityId)new EditableEntityPathId(path), finalNodeList));
    }

    private final int convertStructureTree(TreeElement node, List<CodeStructureTreeNode> nodeList) {
        int index = nodeList.size();
        nodeList.add(null);
        List childIndexList = new ArrayList();
        TreeElement[] treeElementArray = node.getChildren();
        int n = treeElementArray.length;
        for (int i = 0; i < n; ++i) {
            TreeElement child;
            TreeElement treeElement = child = treeElementArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)treeElement, (String)"child");
            childIndexList.add(this.convertStructureTree(treeElement, nodeList));
        }
        TreeElement treeElement = node;
        if (!(treeElement instanceof StructureViewTreeElement)) {
            treeElement = null;
        }
        StructureViewTreeElement structureViewTreeElement = (StructureViewTreeElement)treeElement;
        Object object = structureViewTreeElement != null ? structureViewTreeElement.getValue() : null;
        if (!(object instanceof PsiElement)) {
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        int n2 = this.idCounter.incrementAndGet();
        boolean bl = psiElement != null;
        PsiElement psiElement2 = psiElement;
        int n3 = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getStartOffset() : 0;
        PsiElement psiElement3 = psiElement;
        int n4 = psiElement3 != null && (psiElement3 = psiElement3.getTextRange()) != null ? psiElement3.getStartOffset() : 0;
        ItemPresentation itemPresentation = node.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemPresentation, (String)"node.presentation");
        String string = itemPresentation.getPresentableText();
        if (string == null) {
            string = "";
        }
        javax.swing.Icon icon = node.getPresentation().getIcon(false);
        CodeStructureTreeNode codeStructureTreeNode = new CodeStructureTreeNode(n2, childIndexList, bl, n3, n4, string, (Icon)(icon != null ? ProtocolConversionsKt.toProtocolModel(icon) : null));
        nodeList.set(index, codeStructureTreeNode);
        RiderExKt.set(this.idToElementMap, codeStructureTreeNode.getId(), node);
        return index;
    }

    public FileStructureHost(@NotNull Project project, @NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"solution");
        this.project = project;
        this.solution = solution;
        this.idCounter = new AtomicInteger();
        this.idToElementMap = new TIntObjectHashMap();
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                VirtualFile virtualFile = event.getNewFile();
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.newFile ?: return");
                VirtualFile newFile = virtualFile;
                FileEditor fileEditor = event.getNewEditor();
                if (fileEditor == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"event.newEditor ?: return");
                FileEditor newEditor = fileEditor;
                this.updateFileStructure(newFile, newEditor);
            }
        });
        CodeStructureTree_GeneratedKt.getCodeStructureTree((Solution)this.solution).getNavigateTo().advise(RiderExKt.toLifetime((Disposable)this.project), (Function1)new Function1<Integer, Unit>(){

            public final void invoke(int id) {
                block1: {
                    Object object = idToElementMap.get(id);
                    if (!(object instanceof Navigatable)) {
                        object = null;
                    }
                    Navigatable navigatable = (Navigatable)object;
                    if (navigatable == null) break block1;
                    navigatable.navigate(true);
                }
            }
        });
        StructureViewComponent.registerPsiListener((Project)this.project, (Disposable)((Disposable)this.project), (Runnable)new Runnable(){

            @Override
            public final void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        block0: {
                            LastStructureViewData lastStructureViewData;
                            LastStructureViewData lastStructureViewData2 = lastStructureViewData;
                            if (lastStructureViewData2 == null) break block0;
                            LastStructureViewData it = lastStructureViewData = lastStructureViewData2;
                            this.sendFileStructureToFrontend(it.getModel(), it.getPath());
                        }
                    }
                });
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileStructureHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FileStructureHost::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setLastStructureViewData$p(FileStructureHost $this, @Nullable LastStructureViewData lastStructureViewData) {
        $this.lastStructureViewData = lastStructureViewData;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/FileStructureHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

