/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.ide.model.EditableEntity;
import com.jetbrains.ide.model.EditableEntityId;
import com.jetbrains.ide.model.EditableEntityPathId;
import com.jetbrains.ide.model.FrontendTextControl;
import com.jetbrains.ide.model.OriginKind;
import com.jetbrains.ide.model.ScrollingInfo;
import com.jetbrains.ide.model.SelectionRangeWithVersion;
import com.jetbrains.ide.model.Solution;
import com.jetbrains.ide.model.TextControlId;
import com.jetbrains.ide.model.TextControlModel;
import com.jetbrains.rdcommon.DisposableExKt;
import com.jetbrains.rdcommon.FrontendEditorSuppressor;
import com.jetbrains.rdcommon.FrontendEditorSynchronizer;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rdserver.editors.DocumentTextHost;
import com.jetbrains.rdserver.editors.EditorsHost;
import com.jetbrains.rdserver.editors.MarkupHost;
import com.jetbrains.rider.rdtext.impl.RdDeferrableTextBuffer;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.Property;
import com.jetbrains.rider.util.reactive.SourceExKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u001c\u0010)\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\u001b2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J(\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001fH\u0002J(\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00068"}, d2={"Lcom/jetbrains/rdserver/editors/EditorsHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "editors", "", "Lcom/jetbrains/ide/model/TextControlId;", "Lcom/intellij/openapi/editor/Editor;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "kotlin.jvm.PlatformType", "focusingEditor", "Lcom/jetbrains/rider/util/reactive/Property;", "", "openingEditor", "solution", "Lcom/jetbrains/ide/model/Solution;", "getSolution", "()Lcom/jetbrains/ide/model/Solution;", "setSolution", "(Lcom/jetbrains/ide/model/Solution;)V", "attach", "", "attachEditorListeners", "editor", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "textControlModel", "Lcom/jetbrains/ide/model/TextControlModel;", "tabLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "dumpBackendTextControls", "", "findEditor", "id", "findIdForExistingEditor", "Lcom/jetbrains/ide/model/EditableEntityId;", "file", "refreshFocusedTextControl", "reportEditorToFrontend", "reportFocusedTextControl", "selectedFile", "selectedEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "watchDocument", "doc", "Lcom/intellij/openapi/editor/Document;", "editableEntityId", "editableEntity", "Lcom/jetbrains/ide/model/EditableEntity;", "lifetime", "watchEditor", "filePath", "textControlId", "Companion", "intellij.platform.commercial.rdserver"})
public final class EditorsHost {
    @NotNull
    public Solution solution;
    private final Map<TextControlId, Editor> editors;
    private boolean openingEditor;
    private Property<Boolean> focusingEditor;
    private final FileEditorManager fileEditorManager;
    private final Project project;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<TextControlId> TEXT_CONTROL_ID_KEY;
    @NotNull
    private static final Key<MarkupHost> MARKUP_HOST_KEY;
    public static final Companion Companion;

    @NotNull
    public final Solution getSolution() {
        Solution solution = this.solution;
        if (solution == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"solution");
        }
        return solution;
    }

    public final void setSolution(@NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"<set-?>");
        this.solution = solution;
    }

    public final void attach(@NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"solution");
        Lifetime lifetime = RiderExKt.toLifetime((Disposable)this.project);
        this.solution = solution;
        solution.getEditors().getDocuments().view(lifetime, (Function3)new Function3<Lifetime, EditableEntityId, EditableEntity, Unit>(this, lifetime){
            final /* synthetic */ EditorsHost this$0;
            final /* synthetic */ Lifetime $lifetime;

            public final void invoke(@NotNull Lifetime lt, @NotNull EditableEntityId editableEntityId, @NotNull EditableEntity editableEntity) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)editableEntityId, (String)"editableEntityId");
                Intrinsics.checkParameterIsNotNull((Object)editableEntity, (String)"editableEntity");
                String filePath = editableEntityId.getFilePath();
                VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(filePath));
                if (vFile != null) {
                    Document doc = FileDocumentManager.getInstance().getDocument(vFile);
                    if (doc != null) {
                        EditorsHost.access$watchDocument(this.this$0, doc, editableEntityId, editableEntity, lt);
                    } else {
                        EditorsHost.Companion.getLOG().info("No document for " + filePath);
                    }
                } else {
                    EditorsHost.Companion.getLOG().info("No virtual file for " + filePath);
                }
                editableEntity.getTextControls().view(this.$lifetime, (Function3)new Function3<Lifetime, TextControlId, TextControlModel, Unit>(this, filePath){
                    final /* synthetic */ attach.1 this$0;
                    final /* synthetic */ String $filePath;

                    public final void invoke(@NotNull Lifetime tabLifetime, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel) {
                        Intrinsics.checkParameterIsNotNull((Object)tabLifetime, (String)"tabLifetime");
                        Intrinsics.checkParameterIsNotNull((Object)textControlId, (String)"textControlId");
                        Intrinsics.checkParameterIsNotNull((Object)textControlModel, (String)"textControlModel");
                        EditorsHost.access$watchEditor(this.this$0.this$0, this.$filePath, textControlId, tabLifetime, textControlModel);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$filePath = string;
                        super(3);
                    }
                });
            }
            {
                this.this$0 = editorsHost;
                this.$lifetime = lifetime;
                super(3);
            }
        });
        solution.getEditors().getCheckInternalState().advise(lifetime, (Function1)new Function1<FrontendTextControl, Unit>(this){
            final /* synthetic */ EditorsHost this$0;

            public final void invoke(@NotNull FrontendTextControl it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Editor editor = (Editor)EditorsHost.access$getEditors$p(this.this$0).get(it.getId());
                if (editor == null) {
                    throw (Throwable)new IllegalStateException("No backend editor for frontend text control " + it);
                }
                Editor editor2 = editor;
                SelectionModel selectionModel = editor2.getSelectionModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
                int n = selectionModel.getSelectionStart();
                SelectionModel selectionModel2 = editor2.getSelectionModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
                TextRange selectedTextRange = new TextRange(n, selectionModel2.getSelectionEnd());
                if (Intrinsics.areEqual((Object)ProtocolConversionsKt.toSelectionRange(selectedTextRange), (Object)it.getFrontendState().getSelection()) ^ true) {
                    throw (Throwable)new IllegalStateException("Inconsistent selection range: expected " + it.getFrontendState().getSelection() + ", actual " + selectedTextRange);
                }
            }
            {
                this.this$0 = editorsHost;
                super(1);
            }
        });
        solution.getEditors().getDumpBackendTextControls().set((Function1)new Function1<Boolean, String>(this){
            final /* synthetic */ EditorsHost this$0;

            @NotNull
            public final String invoke(boolean precisePaths) {
                return EditorsHost.access$dumpBackendTextControls(this.this$0);
            }
            {
                this.this$0 = editorsHost;
                super(1);
            }
        });
        IProperty focusedTextControlSession = solution.getEditors().getFocusedTextControlSession();
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ EditorsHost this$0;

            /*
             * WARNING - void declaration
             */
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                void $receiver$iv$iv;
                FileEditor[] $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (EditorsHost.access$getOpeningEditor$p(this.this$0)) {
                    return;
                }
                FileEditor[] fileEditorArray = source.getAllEditors(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorArray, (String)"source.getAllEditors(file)");
                FileEditor[] fileEditorArray2 = $receiver$iv = fileEditorArray;
                Collection destination$iv$iv = new ArrayList<E>();
                for (void element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof TextEditor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                TextEditor textEditor = (TextEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (textEditor != null) {
                    Editor editor = textEditor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor.editor");
                    EditorsHost.access$reportEditorToFrontend(this.this$0, file, editor);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (EditorsHost.access$getOpeningEditor$p(this.this$0)) {
                    return;
                }
                EditorsHost.access$reportFocusedTextControl(this.this$0, event.getNewFile(), event.getNewEditor());
            }
            {
                this.this$0 = $outer;
            }
        });
        SourceExKt.adviseNotNull((ISource)focusedTextControlSession.getChange(), (Lifetime)lifetime, (Function1)((Function1)new Function1<TextControlId, Unit>(this){
            final /* synthetic */ EditorsHost this$0;

            public final void invoke(@NotNull TextControlId textControlId) {
                Intrinsics.checkParameterIsNotNull((Object)textControlId, (String)"textControlId");
                String filePath = textControlId.getDocumentId().getFilePath();
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(filePath);
                if (vFile == null) {
                    EditorsHost.Companion.getLOG().info("Trying to focus editor for non-existing virtual file: " + filePath);
                    return;
                }
                RiderExKt.noReenter((Property<Boolean>)EditorsHost.access$getFocusingEditor$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this, vFile){
                    final /* synthetic */ attach.5 this$0;
                    final /* synthetic */ VirtualFile $vFile;

                    public final void invoke() {
                        FileEditorManager fileEditorManager = EditorsHost.access$getFileEditorManager$p(this.this$0.this$0);
                        TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)textEditorProvider, (String)"TextEditorProvider.getInstance()");
                        fileEditorManager.setSelectedEditor(this.$vFile, textEditorProvider.getEditorTypeId());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$vFile = virtualFile;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = editorsHost;
                super(1);
            }
        }));
        solution.getEditors().isReady().set((Object)true);
    }

    private final void reportFocusedTextControl(VirtualFile selectedFile, FileEditor selectedEditor) {
        RiderExKt.noReenter(this.focusingEditor, (Function0<Unit>)((Function0)new Function0<Unit>(this, selectedFile, selectedEditor){
            final /* synthetic */ EditorsHost this$0;
            final /* synthetic */ VirtualFile $selectedFile;
            final /* synthetic */ FileEditor $selectedEditor;

            public final void invoke() {
                TextEditor textEditor;
                VirtualFile virtualFile = this.$selectedFile;
                if (virtualFile == null) {
                    return;
                }
                VirtualFile newFile = virtualFile;
                if (EditorsHost.access$findIdForExistingEditor(this.this$0, newFile) == null) {
                    return;
                }
                FileEditor fileEditor = this.$selectedEditor;
                if (!(fileEditor instanceof TextEditor)) {
                    fileEditor = null;
                }
                if ((textEditor = (TextEditor)fileEditor) == null || (textEditor = textEditor.getEditor()) == null || (textEditor = (TextControlId)textEditor.getUserData(EditorsHost.Companion.getTEXT_CONTROL_ID_KEY())) == null) {
                    String string = newFile.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newFile.path");
                    textEditor = new TextControlId((EditableEntityId)new EditableEntityPathId(string), 0);
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)textEditor, (String)"(selectedEditor as? Text\u2026yPathId(newFile.path), 0)");
                TextEditor textControlId = textEditor;
                this.this$0.getSolution().getEditors().getFocusedTextControlSession().set((Object)textControlId);
            }
            {
                this.this$0 = editorsHost;
                this.$selectedFile = virtualFile;
                this.$selectedEditor = fileEditor;
                super(0);
            }
        }));
    }

    private final String dumpBackendTextControls() {
        Object $receiver$iv;
        StringBuilder stringBuilder;
        StringBuilder $receiver;
        FileEditorManager fileEditorManager = this.fileEditorManager;
        StringBuilder stringBuilder2 = $receiver = (stringBuilder = new StringBuilder());
        String string = "IDEA backend text controls:";
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        FileEditorManager fileEditorManager2 = fileEditorManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2, (String)"fileEditorManager");
        Object[] objectArray = fileEditorManager2.getAllEditors();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"fileEditorManager.allEditors");
        Object object = $receiver$iv = objectArray;
        Object object2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                FileEditor it;
                FileEditor fileEditor = it = (FileEditor)a;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"it");
                VirtualFile virtualFile = fileEditor.getFile();
                it = (FileEditor)b;
                Comparable comparable = (Comparable)((Object)(virtualFile != null ? virtualFile.getPath() : null));
                FileEditor fileEditor2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor2, (String)"it");
                VirtualFile virtualFile2 = fileEditor2.getFile();
                String string = virtualFile2 != null ? virtualFile2.getPath() : null;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (FileEditor fileEditor : ArraysKt.sortedWith((Object[])object, (Comparator)object2)) {
            LogicalPosition pos;
            Editor editor;
            $receiver$iv = $receiver;
            StringBuilder stringBuilder4 = new StringBuilder().append("Name: ");
            FileEditor fileEditor2 = fileEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor2, (String)"fileEditor");
            object = stringBuilder4.append(fileEditor2.getName()).toString();
            StringBuilder stringBuilder5 = ((StringBuilder)$receiver$iv).append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            FileEditor fileEditor3 = fileEditor;
            if (!(fileEditor3 instanceof TextEditor)) {
                fileEditor3 = null;
            }
            TextEditor textEditor = (TextEditor)fileEditor3;
            Object object3 = editor = textEditor != null ? textEditor.getEditor() : null;
            if (editor == null) {
                object = $receiver;
                object2 = "no Editor associated with this FileEditor";
                StringBuilder stringBuilder6 = ((StringBuilder)object).append((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                continue;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            object2 = $receiver;
            StringBuilder stringBuilder7 = new StringBuilder().append("Virtual file: ");
            Object object4 = virtualFile;
            if (object4 == null || (object4 = object4.getName()) == null) {
                object4 = "null file";
            }
            CharSequence $i$f$sortedBy = stringBuilder7.append((String)object4).toString();
            StringBuilder stringBuilder8 = ((StringBuilder)object2).append((String)$i$f$sortedBy);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel.getLogicalPosition(), (String)"editor.caretModel.logicalPosition");
            $i$f$sortedBy = $receiver;
            String string2 = "Current caret: (" + pos.line + ", " + pos.column + ')';
            StringBuilder stringBuilder9 = ((StringBuilder)$i$f$sortedBy).append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder9, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder9);
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
            VisualPosition selectionStart = selectionModel.getSelectionStartPosition();
            SelectionModel selectionModel2 = editor.getSelectionModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
            VisualPosition selectionEnd = selectionModel2.getSelectionEndPosition();
            StringBuilder stringBuilder10 = $receiver;
            VisualPosition visualPosition = selectionStart;
            VisualPosition visualPosition2 = selectionStart;
            VisualPosition visualPosition3 = selectionEnd;
            VisualPosition visualPosition4 = selectionEnd;
            String string3 = "Current selection:  startPosition = (" + (visualPosition != null ? Integer.valueOf(visualPosition.line) : null) + ", " + (visualPosition2 != null ? Integer.valueOf(visualPosition2.column) : null) + ") endPosition = (" + (visualPosition3 != null ? Integer.valueOf(visualPosition3.line) : null) + ", " + (visualPosition4 != null ? Integer.valueOf(visualPosition4.column) : null) + ')';
            StringBuilder stringBuilder11 = stringBuilder10.append(string3);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder11, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder11);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    @Nullable
    public final Editor findEditor(@NotNull TextControlId id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.editors.get(id);
    }

    private final void watchDocument(Document doc, EditableEntityId editableEntityId, EditableEntity editableEntity, Lifetime lifetime) {
        doc.putUserData(MARKUP_HOST_KEY, (Object)new MarkupHost(this.project, doc, editableEntityId, editableEntity, lifetime));
        RLifetimeKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>(doc){
            final /* synthetic */ Document $doc;

            public final void invoke() {
                this.$doc.putUserData(EditorsHost.Companion.getMARKUP_HOST_KEY(), null);
            }
            {
                this.$doc = document;
                super(0);
            }
        }));
        new DocumentTextHost(this.project, doc, editableEntity, lifetime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void watchEditor(String filePath, TextControlId textControlId, Lifetime tabLifetime, TextControlModel textControlModel) {
        Object object;
        LOG.info("Added editor for " + filePath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(filePath));
        if (virtualFile == null) {
            EditorsHost editorsHost;
            EditorsHost $receiver = editorsHost = this;
            LOG.info("No virtual file for " + filePath + '!');
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ath!\")\n      return\n    }");
        VirtualFile vFile = virtualFile;
        LOG.info("Opening editor for " + filePath);
        this.openingEditor = true;
        try {
            object = this.fileEditorManager.openTextEditor(new OpenFileDescriptor(this.project, vFile), true);
        }
        finally {
            this.openingEditor = false;
        }
        Editor editor = object;
        if (editor == null) {
            LOG.info("No text editor for " + filePath);
            return;
        }
        object = this.editors;
        Editor editor2 = editor;
        object.put(textControlId, editor2);
        editor.putUserData(TEXT_CONTROL_ID_KEY, (Object)textControlId);
        this.attachEditorListeners(editor, vFile, textControlModel, tabLifetime);
        this.refreshFocusedTextControl();
        RLifetimeKt.plusAssign((Lifetime)tabLifetime, (Function0)((Function0)new Function0<Unit>(this, textControlId, filePath, vFile){
            final /* synthetic */ EditorsHost this$0;
            final /* synthetic */ TextControlId $textControlId;
            final /* synthetic */ String $filePath;
            final /* synthetic */ VirtualFile $vFile;

            public final void invoke() {
                EditorsHost.access$getEditors$p(this.this$0).remove(this.$textControlId);
                EditorsHost.Companion.getLOG().info("Closing editor for " + this.$filePath);
                EditorsHost.access$getFileEditorManager$p(this.this$0).closeFile(this.$vFile);
            }
            {
                this.this$0 = editorsHost;
                this.$textControlId = textControlId;
                this.$filePath = string;
                this.$vFile = virtualFile;
                super(0);
            }
        }));
    }

    private final void refreshFocusedTextControl() {
        block0: {
            VirtualFile virtualFile;
            FileEditorManager fileEditorManager = this.fileEditorManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"fileEditorManager");
            Object[] objectArray = fileEditorManager.getSelectedFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"fileEditorManager.selectedFiles");
            VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
            if (virtualFile2 == null) break block0;
            VirtualFile it = virtualFile = virtualFile2;
            FileEditorManager fileEditorManager2 = this.fileEditorManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2, (String)"fileEditorManager");
            this.reportFocusedTextControl(it, fileEditorManager2.getSelectedEditor());
        }
    }

    private final void reportEditorToFrontend(VirtualFile file, Editor editor) {
        Object object;
        EditableEntityId editableEntityId = this.findIdForExistingEditor(file);
        if (editableEntityId == null) {
            EditorsHost editorsHost;
            EditorsHost $receiver = editorsHost = this;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            EditableEntityPathId newEditableEntityId = new EditableEntityPathId(string);
            EditableEntity editableEntity = new EditableEntity(null);
            RdDeferrableTextBuffer rdDeferrableTextBuffer = editableEntity.getText();
            Document document = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            String string2 = document.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"editor.document.text");
            rdDeferrableTextBuffer.reset(string2);
            Solution solution = $receiver.solution;
            if (solution == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"solution");
            }
            object = (Map)solution.getEditors().getDocuments();
            EditableEntity editableEntity2 = editableEntity;
            object.put(newEditableEntityId, editableEntity2);
            editableEntityId = (EditableEntityId)newEditableEntityId;
        }
        EditableEntityId editableEntityId2 = editableEntityId;
        Solution solution = this.solution;
        if (solution == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"solution");
        }
        Object object2 = solution.getEditors().getDocuments().get((Object)editableEntityId2);
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        EditableEntity documentModel = (EditableEntity)object2;
        TextControlId textControlId = new TextControlId(editableEntityId2, 0);
        TextControlModel textControlModel = new TextControlModel(editableEntityId2, OriginKind.Backend);
        Map map = (Map)documentModel.getTextControls();
        object = textControlModel;
        map.put(textControlId, object);
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        }
        Disposer.register((Disposable)((EditorImpl)editor2).getDisposable(), (Disposable)new Disposable(documentModel, textControlId){
            final /* synthetic */ EditableEntity $documentModel;
            final /* synthetic */ TextControlId $textControlId;

            public final void dispose() {
                this.$documentModel.getTextControls().remove((Object)this.$textControlId);
            }
            {
                this.$documentModel = editableEntity;
                this.$textControlId = textControlId;
            }
        });
        this.attachEditorListeners(editor, file, textControlModel, Lifetime.Companion.getEternal());
    }

    private final EditableEntityId findIdForExistingEditor(VirtualFile file) {
        Object v1;
        block2: {
            Iterable iterable;
            Solution solution = this.solution;
            if (solution == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"solution");
            }
            Iterable iterable2 = iterable = (Iterable)solution.getEditors().getDocuments().keySet();
            for (Object t : iterable2) {
                EditableEntityId it = (EditableEntityId)t;
                if (!Intrinsics.areEqual((Object)it.getFilePath(), (Object)file.getPath())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private final void attachEditorListeners(Editor editor, VirtualFile vFile, TextControlModel textControlModel, Lifetime tabLifetime) {
        Disposable textControlDisposable = DisposableExKt.createNestedDisposable(tabLifetime, "Disposable for lifetime of a model textControl: " + textControlModel);
        FrontendEditorSuppressor suppressor = new FrontendEditorSuppressor();
        FrontendEditorSynchronizer editorSynchronizer = new FrontendEditorSynchronizer(tabLifetime, editor, textControlModel, suppressor, false);
        suppressor.onRelease(tabLifetime, (Function0<Unit>)((Function0)new Function0<Unit>(editorSynchronizer){
            final /* synthetic */ FrontendEditorSynchronizer $editorSynchronizer;

            public final void invoke() {
                this.$editorSynchronizer.flushSuppressedChanges();
            }
            {
                this.$editorSynchronizer = frontendEditorSynchronizer;
                super(0);
            }
        }));
        textControlModel.getSelection().advise(tabLifetime, (Function1)new Function1<SelectionRangeWithVersion, Unit>(editorSynchronizer){
            final /* synthetic */ FrontendEditorSynchronizer $editorSynchronizer;

            public final void invoke(@NotNull SelectionRangeWithVersion it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$editorSynchronizer.receiveSelection(it);
            }
            {
                this.$editorSynchronizer = frontendEditorSynchronizer;
                super(1);
            }
        });
        editor.getSelectionModel().addSelectionListener((SelectionListener)editorSynchronizer, textControlDisposable);
        editor.getCaretModel().addCaretListener((CaretListener)editorSynchronizer, textControlDisposable);
        editor.getDocument().addDocumentListener((DocumentListener)editorSynchronizer, textControlDisposable);
        textControlModel.getScrolling().advise(tabLifetime, (Function1)new Function1<ScrollingInfo, Unit>(editorSynchronizer){
            final /* synthetic */ FrontendEditorSynchronizer $editorSynchronizer;

            public final void invoke(@NotNull ScrollingInfo it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$editorSynchronizer.receiveScrollingRequest(it);
            }
            {
                this.$editorSynchronizer = frontendEditorSynchronizer;
                super(1);
            }
        });
        editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)editorSynchronizer);
        tabLifetime.add((Function0)new Function0<Unit>(editor, editorSynchronizer){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ FrontendEditorSynchronizer $editorSynchronizer;

            public final void invoke() {
                this.$editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this.$editorSynchronizer);
            }
            {
                this.$editor = editor;
                this.$editorSynchronizer = frontendEditorSynchronizer;
                super(0);
            }
        });
        MarkupModel markupModel = editor.getMarkupModel();
        if (markupModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        }
        ((MarkupModelEx)markupModel).addMarkupModelListener(RiderExKt.toDisposable(tabLifetime), new MarkupModelListener(){

            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
            }

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                EditorsHost.Companion.getLOG().info("Added editor highlighter: " + highlighter);
            }
        });
        MarkupHost markupHost = (MarkupHost)editor.getDocument().getUserData(MARKUP_HOST_KEY);
        if (markupHost != null) {
            markupHost.watchEditor(editor, tabLifetime);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        if (foldingModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.FoldingModelEx");
        }
        ((FoldingModelEx)foldingModel).addListener(new FoldingListener(editor){
            final /* synthetic */ Editor $editor;

            public void onFoldRegionStateChange(@NotNull FoldRegion region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                MarkupHost markupHost = (MarkupHost)this.$editor.getDocument().getUserData(EditorsHost.Companion.getMARKUP_HOST_KEY());
                if (markupHost == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)markupHost, (String)"editor.document.getUserD\u2026ARKUP_HOST_KEY) ?: return");
                MarkupHost markupHost2 = markupHost;
                markupHost2.reportFoldRegion(region);
            }

            public void beforeFoldRegionRemoved(@NotNull FoldRegion region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                MarkupHost markupHost = (MarkupHost)this.$editor.getDocument().getUserData(EditorsHost.Companion.getMARKUP_HOST_KEY());
                if (markupHost == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)markupHost, (String)"editor.document.getUserD\u2026ARKUP_HOST_KEY) ?: return");
                MarkupHost markupHost2 = markupHost;
                markupHost2.removeFoldRegion(region);
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        }, RiderExKt.toDisposable(tabLifetime));
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(vFile);
        if (psiFile != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
        }
    }

    public EditorsHost(@NotNull Project project) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        EditorsHost editorsHost = this;
        editorsHost.editors = map = (Map)new LinkedHashMap();
        this.focusingEditor = new Property((Object)false);
        this.fileEditorManager = FileEditorManager.getInstance((Project)this.project);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(EditorsHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(EditorsHost::class.java)");
        LOG = logger;
        Key key = Key.create((String)"RdServer.textControlId");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<TextControlId\u2026\"RdServer.textControlId\")");
        TEXT_CONTROL_ID_KEY = key;
        Key key2 = Key.create((String)"RdServer.markupHost");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<MarkupHost>(\"RdServer.markupHost\")");
        MARKUP_HOST_KEY = key2;
    }

    public static final /* synthetic */ void access$watchDocument(EditorsHost $this, @NotNull Document doc, @NotNull EditableEntityId editableEntityId, @NotNull EditableEntity editableEntity, @NotNull Lifetime lifetime) {
        $this.watchDocument(doc, editableEntityId, editableEntity, lifetime);
    }

    public static final /* synthetic */ void access$watchEditor(EditorsHost $this, @NotNull String filePath, @NotNull TextControlId textControlId, @NotNull Lifetime tabLifetime, @NotNull TextControlModel textControlModel) {
        $this.watchEditor(filePath, textControlId, tabLifetime, textControlModel);
    }

    @NotNull
    public static final /* synthetic */ Map access$getEditors$p(EditorsHost $this) {
        return $this.editors;
    }

    @NotNull
    public static final /* synthetic */ String access$dumpBackendTextControls(EditorsHost $this) {
        return $this.dumpBackendTextControls();
    }

    public static final /* synthetic */ boolean access$getOpeningEditor$p(EditorsHost $this) {
        return $this.openingEditor;
    }

    public static final /* synthetic */ void access$setOpeningEditor$p(EditorsHost $this, boolean bl) {
        $this.openingEditor = bl;
    }

    public static final /* synthetic */ void access$reportEditorToFrontend(EditorsHost $this, @NotNull VirtualFile file, @NotNull Editor editor) {
        $this.reportEditorToFrontend(file, editor);
    }

    public static final /* synthetic */ void access$reportFocusedTextControl(EditorsHost $this, @Nullable VirtualFile selectedFile, @Nullable FileEditor selectedEditor) {
        $this.reportFocusedTextControl(selectedFile, selectedEditor);
    }

    @NotNull
    public static final /* synthetic */ Property access$getFocusingEditor$p(EditorsHost $this) {
        return $this.focusingEditor;
    }

    public static final /* synthetic */ void access$setFocusingEditor$p(EditorsHost $this, @NotNull Property property) {
        $this.focusingEditor = property;
    }

    public static final /* synthetic */ FileEditorManager access$getFileEditorManager$p(EditorsHost $this) {
        return $this.fileEditorManager;
    }

    @Nullable
    public static final /* synthetic */ EditableEntityId access$findIdForExistingEditor(EditorsHost $this, @NotNull VirtualFile file) {
        return $this.findIdForExistingEditor(file);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/editors/EditorsHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MARKUP_HOST_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rdserver/editors/MarkupHost;", "kotlin.jvm.PlatformType", "getMARKUP_HOST_KEY", "()Lcom/intellij/openapi/util/Key;", "TEXT_CONTROL_ID_KEY", "Lcom/jetbrains/ide/model/TextControlId;", "getTEXT_CONTROL_ID_KEY", "getInstance", "Lcom/jetbrains/rdserver/editors/EditorsHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final EditorsHost getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, EditorsHost.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (EditorsHost)object;
        }

        @NotNull
        public final Key<TextControlId> getTEXT_CONTROL_ID_KEY() {
            return TEXT_CONTROL_ID_KEY;
        }

        @NotNull
        public final Key<MarkupHost> getMARKUP_HOST_KEY() {
            return MARKUP_HOST_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

