/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nullable;

public class StrutsConventionImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiClass) {
            return StrutsConventionImplicitUsageProvider.isConventionActionClass((PsiClass)element);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StrutsConventionImplicitUsageProvider.checkMethod(psiMethod)) {
                return false;
            }
            return StrutsConventionImplicitUsageProvider.isAnnotatedWithAction((PsiModifierListOwner)psiMethod) || StrutsConventionImplicitUsageProvider.isConventionActionClass(psiMethod.getContainingClass());
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }

    private static boolean checkMethod(PsiMethod psiMethod) {
        return psiMethod.hasModifierProperty("public") && !psiMethod.isConstructor() && !psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("abstract");
    }

    private static boolean isAnnotatedWithAction(PsiModifierListOwner psiModifierListOwner) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiModifierListOwner, (String)"org.apache.struts2.convention.annotation.Action", (int)0);
    }

    private static boolean isConventionActionClass(@Nullable PsiClass psiClass) {
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum() || psiClass.isAnnotationType() || !psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (StrutsConventionImplicitUsageProvider.isAnnotatedWithAction((PsiModifierListOwner)psiClass)) {
            return true;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.apache.struts2.convention.annotation.Actions", (int)0)) {
            return true;
        }
        if (!StrutsConventionImplicitUsageProvider.isConventionPluginPresent((PsiElement)psiClass)) {
            return false;
        }
        if (StringUtil.endsWith((CharSequence)psiClass.getName(), (CharSequence)"Action")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.opensymphony.xwork2.Action");
    }

    private static boolean isConventionPluginPresent(PsiElement element) {
        PsiClass conventionService = JavaPsiFacade.getInstance((Project)element.getProject()).findClass("org.apache.struts2.convention.ConventionsService", element.getResolveScope());
        return conventionService != null;
    }
}

