/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.inspection.ValidatorBase;
import com.intellij.struts2.dom.inspection.ValidatorConfigModelInspection;
import com.intellij.struts2.dom.inspection.ValidatorModelInspection;
import com.intellij.struts2.dom.validator.ValidatorManager;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValidatorModelValidator
extends ValidatorBase {
    @NonNls
    private static final String FILENAME_EXTENSION_VALIDATION_XML = "-validation.xml";

    public ValidatorModelValidator() {
        super(StrutsBundle.message("inspections.validator.model.validator", new Object[0]), StrutsBundle.message("inspections.validator.model.validator.progress", new Object[0]));
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ValidatorManager validatorManager = ValidatorManager.getInstance(project);
        Map enabledForModule = FactoryMap.create(module1 -> this.isEnabledForModule((Module)module1) && StrutsFacet.getInstance(module1) != null);
        THashSet files = new THashSet();
        for (VirtualFile file : context.getProjectCompileScope().getFiles((FileType)StdFileTypes.XML, true)) {
            Module module;
            PsiFile psiFile;
            if (!StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)FILENAME_EXTENSION_VALIDATION_XML) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile) || !validatorManager.isValidatorsFile((XmlFile)psiFile) || (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null || !((Boolean)enabledForModule.get(module)).booleanValue()) continue;
            files.add(file);
        }
        THashSet descriptorFiles = new THashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            XmlFile psiFile;
            if (!((Boolean)enabledForModule.get(module)).booleanValue() || (psiFile = validatorManager.getValidatorConfigFile(module)) == null || !validatorManager.isCustomValidatorConfigFile((PsiFile)psiFile)) continue;
            InspectionValidatorUtil.addFile((Collection)descriptorFiles, (PsiFile)psiFile);
        }
        files.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)descriptorFiles, (CompileContext)context));
        return files;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new Class[]{ValidatorModelInspection.class, ValidatorConfigModelInspection.class};
        if (classArray == null) {
            ValidatorModelValidator.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/inspection/ValidatorModelValidator", "getInspectionToolClasses"));
    }
}

