/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.PsiClassNavigation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditMultipleSourcesAction
extends AnAction {
    @Nullable
    private final Runnable myNavigationCallback;

    public EditMultipleSourcesAction() {
        this(null);
    }

    public EditMultipleSourcesAction(@Nullable Runnable navigationCallback) {
        this.myNavigationCallback = navigationCallback;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(ActionsBundle.actionText((String)"EditSource"));
        presentation.setIcon(AllIcons.Actions.EditSource);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            EditMultipleSourcesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Navigatable[] navigatables = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables != null && navigatables.length > 0) {
            e.getPresentation().setEnabled(true);
            if (navigatables.length > 1) {
                e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource") + "...");
            } else {
                e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource"));
            }
        } else {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setText(ActionsBundle.actionText((String)"EditSource"));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditMultipleSourcesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Navigatable[] files = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        assert (files != null && files.length > 0);
        if (files.length > 1) {
            DefaultListModel<PsiFile> listModel = new DefaultListModel<PsiFile>();
            for (int i = 0; i < files.length; ++i) {
                assert (files[i] instanceof PsiClassNavigation);
                listModel.add(i, ((PsiClassNavigation)files[i]).getPsiFile());
            }
            JBList list = new JBList(listModel);
            int width = WindowManager.getInstance().getFrame((Project)project).getSize().width;
            list.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
            JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Target File").setItemChoosenCallback(() -> {
                Object selectedValue = list.getSelectedValue();
                PsiClassNavigation navigationWrapper = null;
                for (Navigatable file : files) {
                    if (selectedValue != ((PsiClassNavigation)file).getPsiFile()) continue;
                    navigationWrapper = (PsiClassNavigation)file;
                    break;
                }
                assert (navigationWrapper != null);
                if (navigationWrapper.canNavigate()) {
                    if (this.myNavigationCallback != null) {
                        this.myNavigationCallback.run();
                    }
                    navigationWrapper.navigate(true);
                }
            }).createPopup();
            if (e.getInputEvent().getSource() instanceof ActionButton) {
                popup2.showUnderneathOf((Component)((ActionButton)e.getInputEvent().getSource()));
            } else {
                popup2.showInBestPositionFor(e.getDataContext());
            }
        } else {
            assert (files[0] instanceof PsiClassNavigation);
            PsiClassNavigation file = (PsiClassNavigation)files[0];
            if (file.canNavigate()) {
                if (this.myNavigationCallback != null) {
                    this.myNavigationCallback.run();
                }
                file.navigate(true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/android/tools/idea/actions/EditMultipleSourcesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

