/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.io.IAbstractFile;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.sdklib.FileOpFileWrapper;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdNameVerifier;
import com.android.tools.idea.avdmanager.AvdNetworkLatency;
import com.android.tools.idea.avdmanager.AvdNetworkSpeed;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.ChooseDeviceDefinitionStep;
import com.android.tools.idea.avdmanager.ChooseSystemImageStep;
import com.android.tools.idea.avdmanager.ConfigureAvdOptionsStep;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.device.DeviceArtDescriptor;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvdWizardUtils {
    public static final String WIZARD_ONLY = "AvdManager.WizardOnly.";
    public static final String DEVICE_DEFINITION_KEY = "AvdManager.WizardOnly.DeviceDefinition";
    public static final String SYSTEM_IMAGE_KEY = "AvdManager.WizardOnly.SystemImage";
    public static final String RAM_STORAGE_KEY = "hw.ramSize";
    public static final String VM_HEAP_STORAGE_KEY = "vm.heapSize";
    public static final String INTERNAL_STORAGE_KEY = "disk.dataPartition.size";
    public static final String SD_CARD_STORAGE_KEY = "sdcard.size";
    public static final String EXISTING_SD_LOCATION = "sdcard.path";
    public static final String DISPLAY_SD_SIZE_KEY = "AvdManager.WizardOnly.displaySdCardSize";
    public static final String DISPLAY_SD_LOCATION_KEY = "AvdManager.WizardOnly.displaySdLocation";
    public static final String DISPLAY_USE_EXTERNAL_SD_KEY = "AvdManager.WizardOnly.displayUseExistingSd";
    public static final String DEFAULT_ORIENTATION_KEY = "AvdManager.WizardOnly.DefaultOrientation";
    public static final String AVD_INI_NETWORK_SPEED = "runtime.network.speed";
    public static final String NETWORK_SPEED_KEY = "runtime.network.speed";
    public static final String AVD_INI_NETWORK_LATENCY = "runtime.network.latency";
    public static final String NETWORK_LATENCY_KEY = "runtime.network.latency";
    public static final String FRONT_CAMERA_KEY = "hw.camera.front";
    public static final String BACK_CAMERA_KEY = "hw.camera.back";
    public static final String USE_HOST_GPU_KEY = "hw.gpu.enabled";
    public static final String HOST_GPU_MODE_KEY = "hw.gpu.mode";
    public static final String USE_COLD_BOOT = "fastboot.forceColdBoot";
    public static final String COLD_BOOT_ONCE_VALUE = "once";
    public static final String IS_IN_EDIT_MODE_KEY = "AvdManager.WizardOnly.isInEditMode";
    public static final String CUSTOM_SKIN_FILE_KEY = "skin.path";
    public static final String BACKUP_SKIN_FILE_KEY = "skin.path.backup";
    public static final String DEVICE_FRAME_KEY = "showDeviceFrame";
    public static final String DISPLAY_NAME_KEY = "avd.ini.displayname";
    public static final String AVD_ID_KEY = "AvdId";
    public static final String CPU_CORES_KEY = "hw.cpu.ncore";
    public static final String HAS_HARDWARE_KEYBOARD_KEY = "hw.keyboard";
    public static final AvdNetworkSpeed DEFAULT_NETWORK_SPEED = AvdNetworkSpeed.FULL;
    public static final AvdNetworkLatency DEFAULT_NETWORK_LATENCY = AvdNetworkLatency.NONE;
    public static final Storage DEFAULT_INTERNAL_STORAGE = new Storage(800L, Storage.Unit.MiB);
    public static final Font STANDARD_FONT = JBFont.create((Font)new Font("Sans", 0, 12));
    public static final Font FIGURE_FONT = JBFont.create((Font)new Font("Sans", 0, 10));
    public static final Font TITLE_FONT = JBFont.create((Font)new Font("Sans", 1, 16));
    public static final List<IdDisplay> ALL_DEVICE_TAGS = ImmutableList.of((Object)SystemImage.DEFAULT_TAG, (Object)SystemImage.WEAR_TAG, (Object)SystemImage.TV_TAG, (Object)SystemImage.CHROMEOS_TAG);
    public static final List<IdDisplay> TAGS_WITH_GOOGLE_API = ImmutableList.of((Object)SystemImage.GOOGLE_APIS_TAG, (Object)SystemImage.GOOGLE_APIS_X86_TAG, (Object)SystemImage.PLAY_STORE_TAG, (Object)SystemImage.TV_TAG, (Object)SystemImage.WEAR_TAG, (Object)SystemImage.CHROMEOS_TAG);
    public static final String CREATE_SKIN_HELP_LINK = "http://developer.android.com/tools/devices/managing-avds.html#skins";
    public static final File NO_SKIN = new File("_no_skin");
    private static final Dimension AVD_WIZARD_MIN_SIZE = JBUI.size((int)600, (int)400);
    private static final Dimension AVD_WIZARD_SIZE = JBUI.size((int)1000, (int)650);
    private static final String AVD_WIZARD_HELP_URL = "https://developer.android.com/r/studio-ui/avd-manager.html";
    private static final int MAX_RAM_MB = 1536;
    private static Map<String, HardwareProperties.HardwareProperty> ourHardwareProperties;

    private static Logger getLog() {
        return Logger.getInstance(AvdWizardUtils.class);
    }

    @NotNull
    public static Storage getDefaultRam(@NotNull Hardware hardware) {
        if (hardware == null) {
            AvdWizardUtils.$$$reportNull$$$0(0);
        }
        Storage storage = AvdWizardUtils.getMaxPossibleRam(hardware.getRam());
        if (storage == null) {
            AvdWizardUtils.$$$reportNull$$$0(1);
        }
        return storage;
    }

    @NotNull
    public static Storage getMaxPossibleRam() {
        Storage storage = new Storage(1536L, Storage.Unit.MiB);
        if (storage == null) {
            AvdWizardUtils.$$$reportNull$$$0(2);
        }
        return storage;
    }

    @NotNull
    private static Storage getMaxPossibleRam(Storage ram) {
        if (ram.getSizeAsUnit(Storage.Unit.MiB) >= 1536L) {
            Storage storage = new Storage(1536L, Storage.Unit.MiB);
            if (storage == null) {
                AvdWizardUtils.$$$reportNull$$$0(3);
            }
            return storage;
        }
        Storage storage = ram;
        if (storage == null) {
            AvdWizardUtils.$$$reportNull$$$0(4);
        }
        return storage;
    }

    public static int getMaxCpuCores() {
        return Runtime.getRuntime().availableProcessors() / 2;
    }

    @Nullable
    public static String getHardwarePropertyDefaultValue(String name, @Nullable AndroidSdkHandler sdkHandler) {
        LocalPackage emulatorPackage;
        if (ourHardwareProperties == null && sdkHandler != null && (emulatorPackage = sdkHandler.getLocalPackage("emulator", (ProgressIndicator)new StudioLoggerProgressIndicator(AvdWizardUtils.class))) != null) {
            File hardwareDefs = new File(emulatorPackage.getLocation(), "lib" + File.separator + "hardware-properties.ini");
            FileOp fop = sdkHandler.getFileOp();
            ourHardwareProperties = HardwareProperties.parseHardwareDefinitions((IAbstractFile)new FileOpFileWrapper(hardwareDefs, fop, false), (ILogger)new LogWrapper(Logger.getInstance(AvdManagerConnection.class)));
        }
        HardwareProperties.HardwareProperty hwProp = ourHardwareProperties == null ? null : ourHardwareProperties.get(name);
        return hwProp == null ? null : hwProp.getDefault();
    }

    public static String cleanAvdName(@NotNull AvdManagerConnection connection2, @NotNull String candidateBase, boolean uniquify) {
        if (connection2 == null) {
            AvdWizardUtils.$$$reportNull$$$0(5);
        }
        if (candidateBase == null) {
            AvdWizardUtils.$$$reportNull$$$0(6);
        }
        if ((candidateBase = AvdNameVerifier.stripBadCharactersAndCollapse(candidateBase)).isEmpty()) {
            candidateBase = "myavd";
        }
        String candidate = candidateBase;
        if (uniquify) {
            int i = 1;
            while (connection2.avdExists(candidate)) {
                candidate = String.format("%1$s_%2$d", candidateBase, i++);
            }
        }
        return candidate;
    }

    @Nullable
    public static File pathToUpdatedSkins(@Nullable File deviceFile, @Nullable SystemImageDescription image, @NotNull FileOp fop) {
        if (fop == null) {
            AvdWizardUtils.$$$reportNull$$$0(7);
        }
        if (deviceFile == null || deviceFile.getPath().isEmpty()) {
            return deviceFile;
        }
        if (FileUtil.filesEqual((File)deviceFile, (File)NO_SKIN)) {
            return NO_SKIN;
        }
        if (deviceFile.isAbsolute()) {
            return deviceFile;
        }
        if (image != null) {
            File[] skins;
            for (File skin : skins = image.getSkins()) {
                if (!skin.getPath().endsWith(File.separator + deviceFile.getPath())) continue;
                return skin;
            }
        }
        File resourcePath = null;
        File resourceParent = DeviceArtDescriptor.getBundledDescriptorsFolder();
        if (resourceParent != null) {
            String deviceName = deviceFile.getPath();
            if (deviceName.equals("AndroidWearSquare")) {
                deviceName = "wear_square";
            } else if (deviceName.equals("AndroidWearRound")) {
                deviceName = "wear_round";
            }
            resourcePath = new File(resourceParent, deviceName);
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        File skinDir = null;
        if (sdkData != null) {
            File sdkDir = sdkData.getLocation();
            File sdkSkinsDir = new File(sdkDir, "skins");
            skinDir = new File(sdkSkinsDir, deviceFile.getPath());
        }
        boolean webpOk = sdkData != null && AvdWizardUtils.emulatorSupportsWebp(sdkData.getSdkHandler());
        return AvdWizardUtils.ensureSkinsAreCurrent(resourcePath, skinDir, deviceFile, webpOk, fop);
    }

    @Nullable
    public static File ensureSkinsAreCurrent(@Nullable File resourcePath, @Nullable File skinDestination, @Nullable File deviceName, boolean emulatorCanDecodeWebp, @NotNull FileOp fop) {
        if (fop == null) {
            AvdWizardUtils.$$$reportNull$$$0(8);
        }
        if (resourcePath == null) {
            return skinDestination == null ? deviceName : skinDestination;
        }
        if (skinDestination == null) {
            return resourcePath;
        }
        if (fop.exists(skinDestination)) {
            File[] resourceLayout = new File(resourcePath, "layout");
            File destLayout = new File(skinDestination, "layout");
            if (!resourceLayout.exists() || destLayout.exists() && destLayout.lastModified() >= resourceLayout.lastModified()) {
                return skinDestination;
            }
            fop.deleteFileOrFolder(skinDestination);
        }
        try {
            fop.mkdirs(skinDestination);
            if (!emulatorCanDecodeWebp) {
                AvdWizardUtils.convertWebpSkinToPng(fop, skinDestination, resourcePath);
            } else {
                for (File src : fop.listFiles(resourcePath)) {
                    File target = new File(skinDestination, src.getName());
                    if (!fop.isFile(src)) continue;
                    fop.copyFile(src, target);
                }
            }
            return skinDestination;
        }
        catch (IOException e) {
            AvdWizardUtils.getLog().warn(String.format("Failed to copy skin directory to %1$s, using studio-relative path %2$s", skinDestination, resourcePath));
            return resourcePath;
        }
    }

    static boolean emulatorSupportsWebp(@NotNull AndroidSdkHandler sdkHandler) {
        Revision version;
        StudioLoggerProgressIndicator log;
        LocalPackage sdkPackage;
        if (sdkHandler == null) {
            AvdWizardUtils.$$$reportNull$$$0(9);
        }
        if ((sdkPackage = sdkHandler.getLocalPackage("emulator", (ProgressIndicator)(log = new StudioLoggerProgressIndicator(AvdWizardUtils.class)))) == null) {
            sdkPackage = sdkHandler.getLocalPackage("tools", (ProgressIndicator)log);
        }
        return sdkPackage != null && ((version = sdkPackage.getVersion()).getMajor() > 25 || version.getMajor() == 25 && (version.getMinor() > 2 || version.getMinor() == 2 && version.getMicro() >= 3));
    }

    /*
     * Loose catch block
     */
    static void convertWebpSkinToPng(@NotNull FileOp fop, @NotNull File dest, @NotNull File resourcePath) throws IOException {
        if (fop == null) {
            AvdWizardUtils.$$$reportNull$$$0(10);
        }
        if (dest == null) {
            AvdWizardUtils.$$$reportNull$$$0(11);
        }
        if (resourcePath == null) {
            AvdWizardUtils.$$$reportNull$$$0(12);
        }
        File[] files = fop.listFiles(resourcePath);
        HashMap renameMap = Maps.newHashMap();
        File skinFile = null;
        for (File src : files) {
            String name;
            block60: {
                name = src.getName();
                if (name.equals("layout")) {
                    skinFile = src;
                    continue;
                }
                if (name.endsWith(".webp")) {
                    Throwable throwable = null;
                    try (BufferedInputStream inputStream = new BufferedInputStream(fop.newFileInputStream(src));){
                        BufferedImage icon = ImageIO.read(inputStream);
                        if (icon != null) {
                            File target = new File(dest, name.substring(0, name.length() - ".webp".length()) + ".png");
                            try (BufferedOutputStream outputStream = new BufferedOutputStream(fop.newFileOutputStream(target));){
                                ImageIO.write((RenderedImage)icon, "PNG", outputStream);
                                renameMap.put(name, target.getName());
                                continue;
                            }
                        }
                        break block60;
                        {
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                        }
                    }
                }
            }
            File target = new File(dest, name);
            if (!fop.isFile(src) || fop.exists(target)) continue;
            fop.copyFile(src, target);
        }
        if (skinFile != null) {
            try (BufferedInputStream inputStream = new BufferedInputStream(fop.newFileInputStream(skinFile));){
                File target = new File(dest, skinFile.getName());
                try (BufferedOutputStream outputStream = new BufferedOutputStream(fop.newFileOutputStream(target));){
                    byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                    String layout = new String(bytes, Charsets.UTF_8);
                    for (Map.Entry entry : renameMap.entrySet()) {
                        layout = layout.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                    }
                    outputStream.write(layout.getBytes(Charsets.UTF_8));
                }
            }
        }
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project) {
        return AvdWizardUtils.createAvdWizard(parent, project, new AvdOptionsModel(null));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project, @Nullable AvdInfo avdInfo) {
        return AvdWizardUtils.createAvdWizard(parent, project, new AvdOptionsModel(avdInfo));
    }

    public static ModelWizardDialog createAvdWizard(@Nullable Component parent, @Nullable Project project, @NotNull AvdOptionsModel model) {
        if (model == null) {
            AvdWizardUtils.$$$reportNull$$$0(13);
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (!((Boolean)model.isInEditMode().get()).booleanValue()) {
            wizardBuilder.addStep(new ChooseDeviceDefinitionStep(model));
            wizardBuilder.addStep(new ChooseSystemImageStep(model, project));
        }
        wizardBuilder.addStep(new ConfigureAvdOptionsStep(project, model));
        ModelWizard wizard = wizardBuilder.build();
        StudioWizardDialogBuilder builder = new StudioWizardDialogBuilder(wizard, "Virtual Device Configuration", parent);
        builder.setMinimumSize(AVD_WIZARD_MIN_SIZE);
        builder.setPreferredSize(AVD_WIZARD_SIZE);
        return builder.setHelpUrl(WizardUtils.toUrl(AVD_WIZARD_HELP_URL)).build();
    }

    public static ModelWizardDialog createAvdWizardForDuplication(@Nullable Component parent, @Nullable Project project, @NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            AvdWizardUtils.$$$reportNull$$$0(14);
        }
        AvdOptionsModel avdOptions = new AvdOptionsModel(avdInfo);
        avdOptions.setAsCopy();
        return AvdWizardUtils.createAvdWizard(parent, project, avdOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardware";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/AvdWizardUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateBase";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/AvdWizardUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRam";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxPossibleRam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRam";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cleanAvdName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathToUpdatedSkins";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureSkinsAreCurrent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "emulatorSupportsWebp";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertWebpSkinToPng";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAvdWizard";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAvdWizardForDuplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

