/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.error.IssueModel;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR);
    private final DesignSurface mySurface;

    public IssueNotificationAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            IssueNotificationAction.$$$reportNull$$$0(0);
        }
        super(NO_ISSUE, NO_ISSUE, null);
        this.mySurface = surface;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(1);
        }
        super.update(event);
        Presentation presentation = event.getPresentation();
        IssueModel issueModel = this.mySurface.getIssueModel();
        int markerCount = issueModel.getIssueCount();
        presentation.setText(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
        presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(2);
        }
        return !this.mySurface.getIssuePanel().isMinimized();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(3);
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
        this.mySurface.setShowIssuePanel(state);
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        if (issueModel == null) {
            IssueNotificationAction.$$$reportNull$$$0(4);
        }
        Icon icon = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO : DISABLED_ICON));
        Icon icon2 = icon;
        if (icon2 == null) {
            IssueNotificationAction.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIssueTypeIcon";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

