/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsToolbar
implements DesignSurfaceListener,
Disposable,
ModelListener,
PanZoomListener,
ConfigurationListener,
RenderListener {
    private static final int CONFIGURATION_UPDATE_FLAGS = 34;
    private final DesignSurface mySurface;
    private NlModel myModel;
    private JComponent myToolbarComponent;
    private ActionToolbar myNorthToolbar;
    private ActionToolbar myNorthEastToolbar;
    private final DefaultActionGroup myDynamicGroup = new DefaultActionGroup();

    public ActionsToolbar(@Nullable Disposable parent, DesignSurface surface) {
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.mySurface = surface;
    }

    public void dispose() {
        this.myModel.removeListener(this);
        this.mySurface.removePanZoomListener(this);
        this.mySurface.removeListener(this);
        Configuration configuration = this.mySurface.getConfiguration();
        if (configuration != null) {
            configuration.removeListener(this);
        }
    }

    @NotNull
    public JComponent getToolbarComponent() {
        if (this.myToolbarComponent == null) {
            this.myToolbarComponent = this.createToolbarComponent();
            this.mySurface.addListener(this);
            this.mySurface.addPanZoomListener(this);
            Configuration configuration = this.mySurface.getConfiguration();
            if (configuration != null) {
                configuration.addListener(this);
            }
            this.updateActions();
        }
        JComponent jComponent = this.myToolbarComponent;
        if (jComponent == null) {
            ActionsToolbar.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @NotNull
    private JComponent createToolbarComponent() {
        ToolbarActionGroups groups = this.mySurface.getLayoutType().getToolbarActionGroups(this.mySurface);
        this.myNorthToolbar = ActionsToolbar.createActionToolbar("NlConfigToolbar", groups.getNorthGroup());
        this.myNorthToolbar.setLayoutPolicy(2);
        JComponent northToolbarComponent = this.myNorthToolbar.getComponent();
        northToolbarComponent.setName("NlConfigToolbar");
        this.myNorthEastToolbar = ActionsToolbar.createActionToolbar("NlRhsConfigToolbar", groups.getNorthEastGroup());
        JComponent northEastToolbarComponent = this.myNorthEastToolbar.getComponent();
        northEastToolbarComponent.setName("NlRhsConfigToolbar");
        ActionToolbar centerToolbar = ActionsToolbar.createActionToolbar("NlLayoutToolbar", (ActionGroup)this.myDynamicGroup);
        centerToolbar.setLayoutPolicy(2);
        JComponent centerToolbarComponent = centerToolbar.getComponent();
        centerToolbarComponent.setName("NlLayoutToolbar");
        ActionToolbar eastToolbar = ActionsToolbar.createActionToolbar("NlRhsToolbar", groups.getEastGroup());
        JComponent eastToolbarComponent = eastToolbar.getComponent();
        eastToolbarComponent.setName("NlRhsToolbar");
        AdtPrimaryPanel northPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        northPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, StudioColorsKt.getBorder()));
        northPanel.add((Component)northToolbarComponent, "Center");
        northPanel.add((Component)northEastToolbarComponent, "East");
        AdtPrimaryPanel panel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, StudioColorsKt.getBorder()));
        panel.add((Component)northPanel, "North");
        panel.add((Component)centerToolbarComponent, "Center");
        panel.add((Component)eastToolbarComponent, "East");
        AdtPrimaryPanel adtPrimaryPanel = panel;
        if (adtPrimaryPanel == null) {
            ActionsToolbar.$$$reportNull$$$0(1);
        }
        return adtPrimaryPanel;
    }

    @NotNull
    private static ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group) {
        if (place == null) {
            ActionsToolbar.$$$reportNull$$$0(2);
        }
        if (group == null) {
            ActionsToolbar.$$$reportNull$$$0(3);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(place, group, true);
        toolbar.setLayoutPolicy(1);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            ActionsToolbar.$$$reportNull$$$0(4);
        }
        return actionToolbar;
    }

    public void updateActions() {
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view != null) {
            SelectionModel selectionModel = view.getSelectionModel();
            Object selection = selectionModel.getSelection();
            if (selection.isEmpty()) {
                ImmutableList<NlComponent> roots = view.getModel().getComponents();
                if (roots.size() == 1) {
                    selection = Collections.singletonList(roots.get(0));
                } else {
                    SceneManager manager = this.mySurface.getSceneManager();
                    if (manager != null) {
                        manager.addRenderListener(this);
                    }
                    return;
                }
            }
            this.updateActions((List<NlComponent>)selection);
        }
    }

    public void setModel(NlModel model) {
        this.myModel = model;
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            ActionsToolbar.$$$reportNull$$$0(5);
        }
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private void updateActions(@NotNull List<NlComponent> newSelection) {
        SceneView screenView;
        if (newSelection == null) {
            ActionsToolbar.$$$reportNull$$$0(6);
        }
        if ((screenView = this.mySurface.getCurrentSceneView()) == null) {
            return;
        }
        this.myDynamicGroup.removeAll();
        NlComponent parent = ActionsToolbar.findSharedParent(newSelection);
        if (parent != null) {
            this.mySurface.getActionManager().addActions(this.myDynamicGroup, null, parent, newSelection, true);
        }
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            ActionsToolbar.$$$reportNull$$$0(7);
        }
        if (newSelection == null) {
            ActionsToolbar.$$$reportNull$$$0(8);
        }
        assert (surface == this.mySurface);
        if (!newSelection.isEmpty()) {
            this.updateActions(newSelection);
        } else {
            this.updateActions();
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            ActionsToolbar.$$$reportNull$$$0(9);
        }
        this.myNorthToolbar.updateActionsImmediately();
        if (this.myDynamicGroup.getChildrenCount() == 0) {
            this.myModel = model;
        }
        this.updateActions();
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        if (surface == null) {
            ActionsToolbar.$$$reportNull$$$0(10);
        }
        if (component2 == null) {
            ActionsToolbar.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Override
    public void onRenderCompleted() {
        this.updateActions();
        SceneManager manager = this.mySurface.getSceneManager();
        if (manager != null) {
            manager.removeRenderListener(this);
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            ActionsToolbar.$$$reportNull$$$0(12);
        }
    }

    @Override
    public void zoomChanged(@NotNull DesignSurface surface) {
        if (surface == null) {
            ActionsToolbar.$$$reportNull$$$0(13);
        }
        this.myNorthEastToolbar.updateActionsImmediately();
    }

    @Override
    public void panningChanged(@NotNull AdjustmentEvent event) {
        if (event == null) {
            ActionsToolbar.$$$reportNull$$$0(14);
        }
        this.myNorthEastToolbar.updateActionsImmediately();
    }

    @Override
    public boolean changed(int flags) {
        if ((flags & 0x22) > 0 && this.myNorthEastToolbar != null) {
            this.myNorthEastToolbar.updateActionsImmediately();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/ActionsToolbar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/ActionsToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSharedParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "zoomChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "panningChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

