/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DrawArrow$WhenMappings;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010 \u001a\u00020\tH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0004H\u0016R\u0014\u0010\u0011\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006("}, d2={"Lcom/android/tools/idea/common/scene/draw/DrawArrow;", "Lcom/android/tools/idea/common/scene/draw/DrawCommand;", "sp", "", "", "([Ljava/lang/String;)V", "s", "(Ljava/lang/String;)V", "myLevel", "", "myDirection", "Lcom/android/tools/idea/common/scene/draw/ArrowDirection;", "myRectangle", "Ljava/awt/Rectangle;", "myColor", "Ljava/awt/Color;", "(ILcom/android/tools/idea/common/scene/draw/ArrowDirection;Ljava/awt/Rectangle;Ljava/awt/Color;)V", "bottom", "getBottom", "()I", "left", "getLeft", "right", "getRight", "top", "getTop", "xValues", "", "getXValues", "()[I", "yValues", "getYValues", "getLevel", "paint", "", "g", "Ljava/awt/Graphics2D;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "serialize", "intellij.android.designer"})
public final class DrawArrow
implements DrawCommand {
    private final int myLevel;
    private final ArrowDirection myDirection;
    private final Rectangle myRectangle;
    private final Color myColor;

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    @NotNull
    public String serialize() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return DrawCommandSerializationHelperKt.buildString(string, new Object[]{this.myLevel, this.myDirection, DrawCommandSerializationHelperKt.rectToString(this.myRectangle), DrawCommandSerializationHelperKt.colorToString(this.myColor)});
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Graphics g2;
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Graphics graphics = g2 = g.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g2");
        graphics.setColor(this.myColor);
        g2.fillPolygon(this.getXValues(), this.getYValues(), 3);
        g2.dispose();
    }

    private final int getLeft() {
        return this.myRectangle.x;
    }

    private final int getRight() {
        return this.myRectangle.x + this.myRectangle.width;
    }

    private final int getTop() {
        return this.myRectangle.y;
    }

    private final int getBottom() {
        return this.myRectangle.y + this.myRectangle.height;
    }

    private final int[] getXValues() {
        int[] nArray;
        switch (DrawArrow$WhenMappings.$EnumSwitchMapping$0[this.myDirection.ordinal()]) {
            case 1: {
                int[] nArray2 = new int[3];
                nArray2[0] = this.getRight();
                nArray2[1] = this.getLeft();
                nArray = nArray2;
                nArray2[2] = this.getRight();
                break;
            }
            case 2: {
                int[] nArray3 = new int[3];
                nArray3[0] = this.getLeft();
                nArray3[1] = this.getRight();
                nArray = nArray3;
                nArray3[2] = this.getLeft();
                break;
            }
            default: {
                int[] nArray4 = new int[3];
                nArray4[0] = this.getLeft();
                nArray4[1] = (this.getLeft() + this.getRight()) / 2;
                nArray = nArray4;
                nArray4[2] = this.getRight();
            }
        }
        return nArray;
    }

    private final int[] getYValues() {
        int[] nArray;
        switch (DrawArrow$WhenMappings.$EnumSwitchMapping$1[this.myDirection.ordinal()]) {
            case 1: {
                int[] nArray2 = new int[3];
                nArray2[0] = this.getBottom();
                nArray2[1] = this.getTop();
                nArray = nArray2;
                nArray2[2] = this.getBottom();
                break;
            }
            case 2: {
                int[] nArray3 = new int[3];
                nArray3[0] = this.getTop();
                nArray3[1] = this.getBottom();
                nArray = nArray3;
                nArray3[2] = this.getTop();
                break;
            }
            default: {
                int[] nArray4 = new int[3];
                nArray4[0] = this.getTop();
                nArray4[1] = (this.getTop() + this.getBottom()) / 2;
                nArray = nArray4;
                nArray4[2] = this.getBottom();
            }
        }
        return nArray;
    }

    public DrawArrow(int myLevel, @NotNull ArrowDirection myDirection, @NotNull Rectangle myRectangle, @NotNull Color myColor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)myDirection), (String)"myDirection");
        Intrinsics.checkParameterIsNotNull((Object)myRectangle, (String)"myRectangle");
        Intrinsics.checkParameterIsNotNull((Object)myColor, (String)"myColor");
        this.myLevel = myLevel;
        this.myDirection = myDirection;
        this.myRectangle = myRectangle;
        this.myColor = myColor;
    }

    private DrawArrow(String[] sp) {
        String string = sp[0];
        DrawArrow drawArrow = this;
        int n = Integer.parseInt(string);
        drawArrow(n, ArrowDirection.valueOf(sp[1]), DrawCommandSerializationHelperKt.stringToRect(sp[2]), DrawCommandSerializationHelperKt.stringToColor(sp[3]));
    }

    public DrawArrow(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }
}

