/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawLasso
extends DrawRegion {
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    private static final int GAP = 16;

    public DrawLasso(String s) {
        super(s);
    }

    public DrawLasso(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getFrames();
        g.setColor(background);
        String valueWidth = String.valueOf((int)((double)sceneContext.pxToDp(this.width) / sceneContext.getScale()));
        DrawConnectionUtils.drawHorizontalMarginIndicator(g, valueWidth, false, this.x, this.x + this.width, this.y - 16);
        String valueHeight = String.valueOf((int)((double)sceneContext.pxToDp(this.height) / sceneContext.getScale()));
        DrawConnectionUtils.drawVerticalMarginIndicator(g, valueHeight, false, this.x - 16, this.y, this.y + this.height);
        Stroke stroke = g.getStroke();
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.setStroke(stroke);
    }

    public static void add(DisplayList list, SceneContext transform2, float left, float top, float right, float bottom) {
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        int h = transform2.getSwingDimensionDip(bottom - top);
        list.add(new DrawLasso(l, t, w, h));
    }
}

