/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DataBindingProjectComponent
implements ModificationTracker {
    final CachedValue<AndroidFacet[]> myDataBindingEnabledModules;
    final ParameterizedCachedValue<Collection<? extends PsiModifierListOwner>, Module> myBindingAdapterAnnotations;
    final Project myProject;
    private AtomicLong myModificationCount = new AtomicLong(0L);
    private Map<String, PsiPackage> myDataBindingPsiPackages = Maps.newConcurrentMap();

    public DataBindingProjectComponent(Project project) {
        this.myProject = project;
        this.myDataBindingEnabledModules = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            for (Module module : modules) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || !ModuleDataBinding.getInstance(facet).isEnabled()) continue;
                facets.add(facet);
            }
            this.myModificationCount.incrementAndGet();
            return CachedValueProvider.Result.create((Object)facets.toArray(new AndroidFacet[facets.size()]), (Object[])new Object[]{DataBindingUtil.DATA_BINDING_ENABLED_TRACKER, ModuleManager.getInstance((Project)project)});
        }, false);
        this.myBindingAdapterAnnotations = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(module -> {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
            PsiClass aClass = facade.findClass("android.databinding.BindingAdapter", module.getModuleWithDependenciesAndLibrariesScope(false));
            Collection<Object> psiElements = null;
            psiElements = aClass == null ? Collections.emptyList() : AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)ProjectScope.getAllScope((Project)this.myProject), (Class[])new Class[]{PsiMethod.class}).findAll();
            return CachedValueProvider.Result.create(psiElements, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ModuleManager.getInstance((Project)project)});
        }, false);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DataBindingProjectComponent.$$$reportNull$$$0(0);
        }
        return project;
    }

    public boolean hasAnyDataBindingEnabledFacet() {
        return this.getDataBindingEnabledFacets().length > 0;
    }

    public AndroidFacet[] getDataBindingEnabledFacets() {
        return (AndroidFacet[])this.myDataBindingEnabledModules.getValue();
    }

    public long getModificationCount() {
        return this.myModificationCount.longValue();
    }

    public synchronized PsiPackage getOrCreateDataBindingPsiPackage(String packageName) {
        Object pkg = this.myDataBindingPsiPackages.get(packageName);
        if (pkg == null) {
            pkg = new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), packageName){

                public boolean isValid() {
                    return true;
                }
            };
            this.myDataBindingPsiPackages.put(packageName, (PsiPackage)pkg);
        }
        return pkg;
    }

    @NotNull
    private static Stream<PsiLiteral> getPsiLiterals(@NotNull PsiAnnotationMemberValue annotationMemberValue) {
        if (annotationMemberValue == null) {
            DataBindingProjectComponent.$$$reportNull$$$0(1);
        }
        if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
            Stream<PsiLiteral> stream = Arrays.stream(((PsiArrayInitializerMemberValue)annotationMemberValue).getInitializers()).filter(PsiLiteral.class::isInstance).map(PsiLiteral.class::cast);
            if (stream == null) {
                DataBindingProjectComponent.$$$reportNull$$$0(2);
            }
            return stream;
        }
        if (annotationMemberValue instanceof PsiLiteral) {
            Stream<PsiLiteral> stream = Stream.of((PsiLiteral)annotationMemberValue);
            if (stream == null) {
                DataBindingProjectComponent.$$$reportNull$$$0(3);
            }
            return stream;
        }
        Stream<PsiLiteral> stream = Stream.empty();
        if (stream == null) {
            DataBindingProjectComponent.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    public Stream<String> getBindingAdapterAttributes(@NotNull Module module) {
        if (module == null) {
            DataBindingProjectComponent.$$$reportNull$$$0(5);
        }
        Stream<String> stream = ((Collection)this.myBindingAdapterAnnotations.getValue((Object)module)).stream().map(PsiModifierListOwner::getModifierList).filter(Objects::nonNull).flatMap(modifierList -> Stream.of(modifierList.getAnnotations())).map(annotation -> annotation.findAttributeValue("value")).filter(Objects::nonNull).flatMap(DataBindingProjectComponent::getPsiLiterals).map(PsiLiteralValue::getValue).filter(Objects::nonNull).distinct().map(Object::toString);
        if (stream == null) {
            DataBindingProjectComponent.$$$reportNull$$$0(6);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingProjectComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingProjectComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiLiterals";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAdapterAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsiLiterals";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAdapterAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

