/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.LightBindingClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.NameSuggester;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingRenamer
extends AutomaticRenamer {
    public DataBindingRenamer(@NotNull LightBindingClass.LightDataBindingField field, @NotNull String newName2) {
        if (field == null) {
            DataBindingRenamer.$$$reportNull$$$0(0);
        }
        if (newName2 == null) {
            DataBindingRenamer.$$$reportNull$$$0(1);
        }
        PsiNamedElement resourceId = DataBindingRenamer.getResourceIdElement((PsiElement)field);
        if (resourceId != null) {
            this.myElements.add(resourceId);
        }
        this.suggestAllNames(field.getName(), newName2);
    }

    @Nullable
    private static PsiNamedElement getResourceIdElement(@NotNull PsiElement element) {
        PsiElement xmlElement;
        if (element == null) {
            DataBindingRenamer.$$$reportNull$$$0(2);
        }
        if (!((xmlElement = element.getNavigationElement()) instanceof XmlTag)) {
            return null;
        }
        XmlAttribute xmlAttribute = ((XmlTag)xmlElement).getAttribute("id", "http://schemas.android.com/apk/res/android");
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttributeValue valueElement = xmlAttribute.getValueElement();
        if (valueElement == null) {
            return null;
        }
        String id = valueElement.getValue();
        if (!id.startsWith("@+id/")) {
            return null;
        }
        return new ValueResourceElementWrapper(valueElement);
    }

    @NotNull
    protected String suggestNameForElement(@NotNull PsiNamedElement element, @NotNull NameSuggester suggester, @NotNull String newFieldName, @NotNull String oldFieldName) {
        if (element == null) {
            DataBindingRenamer.$$$reportNull$$$0(3);
        }
        if (suggester == null) {
            DataBindingRenamer.$$$reportNull$$$0(4);
        }
        if (newFieldName == null) {
            DataBindingRenamer.$$$reportNull$$$0(5);
        }
        if (oldFieldName == null) {
            DataBindingRenamer.$$$reportNull$$$0(6);
        }
        if (element instanceof ValueResourceElementWrapper) {
            CharSequence[] words = NameUtil.splitNameIntoWords((String)newFieldName);
            String string = "@+id/" + String.join((CharSequence)"_", words).toLowerCase();
            if (string == null) {
                DataBindingRenamer.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = super.suggestNameForElement(element, suggester, newFieldName, oldFieldName);
        if (string == null) {
            DataBindingRenamer.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDialogTitle() {
        if ("Rename Resource IDs" == null) {
            DataBindingRenamer.$$$reportNull$$$0(9);
        }
        return "Rename Resource IDs";
    }

    @Nls
    @NotNull
    public String getDialogDescription() {
        if ("Rename resources with the following IDs to:" == null) {
            DataBindingRenamer.$$$reportNull$$$0(10);
        }
        return "Rename resources with the following IDs to:";
    }

    @NotNull
    public String entityName() {
        if ("Resource ID" == null) {
            DataBindingRenamer.$$$reportNull$$$0(11);
        }
        return "Resource ID";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggester";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFieldName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFieldName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/DataBindingRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/DataBindingRenamer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNameForElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "entityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResourceIdElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestNameForElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

