/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.HandleViewDebug;
import com.android.ddmlib.IDevice;
import com.android.layoutinspector.model.ClientWindow;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.PTableModel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.LayoutFileData;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableGroupItem;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableRendererProvider;
import com.android.tools.idea.editors.layoutInspector.ui.RollOverTree;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeTreeRenderer;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.collections.ObservableList;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBCheckboxMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorContext
implements Disposable,
DataProvider,
ViewNodeActiveDisplay.ViewNodeActiveDisplayListener,
TreeSelectionListener,
RollOverTree.TreeHoverListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final Key<ViewNode> KEY_VIEW_NODE = Key.create((String)ViewNode.class.getName());
    private static final boolean DUMP_DISPLAYLIST_ENABLED = Boolean.getBoolean("dump.displaylist.enabled");
    @Nullable
    private Client myClient;
    @Nullable
    private ClientWindow myWindow;
    @Nullable
    private ViewNode myRoot;
    @Nullable
    private BufferedImage myBufferedImage;
    @NotNull
    private ViewNodeActiveDisplay myPreview;
    @NotNull
    private RollOverTree myNodeTree;
    @NotNull
    private final ObservableList<ViewNode> mySubviewList;
    @NotNull
    private final PTableModel myTableModel;
    @NotNull
    private final PTable myPropertiesTable;
    @NotNull
    private final JBPopupMenu myNodePopup;
    @NotNull
    private final JBCheckboxMenuItem myNodeVisibleMenuItem;
    @NotNull
    private final JMenuItem myDumpDisplayListMenuItem;
    @NotNull
    private final JMenuItem mySubtreePreviewMenuItem;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(LayoutInspectorContext.class);
        if (logger == null) {
            LayoutInspectorContext.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public LayoutInspectorContext(@NotNull LayoutFileData layoutParser, @NotNull Disposable parentDisposable) {
        if (layoutParser == null) {
            LayoutInspectorContext.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            LayoutInspectorContext.$$$reportNull$$$0(2);
        }
        this.myRoot = layoutParser.getNode();
        this.myBufferedImage = layoutParser.getBufferedImage();
        this.myNodeTree = this.createNodeTree(this.getRoot());
        this.mySubviewList = new ObservableList();
        this.myTableModel = new PTableModel();
        this.myPropertiesTable = new PTable(this.myTableModel);
        this.myPropertiesTable.getColumnModel().getColumn(0).setMinWidth((int)((double)ToolWindowDefinition.DEFAULT_SIDE_WIDTH * 0.6));
        this.myPropertiesTable.setRendererProvider((PTableCellRendererProvider)LITableRendererProvider.getInstance());
        this.myPropertiesTable.setFillsViewportHeight(true);
        this.myPropertiesTable.getTableHeader().setReorderingAllowed(false);
        TableSpeedSearch propertiesSpeedSearch = new TableSpeedSearch((JTable)this.myPropertiesTable, (object, cell) -> {
            if (object == null) {
                return null;
            }
            assert (object instanceof PTableItem) : "Items in inspector properties table expected to be a PTableItem";
            return ((PTableItem)object).getName();
        });
        propertiesSpeedSearch.setComparator(new SpeedSearchComparator(false, false));
        this.myNodePopup = new JBPopupMenu();
        this.myNodeVisibleMenuItem = new JBCheckboxMenuItem(AndroidBundle.message("android.ddms.actions.layoutinspector.menu.show.bound", new Object[0]));
        this.myNodeVisibleMenuItem.addActionListener((ActionListener)new ShowHidePreviewActionListener());
        this.myNodePopup.add((JMenuItem)this.myNodeVisibleMenuItem);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myDumpDisplayListMenuItem = new JMenuItem(AndroidBundle.message("android.ddms.actions.layoutinspector.menu.dump.display", new Object[0]));
        this.myDumpDisplayListMenuItem.setVisible(false);
        if (LayoutInspectorContext.isDumpDisplayListEnabled()) {
            this.myDumpDisplayListMenuItem.setVisible(true);
            this.myDumpDisplayListMenuItem.addActionListener(new DumpDisplayListActionListener());
            this.myDumpDisplayListMenuItem.setEnabled(this.isDeviceConnected());
            this.myNodePopup.add(this.myDumpDisplayListMenuItem);
        }
        this.mySubtreePreviewMenuItem = new JMenuItem("Render subtree preview");
        this.mySubtreePreviewMenuItem.setVisible(false);
        if (((Boolean)StudioFlags.LAYOUT_INSPECTOR_SUB_VIEW_ENABLED.get()).booleanValue()) {
            this.mySubtreePreviewMenuItem.setVisible(true);
            this.mySubtreePreviewMenuItem.addActionListener(new RenderSubtreePreviewActionListener());
            this.mySubtreePreviewMenuItem.setEnabled(this.isDeviceConnected());
            this.myNodePopup.add(this.mySubtreePreviewMenuItem);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    private RollOverTree createNodeTree(@Nullable ViewNode root) {
        RollOverTree tree = new RollOverTree((TreeNode)root);
        tree.setSelectionRow(0);
        tree.setCellRenderer((TreeCellRenderer)((Object)new ViewNodeTreeRenderer()));
        tree.addTreeSelectionListener(this);
        tree.addTreeHoverListener(this);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            ViewNode n = (ViewNode)path.getLastPathComponent();
            if (!n.isDrawn()) continue;
            tree.expandPath(path);
        }
        tree.addMouseListener(new NodeRightClickAdapter());
        RollOverTree rollOverTree = tree;
        if (rollOverTree == null) {
            LayoutInspectorContext.$$$reportNull$$$0(3);
        }
        return rollOverTree;
    }

    @NotNull
    public RollOverTree getNodeTree() {
        RollOverTree rollOverTree = this.myNodeTree;
        if (rollOverTree == null) {
            LayoutInspectorContext.$$$reportNull$$$0(4);
        }
        return rollOverTree;
    }

    @NotNull
    public PTable getPropertiesTable() {
        PTable pTable = this.myPropertiesTable;
        if (pTable == null) {
            LayoutInspectorContext.$$$reportNull$$$0(5);
        }
        return pTable;
    }

    @NotNull
    public PTableModel getTableModel() {
        PTableModel pTableModel = this.myTableModel;
        if (pTableModel == null) {
            LayoutInspectorContext.$$$reportNull$$$0(6);
        }
        return pTableModel;
    }

    @Override
    public void onViewNodeOver(@Nullable ViewNode node) {
        if (this.myNodeTree == null) {
            return;
        }
        if (node == null) {
            this.myNodeTree.updateHoverPath(null);
        } else {
            TreePath path = ViewNode.getPathFromParent((ViewNode)node, (ViewNode)this.myRoot);
            this.myNodeTree.updateHoverPath(path);
        }
    }

    @Override
    public void onNodeSelected(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(7);
        }
        if (this.myNodeTree == null) {
            return;
        }
        TreePath path = ViewNode.getPathFromParent((ViewNode)node, (ViewNode)this.myRoot);
        this.myNodeTree.scrollPathToVisible(path);
        this.myNodeTree.setSelectionPath(path);
    }

    @Override
    public void onNodeDoubleClicked(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(8);
        }
        if (this.isDeviceConnected() && ((Boolean)StudioFlags.LAYOUT_INSPECTOR_SUB_VIEW_ENABLED.get()).booleanValue()) {
            this.showSubView(node);
        }
    }

    @Override
    public void valueChanged(@NotNull TreeSelectionEvent event) {
        ViewNode selection;
        if (event == null) {
            LayoutInspectorContext.$$$reportNull$$$0(9);
        }
        if ((selection = (ViewNode)this.myNodeTree.getLastSelectedPathComponent()) != null) {
            this.myTableModel.setItems(LayoutInspectorContext.convertToItems(selection.groupedProperties));
            if (this.myPreview != null) {
                this.myPreview.setSelectedNode(selection);
            }
        }
    }

    @NotNull
    public static List<PTableItem> convertToItems(@NotNull Map<String, List<ViewProperty>> properties) {
        if (properties == null) {
            LayoutInspectorContext.$$$reportNull$$$0(10);
        }
        ArrayList<PTableItem> items = new ArrayList<PTableItem>();
        ArrayList<String> sortedKeys = new ArrayList<String>(properties.keySet());
        Collections.sort(sortedKeys, String::compareToIgnoreCase);
        for (String key : sortedKeys) {
            items.add((PTableItem)new LITableGroupItem(key, properties.get(key)));
        }
        ArrayList<PTableItem> arrayList = items;
        if (arrayList == null) {
            LayoutInspectorContext.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public void onTreeCellHover(@Nullable TreePath path) {
        if (this.myPreview != null) {
            this.myPreview.setHoverNode(path == null ? null : (ViewNode)path.getLastPathComponent());
        }
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LayoutInspectorContext.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    public ViewNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public BufferedImage getBufferedImage() {
        return this.myBufferedImage;
    }

    public void setPreview(@NotNull ViewNodeActiveDisplay preview) {
        if (preview == null) {
            LayoutInspectorContext.$$$reportNull$$$0(13);
        }
        this.myPreview = preview;
    }

    public void setSources(@Nullable Client client, @Nullable ClientWindow window) {
        this.myClient = client;
        this.myWindow = window;
        this.myDumpDisplayListMenuItem.setEnabled(this.isDeviceConnected());
        this.mySubtreePreviewMenuItem.setEnabled(this.isDeviceConnected());
    }

    private boolean isDeviceConnected() {
        return this.myClient != null && this.myWindow != null;
    }

    public static boolean isDumpDisplayListEnabled() {
        return DUMP_DISPLAYLIST_ENABLED;
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        if (this.myClient == null) {
            return;
        }
        IDevice currentDevice = this.myClient.getDevice();
        if (device.equals(currentDevice)) {
            this.setSources(null, null);
        }
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    private void createNotification(@NotNull String message, @NotNull NotificationType type) {
        if (message == null) {
            LayoutInspectorContext.$$$reportNull$$$0(14);
        }
        if (type == null) {
            LayoutInspectorContext.$$$reportNull$$$0(15);
        }
        Notifications.Bus.notify((Notification)new Notification(AndroidBundle.message("android.ddms.actions.layoutinspector.notification.group", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.notification.title", new Object[0]), message, type, null));
    }

    public void goBackSubView() {
        assert (!this.mySubviewList.isEmpty());
        ViewNode lastNode = this.mySubviewList.get(this.mySubviewList.size() - 1);
        if (lastNode == null) {
            return;
        }
        this.updatePreview(lastNode);
        this.mySubviewList.remove(lastNode);
    }

    @NotNull
    public ObservableList<ViewNode> getSubviewList() {
        ObservableList<ViewNode> observableList = this.mySubviewList;
        if (observableList == null) {
            LayoutInspectorContext.$$$reportNull$$$0(16);
        }
        return observableList;
    }

    public void showSubView(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(17);
        }
        ViewNode root = this.getRoot();
        this.updatePreview(node);
        this.mySubviewList.add(root);
    }

    private void updatePreview(@NotNull ViewNode node) {
        if (node == null) {
            LayoutInspectorContext.$$$reportNull$$$0(18);
        }
        if (this.myWindow == null) {
            return;
        }
        byte[] bytes = this.myWindow.loadViewImage(node, 10L, TimeUnit.SECONDS);
        if (bytes == null) {
            return;
        }
        try {
            this.myBufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            LayoutInspectorContext.getLogger().warn((Throwable)e);
        }
        this.myRoot = node;
        this.myPreview.setPreview(this.myBufferedImage, node);
        this.myNodeTree = this.createNodeTree(node);
        this.myPreview.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: 
            case 8: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToItems";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubviewList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onNodeSelected";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onNodeDoubleClicked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "valueChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertToItems";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPreview";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showSubView";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updatePreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RenderSubtreePreviewActionListener
    implements ActionListener {
        private RenderSubtreePreviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LayoutInspectorContext.this.isDeviceConnected()) {
                LayoutInspectorContext.this.showSubView((ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty((Object)KEY_VIEW_NODE));
            }
        }
    }

    private class DumpDisplayListActionListener
    implements ActionListener {
        private DumpDisplayListActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LayoutInspectorContext.this.isDeviceConnected()) {
                return;
            }
            ViewNode node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty((Object)KEY_VIEW_NODE);
            if (node == null) {
                LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.nonode", new Object[0]), NotificationType.ERROR);
                return;
            }
            if (LayoutInspectorContext.this.myClient == null || LayoutInspectorContext.this.myWindow == null) {
                return;
            }
            try {
                HandleViewDebug.dumpDisplayList((Client)LayoutInspectorContext.this.myClient, (String)((LayoutInspectorContext)LayoutInspectorContext.this).myWindow.title, (String)node.toString());
            }
            catch (IOException e1) {
                LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.failure", e1.getMessage()), NotificationType.ERROR);
                return;
            }
            LayoutInspectorContext.this.createNotification(AndroidBundle.message("android.ddms.actions.layoutinspector.dumpdisplay.notification.success", new Object[0]), NotificationType.INFORMATION);
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.DUMP_DISPLAYLIST)));
        }
    }

    private class ShowHidePreviewActionListener
    implements ActionListener {
        private ShowHidePreviewActionListener() {
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            ViewNode node;
            if (event == null) {
                ShowHidePreviewActionListener.$$$reportNull$$$0(0);
            }
            if ((node = (ViewNode)LayoutInspectorContext.this.myNodePopup.getClientProperty((Object)KEY_VIEW_NODE)) == null) {
                return;
            }
            node.setForcedState(LayoutInspectorContext.this.myNodeVisibleMenuItem.getState() ? ViewNode.ForcedState.VISIBLE : ViewNode.ForcedState.INVISIBLE);
            LayoutInspectorContext.this.getRoot().updateNodeDrawn();
            if (LayoutInspectorContext.this.myPreview != null) {
                LayoutInspectorContext.this.myPreview.repaint();
            }
            if (LayoutInspectorContext.this.myNodeTree == null) {
                return;
            }
            LayoutInspectorContext.this.myNodeTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$ShowHidePreviewActionListener", "actionPerformed"));
        }
    }

    private class NodeRightClickAdapter
    extends MouseAdapter {
        private NodeRightClickAdapter() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                NodeRightClickAdapter.$$$reportNull$$$0(0);
            }
            if (LayoutInspectorContext.this.myNodeTree == null) {
                return;
            }
            if (event.isPopupTrigger()) {
                TreePath path = LayoutInspectorContext.this.myNodeTree.getPathForEvent(event);
                if (path == null) {
                    return;
                }
                ViewNode node = (ViewNode)path.getLastPathComponent();
                if (node.isParentVisible()) {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(true);
                    if (node.getForcedState() == ViewNode.ForcedState.NONE) {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.isDrawn());
                    } else {
                        LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(node.getForcedState() == ViewNode.ForcedState.VISIBLE);
                    }
                } else {
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setEnabled(false);
                    LayoutInspectorContext.this.myNodeVisibleMenuItem.setState(false);
                }
                LayoutInspectorContext.this.mySubtreePreviewMenuItem.setVisible(!node.equals(LayoutInspectorContext.this.myRoot));
                LayoutInspectorContext.this.myNodePopup.putClientProperty((Object)KEY_VIEW_NODE, (Object)node);
                LayoutInspectorContext.this.myNodePopup.show((Component)((Object)LayoutInspectorContext.this.myNodeTree), event.getX(), event.getY());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/layoutInspector/LayoutInspectorContext$NodeRightClickAdapter", "mousePressed"));
        }
    }
}

