/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(0);
        }
        String string = ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, "style");
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getResourceUrlFromQualifiedName(@NotNull String qualifiedName, @NotNull String type) {
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(2);
        }
        if (type == null) {
            ResolutionUtils.$$$reportNull$$$0(3);
        }
        String startChar = "attr".equals(type) ? "?" : "@";
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            return startChar + namespace + type + "/" + themeNameWithoutNamespace;
        }
        return startChar + type + "/" + qualifiedName;
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        if (styleResourceUrl == null) {
            ResolutionUtils.$$$reportNull$$$0(4);
        }
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        String string = url.namespace != null ? url.namespace + ':' + url.name : url.name;
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        int colonIndex;
        if (qualifiedName == null) {
            ResolutionUtils.$$$reportNull$$$0(6);
        }
        String string = (colonIndex = qualifiedName.indexOf(58)) != -1 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            ResolutionUtils.$$$reportNull$$$0(8);
        }
        String name = style.getName();
        String string = style.isFramework() ? "android:" + name : name;
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        if (item == null) {
            ResolutionUtils.$$$reportNull$$$0(10);
        }
        String name = item.getName();
        String string = item.isFrameworkAttr() ? "android:" + name : name;
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        ResourceUrl url;
        if (item == null) {
            ResolutionUtils.$$$reportNull$$$0(12);
        }
        String string = (url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework())) == null ? item.getRawXmlValue() : url.toString();
        if (string == null) {
            ResolutionUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static StyleResourceValue getStyleResourceValue(@NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        if (resolver == null) {
            ResolutionUtils.$$$reportNull$$$0(14);
        }
        if (qualifiedStyleName == null) {
            ResolutionUtils.$$$reportNull$$$0(15);
        }
        assert (!qualifiedStyleName.startsWith("@android:style/"));
        assert (!qualifiedStyleName.startsWith("@style/"));
        if (qualifiedStyleName.startsWith("android:")) {
            styleName = qualifiedStyleName.substring("android:".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName, @Nullable Module module) {
        StyleResourceValue style;
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(16);
        }
        if (resolver == null) {
            ResolutionUtils.$$$reportNull$$$0(17);
        }
        if (qualifiedStyleName == null) {
            ResolutionUtils.$$$reportNull$$$0(18);
        }
        return (style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName)) == null ? null : new ConfiguredThemeEditorStyle(configuration, style, module);
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(19);
        }
        if (qualifiedStyleName == null) {
            ResolutionUtils.$$$reportNull$$$0(20);
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(21);
        }
        if (itemResValue == null) {
            ResolutionUtils.$$$reportNull$$$0(22);
        }
        return ResolutionUtils.getAttributeDefinition(configuration.getModule(), configuration, ResolutionUtils.getQualifiedItemName(itemResValue));
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinitions definitions;
        if (module == null) {
            ResolutionUtils.$$$reportNull$$$0(23);
        }
        if (name == null) {
            ResolutionUtils.$$$reportNull$$$0(24);
        }
        if (name.startsWith("android:")) {
            IAndroidTarget target;
            if (configuration == null) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                target = ConfigurationManager.getOrCreateInstance(module).getDefaultTarget();
            } else {
                target = configuration.getRealTarget();
            }
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(ResolutionUtils.getNameFromQualifiedName(name));
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            ResolutionUtils.$$$reportNull$$$0(25);
        }
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.framework) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, AndroidResourceUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        String parentName;
        if (style == null) {
            ResolutionUtils.$$$reportNull$$$0(26);
        }
        if ((parentName = ResourceResolver.getParentName((StyleResourceValue)style)) == null) {
            return null;
        }
        if (parentName.startsWith("@")) {
            parentName = ResolutionUtils.getQualifiedNameFromResourceUrl(parentName);
        }
        if (style.isFramework() && !parentName.startsWith("android:")) {
            parentName = "android:" + parentName;
        }
        return parentName;
    }

    @NotNull
    public static Collection<ItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        if (resolver == null) {
            ResolutionUtils.$$$reportNull$$$0(27);
        }
        if (themeUrl == null) {
            ResolutionUtils.$$$reportNull$$$0(28);
        }
        HashMap<String, ItemResourceValue> allItems = new HashMap<String, ItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(ResolutionUtils.getNameFromQualifiedName(themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getValues();
            for (ItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        Collection<ItemResourceValue> collection = allItems.values();
        if (collection == null) {
            ResolutionUtils.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull ItemResourceValue item, @NotNull Configuration configuration) {
        if (item == null) {
            ResolutionUtils.$$$reportNull$$$0(30);
        }
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(31);
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        ResourceType attrType = resolvedValue.getResourceType();
        if (attrType != null) {
            return attrType;
        }
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(configuration, item);
        if (def != null) {
            for (AttributeFormat attrFormat : def.getFormats()) {
                attrType = AndroidDomUtil.getResourceType(attrFormat);
                if (attrType == null) continue;
                return attrType;
            }
        }
        return null;
    }

    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration) {
        List configurables;
        if (facet == null) {
            ResolutionUtils.$$$reportNull$$$0(32);
        }
        if (resolvedValue == null) {
            ResolutionUtils.$$$reportNull$$$0(33);
        }
        if (configuration == null) {
            ResolutionUtils.$$$reportNull$$$0(34);
        }
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet.getModule());
            IAndroidTarget target = configurationManager.getDefaultTarget();
            assert (target != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration, target);
            assert (resourceRepository != null);
            ResourceItem resourceItem = resourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
            configurables = resourceItem.getSourceFileList();
        } else {
            AppResourceRepository appResourceRepository = AppResourceRepository.getOrCreateInstance(facet);
            configurables = appResourceRepository.getResourceItem(resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration.findMatchingConfigurable(configurables);
        assert (configurable != null);
        FolderConfiguration folderConfiguration = configurable.getConfiguration();
        if (folderConfiguration == null) {
            ResolutionUtils.$$$reportNull$$$0(35);
        }
        return folderConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ResolutionUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleResourceUrl";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 10: 
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 14: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedStyleName";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemResValue";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeUrl";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ResolutionUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameFromResourceUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedStyleName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedItemName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeAttributes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStyleResourceUrl";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 35: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceUrlFromQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameFromResourceUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedStyleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedItemName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStyleResourceValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDefinition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalApiLevel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentQualifiedName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getThemeAttributes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAttrType";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFolderConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

