/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.SeparatedList;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemesListModel
extends AbstractListModel
implements ComboBoxModel {
    public static final String CREATE_NEW_THEME = "Create New Theme";
    public static final String SHOW_ALL_THEMES = "Show all themes";
    public static final String RENAME = "Rename ";
    private final JSeparator mySeparator;
    private final ThemeEditorContext myContext;
    private final ImmutableList<String> myDefaultThemeNames;
    private final String myDefaultThemeName;
    private SeparatedList myAllItems;
    private String mySelectedObject;
    private final List<String> myEditOptions;
    private ImmutableList<String> myAvailableProjectThemes;

    public ThemesListModel(@NotNull ThemeEditorContext context, @NotNull List<String> defaultThemeNames, @Nullable String defaultThemeName) {
        if (context == null) {
            ThemesListModel.$$$reportNull$$$0(0);
        }
        if (defaultThemeNames == null) {
            ThemesListModel.$$$reportNull$$$0(1);
        }
        this.mySeparator = new JSeparator(0);
        this.myEditOptions = new ArrayList<String>();
        this.myContext = context;
        this.myDefaultThemeNames = ImmutableList.copyOf(defaultThemeNames);
        this.myDefaultThemeName = defaultThemeName;
        this.updateThemes();
        this.myContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 0xF6) != 0) {
                    ThemesListModel.this.updateThemes();
                    ThemesListModel.this.fireContentsChanged(this, -1, -1);
                }
                return true;
            }
        });
    }

    private void updateThemes() {
        ImmutableList<String> editableThemes = ThemeEditorUtils.getModuleThemeQualifiedNamesList(this.myContext.getCurrentContextModule());
        ImmutableList.Builder availableThemesListBuilder = ImmutableList.builder();
        ImmutableList.Builder disabledThemesListBuilder = ImmutableList.builder();
        ThemeResolver themeResolver = this.myContext.getThemeResolver();
        for (String themeName : editableThemes) {
            if (themeResolver.getTheme(themeName) != null) {
                availableThemesListBuilder.add((Object)themeName);
                continue;
            }
            disabledThemesListBuilder.add((Object)themeName);
        }
        this.myAvailableProjectThemes = availableThemesListBuilder.build();
        ImmutableList disabledProjectThemes = disabledThemesListBuilder.build();
        String selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            if (this.myDefaultThemeName != null && (editableThemes.contains((Object)this.myDefaultThemeName) || themeResolver.getTheme(this.myDefaultThemeName) != null)) {
                selectedItem = this.myDefaultThemeName;
            } else if (!editableThemes.isEmpty()) {
                selectedItem = (String)editableThemes.get(0);
            } else if (!this.myDefaultThemeNames.isEmpty()) {
                selectedItem = (String)this.myDefaultThemeNames.get(0);
            }
        }
        this.myEditOptions.clear();
        this.buildEditOptionsList(selectedItem);
        this.myAllItems = new SeparatedList(this.mySeparator, SeparatedList.group(this.myAvailableProjectThemes), SeparatedList.group(disabledProjectThemes), SeparatedList.group(this.myDefaultThemeNames, SHOW_ALL_THEMES), SeparatedList.group(this.myEditOptions));
        this.setSelectedItem(selectedItem);
    }

    private void buildEditOptionsList(@Nullable String selectedItem) {
        this.myEditOptions.clear();
        this.myEditOptions.add(CREATE_NEW_THEME);
        if (selectedItem != null && this.myAvailableProjectThemes.contains((Object)selectedItem)) {
            this.myEditOptions.add(RENAME + selectedItem);
        }
    }

    @Override
    public int getSize() {
        return this.myAllItems.size();
    }

    @Override
    @NotNull
    public Object getElementAt(int index) {
        Object object = this.myAllItems.get(index);
        if (object == null) {
            ThemesListModel.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Override
    public void setSelectedItem(@Nullable Object anItem) {
        if (!(anItem instanceof String)) {
            return;
        }
        this.mySelectedObject = (String)anItem;
        if (!ThemesListModel.isSpecialOption(this.mySelectedObject)) {
            this.buildEditOptionsList(this.mySelectedObject);
        }
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    @Nullable
    public String getSelectedItem() {
        return this.mySelectedObject;
    }

    public static boolean isSpecialOption(@NotNull String value) {
        if (value == null) {
            ThemesListModel.$$$reportNull$$$0(3);
        }
        return SHOW_ALL_THEMES.equals(value) || CREATE_NEW_THEME.equals(value) || value.startsWith(RENAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultThemeNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemesListModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemesListModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

