/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AdbShellCommandsUtil {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(AdbShellCommandsUtil.class);
    @NotNull
    private static final String ERROR_LINE_MARKER = "ERR-ERR-ERR-ERR";
    @NotNull
    private static final String COMMAND_ERROR_CHECK_SUFFIX = " || echo ERR-ERR-ERR-ERR";

    public static AdbShellCommandResult executeCommand(@NotNull IDevice device, @NotNull String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(0);
        }
        if (command == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(1);
        }
        return AdbShellCommandsUtil.executeCommandImpl(device, command, true);
    }

    public static AdbShellCommandResult executeCommandNoErrorCheck(@NotNull IDevice device, @NotNull String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(2);
        }
        if (command == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(3);
        }
        return AdbShellCommandsUtil.executeCommandImpl(device, command, false);
    }

    public static void executeRawCommand(@NotNull IDevice device, @NotNull String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(4);
        }
        if (command == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(5);
        }
        long startTime = System.nanoTime();
        AdbShellCommandsUtil.executeCommandImpl(device, command, receiver);
        if (LOGGER.isTraceEnabled()) {
            long endTime = System.nanoTime();
            LOGGER.trace(String.format("Command took %,d ms to execute: %s", (endTime - startTime) / 1000000L, command));
        }
    }

    private static AdbShellCommandResult executeCommandImpl(@NotNull IDevice device, @NotNull String command, boolean errorCheck) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(6);
        }
        if (command == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<String> commandOutput = new ArrayList<String>();
        String fullCommand = errorCheck ? String.format("%s%s", command, COMMAND_ERROR_CHECK_SUFFIX) : command;
        AdbShellCommandsUtil.executeCommandImpl(device, fullCommand, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(@NotNull String[] lines) {
                if (lines == null) {
                    1.$$$reportNull$$$0(0);
                }
                Arrays.stream(lines).forEach(commandOutput::add);
            }

            public boolean isCancelled() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/explorer/adbimpl/AdbShellCommandsUtil$1", "processNewLines"));
            }
        });
        boolean isError = false;
        if (errorCheck && commandOutput.size() >= 2 && Objects.equals(commandOutput.get(commandOutput.size() - 2), ERROR_LINE_MARKER) && Objects.equals(commandOutput.get(commandOutput.size() - 1), "")) {
            isError = true;
            commandOutput.remove(commandOutput.get(commandOutput.size() - 1));
            commandOutput.remove(commandOutput.get(commandOutput.size() - 1));
        }
        if (commandOutput.size() >= 1) {
            LOGGER.info(String.format("  Output line 1 (out of %d): %s", commandOutput.size(), commandOutput.get(0)));
        }
        if (commandOutput.size() >= 2) {
            LOGGER.info(String.format("  Output line 2 (out of %d): %s", commandOutput.size(), commandOutput.get(1)));
        }
        if (LOGGER.isDebugEnabled()) {
            for (int i = 2; i < commandOutput.size(); ++i) {
                LOGGER.debug(String.format("  Output line %d (out of %d): %s", i + 1, commandOutput.size(), commandOutput.get(i)));
            }
        }
        return new AdbShellCommandResult(command, commandOutput, isError);
    }

    private static void executeCommandImpl(@NotNull IDevice device, @NotNull String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(8);
        }
        if (command == null) {
            AdbShellCommandsUtil.$$$reportNull$$$0(9);
        }
        long startTime = System.nanoTime();
        device.executeShellCommand(command, receiver);
        long endTime = System.nanoTime();
        LOGGER.info(String.format("Command took %,d ms to execute: %s", (endTime - startTime) / 1000000L, command));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/explorer/adbimpl/AdbShellCommandsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommandNoErrorCheck";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeRawCommand";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommandImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

