/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.debugger;

import com.android.tools.idea.fd.debugger.InstantRunDebuggerExtension;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class InstantRunStackFrame
extends StackFrameProxyImpl {
    private ObjectReference myThisReference;

    public InstantRunStackFrame(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (threadProxy == null) {
            InstantRunStackFrame.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            InstantRunStackFrame.$$$reportNull$$$0(1);
        }
        super(threadProxy, frame, fromBottomIndex);
    }

    public ObjectReference thisObject() throws EvaluateException {
        if (this.myThisReference != null) {
            return this.myThisReference;
        }
        ObjectReference ref = super.thisObject();
        if (ref == null) {
            try {
                Value value;
                LocalVariable newThis = this.getStackFrame().visibleVariableByName(InstantRunDebuggerExtension.INSTANT_RUN_THIS);
                if (newThis != null && (value = this.getStackFrame().getValue(newThis)) instanceof ObjectReference) {
                    this.myThisReference = (ObjectReference)value;
                    return this.myThisReference;
                }
            }
            catch (AbsentInformationException absentInformationException) {}
        } else if (this.getStackFrame().location().declaringType().name().endsWith(InstantRunDebuggerExtension.INSTANT_RUN_CLASS_SUFFIX)) {
            return null;
        }
        return ref;
    }

    public boolean isObsolete() throws EvaluateException {
        if (this.isRedirectionFrame()) {
            return super.isObsolete();
        }
        ReferenceType clazz = this.getStackFrame().location().method().declaringType();
        if (!clazz.name().endsWith(InstantRunDebuggerExtension.INSTANT_RUN_CLASS_SUFFIX)) {
            Field field = clazz.fieldByName(InstantRunDebuggerExtension.INSTANT_RUN_CHANGE);
            if (field != null && field.isSynthetic() && field.isStatic()) {
                return clazz.getValue(field) != null;
            }
        } else {
            Value value;
            Field field = clazz.fieldByName(InstantRunDebuggerExtension.INSTANT_RUN_CHANGE_OBSOLETE);
            if (field != null && (value = clazz.getValue(field)) instanceof BooleanValue) {
                return ((BooleanValue)value).value();
            }
        }
        return false;
    }

    private boolean isRedirectionFrame() throws EvaluateException {
        return this.getStackFrame().location().lineNumber() == InstantRunDebuggerExtension.REDIRECTION_LINE_NUMBER;
    }

    protected void clearCaches() {
        super.clearCaches();
        this.myThisReference = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "frame";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/fd/debugger/InstantRunStackFrame";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

