/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.values;

import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleValue<T> {
    @Nullable
    public T value();

    @Nullable
    public PsiElement getPsiElement();

    @Nullable
    public VirtualFile getFile();

    @Nullable
    public String getPropertyName();

    @Nullable
    public String getDslText();

    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables();

    @NotNull
    public static <E> List<E> getValues(@Nullable List<? extends GradleValue<E>> gradleValues) {
        if (gradleValues == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleValue.$$$reportNull$$$0(0);
            }
            return immutableList;
        }
        ArrayList<E> values = new ArrayList<E>(gradleValues.size());
        for (GradleValue<E> gradleValue : gradleValues) {
            E value = gradleValue.value();
            if (value == null) continue;
            values.add(value);
        }
        ArrayList<E> arrayList = values;
        if (arrayList == null) {
            GradleValue.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static <V> Map<String, V> getValues(@Nullable Map<String, ? extends GradleValue<V>> gradleValues) {
        if (gradleValues == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradleValue.$$$reportNull$$$0(2);
            }
            return immutableMap;
        }
        LinkedHashMap values = new LinkedHashMap();
        for (Map.Entry<String, GradleValue<V>> gradleValueEntry : gradleValues.entrySet()) {
            V value = gradleValueEntry.getValue().value();
            if (value == null) continue;
            values.put(gradleValueEntry.getKey(), value);
        }
        LinkedHashMap linkedHashMap = values;
        if (linkedHashMap == null) {
            GradleValue.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/api/values/GradleValue", "getValues"));
    }
}

