/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.api.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.api.values.GradleValue;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModelImpl;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.model.java.JavaModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModelImpl;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValueImpl;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private List<GradleDslExpressionMap> myToBeAppliedPlugins;

    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project))) != null ? GradleBuildModelImpl.parseBuildFile(file, project, project.getName()) : null;
    }

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(1);
        }
        return (file = GradleUtil.getGradleBuildFile(module)) != null ? GradleBuildModelImpl.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(3);
        }
        GradleBuildModel gradleBuildModel = GradleBuildModelImpl.parseBuildFile(file, project, "<Unknown>");
        if (gradleBuildModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(4);
        }
        return gradleBuildModel;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(7);
        }
        GradleBuildFile buildDslFile = new GradleBuildFile(file, project, moduleName);
        ApplicationManager.getApplication().runReadAction(() -> {
            GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(buildDslFile);
            GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile);
            buildDslFile.parse();
        });
        GradleBuildModelImpl gradleBuildModelImpl = new GradleBuildModelImpl(buildDslFile);
        if (gradleBuildModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(8);
        }
        return gradleBuildModelImpl;
    }

    private static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile) {
        GradleSettingsModel gradleSettingsModel;
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(9);
        }
        if ((gradleSettingsModel = GradleSettingsModelImpl.get(buildDslFile.getProject())) == null) {
            return;
        }
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (parentModuleModel == null || !(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleDslFile parentModuleDslFile = parentModuleModelImpl.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement("subprojects", subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getKey(), entry.getValue());
        }
    }

    private static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile) {
        File propertiesFilePath;
        VirtualFile propertiesFile;
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(10);
        }
        if ((propertiesFile = VfsUtil.findFileByIoFile((File)(propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties")), (boolean)true)) == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = GradlePropertiesModel.parsePropertiesFile(propertiesFile, buildDslFile.getProject(), buildDslFile.getName());
        if (propertiesModel == null) {
            return;
        }
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    private GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(11);
        }
        super(buildDslFile);
        this.myToBeAppliedPlugins = new ArrayList<GradleDslExpressionMap>();
    }

    @Override
    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(12);
            }
            return immutableList;
        }
        List<GradleNotNullValue<String>> listProperty = applyDslElement.getListProperty(PLUGIN, String.class);
        if (listProperty == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(13);
            }
            return immutableList;
        }
        ArrayList<GradleNotNullValue<String>> plugins = new ArrayList<GradleNotNullValue<String>>();
        HashSet pluginValues = new HashSet();
        for (GradleNotNullValue<String> plugin : listProperty) {
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add(plugin);
        }
        for (GradleDslExpressionMap toBeAppliedPlugin : this.myToBeAppliedPlugins) {
            GradleNullableValue<String> plugin = toBeAppliedPlugin.getLiteralProperty(PLUGIN, String.class);
            assert (plugin instanceof GradleNotNullValueImpl);
            if (!pluginValues.add(plugin.value())) continue;
            plugins.add((GradleNotNullValueImpl)plugin);
        }
        ArrayList<GradleNotNullValue<String>> arrayList = plugins;
        if (arrayList == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public GradleBuildModel applyPlugin(@NotNull String plugin) {
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(15);
        }
        if (GradleValue.getValues(this.appliedPlugins()).contains(plugin.trim())) {
            GradleBuildModelImpl gradleBuildModelImpl = this;
            if (gradleBuildModelImpl == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(16);
            }
            return gradleBuildModelImpl;
        }
        GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, "apply");
        applyMap.addNewLiteral(PLUGIN, plugin.trim());
        this.myToBeAppliedPlugins.add(applyMap);
        GradleBuildModelImpl gradleBuildModelImpl = this;
        if (gradleBuildModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(17);
        }
        return gradleBuildModelImpl;
    }

    @Override
    @NotNull
    public GradleBuildModel removePlugin(@NotNull String plugin) {
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(18);
        }
        plugin = plugin.trim();
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            GradleBuildModelImpl gradleBuildModelImpl = this;
            if (gradleBuildModelImpl == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(19);
            }
            return gradleBuildModelImpl;
        }
        ArrayList<GradleDslExpressionMap> toBeRemovedPlugins = new ArrayList<GradleDslExpressionMap>();
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            if (!plugin.equals(applyMap.getLiteralProperty(PLUGIN, String.class).value())) continue;
            toBeRemovedPlugins.add(applyMap);
        }
        this.myToBeAppliedPlugins.removeAll(toBeRemovedPlugins);
        while (GradleValue.getValues(applyDslElement.getListProperty(PLUGIN, String.class)).contains(plugin)) {
            applyDslElement.removeFromExpressionList(PLUGIN, plugin);
        }
        GradleBuildModelImpl gradleBuildModelImpl = this;
        if (gradleBuildModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(20);
        }
        return gradleBuildModelImpl;
    }

    @Override
    @Nullable
    public AndroidModel android() {
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.find(this.myGradleDslFile.getProject());
        if (androidPluginInfo != null && androidPluginInfo.isExperimental()) {
            return null;
        }
        AndroidDslElement androidDslElement = this.myGradleDslFile.getPropertyElement("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("android", androidDslElement);
        }
        return new AndroidModelImpl(androidDslElement);
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("buildscript", buildScriptDslElement);
        }
        BuildScriptModelImpl buildScriptModelImpl = new BuildScriptModelImpl(buildScriptDslElement);
        if (buildScriptModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(21);
        }
        return buildScriptModelImpl;
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getPropertyElement("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("dependencies", dependenciesDslElement);
        }
        DependenciesModelImpl dependenciesModelImpl = new DependenciesModelImpl(dependenciesDslElement);
        if (dependenciesModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(22);
        }
        return dependenciesModelImpl;
    }

    @Override
    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getPropertyElement("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("ext", extDslElement);
        }
        ExtModelImpl extModelImpl = new ExtModelImpl(extDslElement);
        if (extModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(23);
        }
        return extModelImpl;
    }

    @Override
    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getPropertyElement("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("java", javaDslElement);
        }
        JavaModelImpl javaModelImpl = new JavaModelImpl(javaDslElement);
        if (javaModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(24);
        }
        return javaModelImpl;
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getPropertyElement("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement("repositories", repositoriesDslElement);
        }
        RepositoriesModelImpl repositoriesModelImpl = new RepositoriesModelImpl(repositoriesDslElement);
        if (repositoriesModelImpl == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(25);
        }
        return repositoriesModelImpl;
    }

    @Override
    public void resetState() {
        this.myToBeAppliedPlugins.clear();
        super.resetState();
    }

    @Override
    public void applyChanges() {
        for (GradleDslExpressionMap applyMap : this.myToBeAppliedPlugins) {
            applyMap.create();
            applyMap.applyChanges();
            this.myGradleDslFile.addParsedElement("apply", applyMap);
        }
        this.myToBeAppliedPlugins.clear();
        super.applyChanges();
    }

    @Override
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty("repositories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLUGIN;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "appliedPlugins";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPlugin";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removePlugin";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "buildscript";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "dependencies";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "ext";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "java";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "populateWithParentModuleSubProjectsProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "populateSiblingDslFileWithGradlePropertiesFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

