/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModelImpl
extends GradleFileModelImpl
implements GradleSettingsModel {
    public static final String INCLUDE = "include";

    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath((Project)project))) != null ? GradleSettingsModelImpl.parseBuildFile(file, project, "settings") : null;
    }

    @NotNull
    public static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(3);
        }
        GradleSettingsFile settingsFile = new GradleSettingsFile(file, project, moduleName);
        settingsFile.parse();
        GradleSettingsModelImpl gradleSettingsModelImpl = new GradleSettingsModelImpl(settingsFile);
        if (gradleSettingsModelImpl == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(4);
        }
        return gradleSettingsModelImpl;
    }

    private GradleSettingsModelImpl(@NotNull GradleSettingsFile parsedModel) {
        if (parsedModel == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(5);
        }
        super(parsedModel);
    }

    @Override
    @NotNull
    public List<String> modulePaths() {
        ArrayList result = Lists.newArrayList();
        result.add(":");
        List<GradleNotNullValue<String>> includePaths = this.myGradleDslFile.getListProperty(INCLUDE, String.class);
        if (includePaths == null) {
            ArrayList arrayList = result;
            if (arrayList == null) {
                GradleSettingsModelImpl.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        for (GradleNotNullValue<String> includePath : includePaths) {
            result.add(GradleSettingsModelImpl.standardiseModulePath(includePath.value()));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public GradleSettingsModelImpl addModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(8);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        this.myGradleDslFile.addToNewLiteralList(INCLUDE, modulePath);
        GradleSettingsModelImpl gradleSettingsModelImpl = this;
        if (gradleSettingsModelImpl == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(9);
        }
        return gradleSettingsModelImpl;
    }

    @Override
    @NotNull
    public GradleSettingsModelImpl removeModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(10);
        }
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromExpressionList(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromExpressionList(INCLUDE, modulePath);
        GradleSettingsModelImpl gradleSettingsModelImpl = this;
        if (gradleSettingsModelImpl == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(11);
        }
        return gradleSettingsModelImpl;
    }

    @Override
    @NotNull
    public GradleSettingsModelImpl replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        if (oldModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(12);
        }
        if (newModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(13);
        }
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInExpressionList(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInExpressionList(INCLUDE, oldModulePath, newModulePath);
        GradleSettingsModelImpl gradleSettingsModelImpl = this;
        if (gradleSettingsModelImpl == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(14);
        }
        return gradleSettingsModelImpl;
    }

    @Override
    @Nullable
    public File moduleDirectory(String modulePath) {
        File parentDir;
        File projectDir;
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        File rootDirPath = Projects.getBaseDirPath((Project)this.myGradleDslFile.getProject());
        if (modulePath.equals(":")) {
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = this.parentModule(modulePath);
            if (parentModule == null) {
                return null;
            }
            parentDir = this.moduleDirectory(parentModule);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        return new File(parentDir, moduleName);
    }

    @Override
    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        if (moduleDir == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(15);
        }
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectory(modulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Override
    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(16);
        }
        if ((buildFilePath = this.buildFile(modulePath)) == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)true);
        if (buildFile == null) {
            return null;
        }
        return GradleBuildModelImpl.parseBuildFile(buildFile, this.myGradleDslFile.getProject(), modulePath.substring(modulePath.lastIndexOf(58) + 1));
    }

    @Override
    @Nullable
    public String parentModule(@NotNull String modulePath) {
        String parentModulePath;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(17);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        List<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        if (modulePath.equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        String string = parentModulePath = lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
        if (allModulePaths.contains(parentModulePath)) {
            return parentModulePath;
        }
        return null;
    }

    @Override
    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(18);
        }
        if ((parentModule = this.parentModule(modulePath)) == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Override
    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(19);
        }
        if ((moduleDirectory = this.moduleDirectory(modulePath)) == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = (String)projectProperties.buildFileName().value();
        }
        if (buildFileName == null) {
            buildFileName = "build.gradle";
        }
        return new File(moduleDirectory, buildFileName);
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(20);
        }
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModulePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModulePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "modulePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addModulePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModulePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeModulePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceModulePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moduleModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parentModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleModel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "standardiseModulePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

