/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModelImpl
extends GradleDslBlockModel
implements DependenciesModel {
    public DependenciesModelImpl(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            DependenciesModelImpl.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @Override
    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModelImpl.create(element));
                if (!(element instanceof GradleDslMethodCall)) continue;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                dependencies.addAll(ModuleDependencyModelImpl.create(configurationName, methodCall));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(2);
        }
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            this.addArtifacts(configurationName, dependencies);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        GradleDslElementList list;
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            DependenciesModelImpl.$$$reportNull$$$0(6);
        }
        if ((list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class)) != null) {
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModelImpl.create(element));
            }
        }
    }

    @Override
    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(7);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(8);
        }
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpecImpl.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        ArtifactDependencySpec dependency;
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(9);
        }
        if (compactNotation == null) {
            DependenciesModelImpl.$$$reportNull$$$0(10);
        }
        if ((dependency = ArtifactDependencySpecImpl.create(compactNotation)) == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(11);
        }
        return dependenciesModelImpl;
    }

    @Override
    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(12);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(13);
        }
        DependenciesModel dependenciesModel = this.addArtifact(configurationName, dependency, Collections.emptyList());
        if (dependenciesModel == null) {
            DependenciesModelImpl.$$$reportNull$$$0(14);
        }
        return dependenciesModel;
    }

    @Override
    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(15);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(16);
        }
        if (excludes == null) {
            DependenciesModelImpl.$$$reportNull$$$0(17);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ArtifactDependencyModelImpl.createAndAddToList(list, configurationName, dependency, excludes);
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(18);
        }
        return dependenciesModelImpl;
    }

    @Override
    public boolean replaceArtifactByPsiElement(@NotNull PsiElement psiElement, @NotNull ArtifactDependencySpec dependency) {
        GradleDslElement element;
        if (psiElement == null) {
            DependenciesModelImpl.$$$reportNull$$$0(19);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(20);
        }
        if ((element = this.findByPsiElement(psiElement)) == null) {
            return false;
        }
        this.performDependencyReplace(psiElement, element, dependency);
        return true;
    }

    @Override
    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(ModuleDependencyModelImpl.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(22);
        }
        if (path == null) {
            DependenciesModelImpl.$$$reportNull$$$0(23);
        }
        DependenciesModel dependenciesModel = this.addModule(configurationName, path, null);
        if (dependenciesModel == null) {
            DependenciesModelImpl.$$$reportNull$$$0(24);
        }
        return dependenciesModel;
    }

    @Override
    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(25);
        }
        if (path == null) {
            DependenciesModelImpl.$$$reportNull$$$0(26);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ModuleDependencyModelImpl.createAndAddToList(list, configurationName, path, config);
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(27);
        }
        return dependenciesModelImpl;
    }

    @Override
    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileTreeDependencyModelImpl.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(29);
        }
        if (dir == null) {
            DependenciesModelImpl.$$$reportNull$$$0(30);
        }
        DependenciesModel dependenciesModel = this.addFileTree(configurationName, dir, null, null);
        if (dependenciesModel == null) {
            DependenciesModelImpl.$$$reportNull$$$0(31);
        }
        return dependenciesModel;
    }

    @Override
    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(32);
        }
        if (dir == null) {
            DependenciesModelImpl.$$$reportNull$$$0(33);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileTreeDependencyModelImpl.createAndAddToList(list, configurationName, dir, includes, excludes);
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(34);
        }
        return dependenciesModelImpl;
    }

    @Override
    @NotNull
    public List<FileDependencyModel> files() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileDependencyModelImpl.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DependenciesModel addFile(@NotNull String configurationName, @NotNull String file) {
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(36);
        }
        if (file == null) {
            DependenciesModelImpl.$$$reportNull$$$0(37);
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileDependencyModelImpl.createAndAddToList(list, configurationName, file);
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(38);
        }
        return dependenciesModelImpl;
    }

    @NotNull
    private GradleDslElementList getOrCreateGradleDslElementList(@NotNull String configurationName) {
        GradleDslElementList list;
        if (configurationName == null) {
            DependenciesModelImpl.$$$reportNull$$$0(39);
        }
        if ((list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class)) == null) {
            list = new GradleDslElementList(this.myDslElement, configurationName);
            this.myDslElement.setNewElement(configurationName, list);
        }
        GradleDslElementList gradleDslElementList = list;
        if (gradleDslElementList == null) {
            DependenciesModelImpl.$$$reportNull$$$0(40);
        }
        return gradleDslElementList;
    }

    @Override
    @NotNull
    public DependenciesModel remove(@NotNull DependencyModel dependency) {
        GradleDslElementList gradleDslElementList;
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(41);
        }
        if ((gradleDslElementList = this.myDslElement.getPropertyElement(dependency.configurationName(), GradleDslElementList.class)) != null) {
            if (!(dependency instanceof DependencyModelImpl)) {
                Logger.getInstance(DependenciesModelImpl.class).warn("Tried to remove an unknown dependency type!");
                DependenciesModelImpl dependenciesModelImpl = this;
                if (dependenciesModelImpl == null) {
                    DependenciesModelImpl.$$$reportNull$$$0(42);
                }
                return dependenciesModelImpl;
            }
            GradleDslElement dependencyElement = ((DependencyModelImpl)dependency).getDslElement();
            GradleDslElement parent = dependencyElement.getParent();
            if (parent instanceof GradleDslMethodCall) {
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
                List<GradleDslElement> arguments = methodCall.getArguments();
                if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                    gradleDslElementList.removeElement(methodCall);
                } else {
                    methodCall.remove(dependencyElement);
                }
            } else {
                gradleDslElementList.removeElement(dependencyElement);
            }
        }
        DependenciesModelImpl dependenciesModelImpl = this;
        if (dependenciesModelImpl == null) {
            DependenciesModelImpl.$$$reportNull$$$0(43);
        }
        return dependenciesModelImpl;
    }

    private void performDependencyReplace(@NotNull PsiElement psiElement, @NotNull GradleDslElement element, @NotNull ArtifactDependencySpec dependency) {
        if (psiElement == null) {
            DependenciesModelImpl.$$$reportNull$$$0(44);
        }
        if (element == null) {
            DependenciesModelImpl.$$$reportNull$$$0(45);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(46);
        }
        if (element instanceof GradleDslLiteral) {
            ((GradleDslLiteral)element).setValue(dependency.compactNotation());
        } else if (element instanceof GradleDslExpressionMap) {
            this.updateGradleExpressionMapWithDependency((GradleDslExpressionMap)element, dependency);
        } else if (element instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
            for (GradleDslElement e : methodCall.getArguments()) {
                if (e.getPsiElement() != psiElement) continue;
                this.performDependencyReplace(psiElement, e, dependency);
            }
        }
    }

    private void updateGradleExpressionMapWithDependency(@NotNull GradleDslExpressionMap map, @NotNull ArtifactDependencySpec dependency) {
        String value;
        if (map == null) {
            DependenciesModelImpl.$$$reportNull$$$0(47);
        }
        if (dependency == null) {
            DependenciesModelImpl.$$$reportNull$$$0(48);
        }
        LinkedHashMap<String, Function<ArtifactDependencySpec, String>> properties = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>(ArtifactDependencySpecImpl.COMPONENT_MAP);
        for (Map.Entry<String, GradleDslElement> entry : map.getPropertyElements().entrySet()) {
            if (properties.containsKey(entry.getKey())) {
                value = (String)((Function)properties.get(entry.getKey())).fun((Object)dependency);
                if (value == null) continue;
                map.setNewLiteral(entry.getKey(), value);
                properties.remove(entry.getKey());
                continue;
            }
            map.removeProperty(entry.getKey());
        }
        for (Map.Entry<String, GradleDslElement> entry : properties.entrySet()) {
            value = (String)((Function)entry.getValue()).fun((Object)dependency);
            if (value != null) {
                map.addNewLiteral(entry.getKey(), value);
                continue;
            }
            map.removeProperty(entry.getKey());
        }
    }

    private static boolean isChildOfParent(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            DependenciesModelImpl.$$$reportNull$$$0(49);
        }
        if (parent == null) {
            DependenciesModelImpl.$$$reportNull$$$0(50);
        }
        ArrayList childElements = Lists.newArrayList((Object[])new PsiElement[]{parent});
        while (!childElements.isEmpty()) {
            PsiElement element = (PsiElement)childElements.remove(0);
            if (element.equals(child)) {
                return true;
            }
            childElements.addAll(Arrays.asList(element.getChildren()));
        }
        return false;
    }

    @Nullable
    private GradleDslElement findByPsiElement(@NotNull PsiElement child) {
        if (child == null) {
            DependenciesModelImpl.$$$reportNull$$$0(51);
        }
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
            for (GradleDslElement element : list.getElements()) {
                if (element instanceof GradleDslMethodCall) {
                    GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                    for (GradleDslElement el : methodCall.getArguments()) {
                        if (el.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, el.getPsiElement())) continue;
                        return el;
                    }
                    continue;
                }
                if (element.getPsiElement() == null || !DependenciesModelImpl.isChildOfParent(child, element.getPsiElement())) continue;
                return element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModelImpl";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 20: 
            case 41: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactNotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "artifacts";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifact";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "modules";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addModule";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTrees";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addFileTree";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "files";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "addFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGradleDslElementList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "artifacts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtifacts";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsArtifact";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceArtifactByPsiElement";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addFileTree";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGradleDslElementList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "performDependencyReplace";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleExpressionMapWithDependency";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfParent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findByPsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

