/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.values;

import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.api.values.GradleValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValueImpl;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleValueImpl<T>
implements GradleValue<T> {
    @Nullable
    private final GradleDslElement myDslElement;
    @Nullable
    private final T myValue;

    protected GradleValueImpl(@Nullable GradleDslElement dslElement, @Nullable T value) {
        this.myDslElement = dslElement;
        this.myValue = value;
    }

    @Override
    @Nullable
    public T value() {
        return this.myValue;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myDslElement == null) {
            return null;
        }
        return this.myDslElement instanceof GradleDslExpression ? ((GradleDslExpression)this.myDslElement).getExpression() : this.myDslElement.getPsiElement();
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        return this.myDslElement != null ? this.myDslElement.getDslFile().getFile() : null;
    }

    @Override
    @Nullable
    public String getPropertyName() {
        return this.myDslElement != null ? this.myDslElement.getQualifiedName() : null;
    }

    @Override
    @Nullable
    public String getDslText() {
        PsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Override
    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
        if (this.myDslElement == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradleValueImpl.$$$reportNull$$$0(0);
            }
            return immutableMap;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GradleReferenceInjection injection : this.myDslElement.getResolvedVariables()) {
            String variableName = injection.getName();
            GradleDslExpression expression = injection.getToBeInjectedExpression();
            if (expression == null) continue;
            Object resolvedValue = expression.getValue();
            if (resolvedValue == null) {
                Logger.getInstance(GradleValueImpl.class).warn("Reference to a null value was found, variable: " + variableName);
                continue;
            }
            builder.put((Object)variableName, new GradleNotNullValueImpl<Object>(expression, resolvedValue));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            GradleValueImpl.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/values/GradleValueImpl", "getResolvedVariables"));
    }
}

