/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.java.JavaVersionDslElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyDslUtil {
    static GroovyPsiElement ensureGroovyPsi(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroovyPsiElement) {
            return (GroovyPsiElement)element;
        }
        throw new IllegalArgumentException("Wrong PsiElement type for writer! Must be of type GoovyPsiElement");
    }

    static void addConfigBlock(@NotNull GradleDslLiteral literal) {
        PsiElement unsavedConfigBlock;
        if (literal == null) {
            GroovyDslUtil.$$$reportNull$$$0(0);
        }
        if ((unsavedConfigBlock = literal.getUnsavedConfigBlock()) == null) {
            return;
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(literal.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(literal);
        if (factory == null) {
            return;
        }
        GrApplicationStatement methodCallStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"foo 1, 2");
        PsiElement comma = methodCallStatement.getArgumentList().getFirstChild().getNextSibling();
        psiElement.addAfter(comma, psiElement.getLastChild());
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        psiElement.addAfter(unsavedConfigBlock, psiElement.getLastChild());
        literal.setUnsavedConfigBlock(null);
    }

    @Nullable
    static GrClosableBlock getClosableBlock(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    private static GroovyPsiElementFactory getPsiElementFactory(@NotNull GradleDslElement element) {
        GroovyPsiElement psiElement;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(2);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }

    static boolean isNewEmptyBlockElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(3);
        }
        if (element.getPsiElement() != null) {
            return false;
        }
        if (!element.isBlockElement() || !element.isInsignificantIfEmpty()) {
            return false;
        }
        Collection<GradleDslElement> children = element.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (GroovyDslUtil.isNewEmptyBlockElement(child)) continue;
            return false;
        }
        return true;
    }

    static void deleteIfEmpty(@Nullable PsiElement element) {
        GrVariable variable;
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (element instanceof GrAssignmentExpression) {
            if (((GrAssignmentExpression)element).getRValue() == null) {
                element.delete();
            }
        } else if (element instanceof GrApplicationStatement) {
            if (((GrApplicationStatement)element).getArgumentList() == null) {
                element.delete();
            }
        } else if (element instanceof GrClosableBlock) {
            final Boolean[] isEmpty = new Boolean[]{true};
            ((GrClosableBlock)element).acceptChildren(new GroovyElementVisitor(){

                public void visitElement(@NotNull GroovyPsiElement child) {
                    if (child == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                        return;
                    }
                    isEmpty[0] = false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil$1", "visitElement"));
                }
            });
            if (isEmpty[0].booleanValue()) {
                element.delete();
            }
        } else if (element instanceof GrMethodCallExpression) {
            GrMethodCallExpression call = (GrMethodCallExpression)element;
            GrArgumentList argumentList = null;
            try {
                for (PsiElement curr = call.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    if (!(curr instanceof GrArgumentList)) continue;
                    argumentList = (GrArgumentList)curr;
                    break;
                }
            }
            catch (AssertionError e) {
                argumentList = null;
            }
            GrClosableBlock[] closureArguments = call.getClosureArguments();
            if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                element.delete();
            }
        } else if (element instanceof GrCommandArgumentList) {
            GrCommandArgumentList commandArgumentList = (GrCommandArgumentList)element;
            if (commandArgumentList.getAllArguments().length == 0) {
                commandArgumentList.delete();
            }
        } else if (element instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)element;
            if (listOrMap.isMap() && listOrMap.getNamedArguments().length == 0 || !listOrMap.isMap() && listOrMap.getInitializers().length == 0) {
                listOrMap.delete();
            }
        } else if (element instanceof GrNamedArgument) {
            GrNamedArgument namedArgument = (GrNamedArgument)element;
            if (namedArgument.getExpression() == null) {
                namedArgument.delete();
            }
        } else if (element instanceof GrVariableDeclaration) {
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)element;
            for (GrVariable grVariable : variableDeclaration.getVariables()) {
                if (grVariable.getInitializerGroovy() != null) continue;
                grVariable.delete();
            }
            if (variableDeclaration.getVariables().length == 0) {
                variableDeclaration.delete();
            }
        } else if (element instanceof GrVariable && (variable = (GrVariable)element).getInitializerGroovy() == null) {
            variable.delete();
        }
        if (!element.isValid()) {
            GroovyDslUtil.deleteIfEmpty(parent);
        }
    }

    @Nullable
    static GrLiteral extractUnsavedLiteral(@NotNull GradleDslLiteral literal) {
        GroovyPsiElement newElement;
        if (literal == null) {
            GroovyDslUtil.$$$reportNull$$$0(4);
        }
        if (!((newElement = GroovyDslUtil.ensureGroovyPsi(literal.getUnsavedValue())) instanceof GrLiteral)) {
            return null;
        }
        return (GrLiteral)newElement;
    }

    @Nullable
    static PsiElement extractUnsavedReference(@NotNull GradleDslReference reference) {
        if (reference == null) {
            GroovyDslUtil.$$$reportNull$$$0(5);
        }
        return GroovyDslUtil.ensureGroovyPsi(reference.getUnsavedValue());
    }

    @Nullable
    static PsiElement createLiteral(@NotNull GradleDslElement context, @NotNull Object unsavedValue) {
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(6);
        }
        if (unsavedValue == null) {
            GroovyDslUtil.$$$reportNull$$$0(7);
        }
        CharSequence unsavedValueText = null;
        if (unsavedValue instanceof String) {
            String stringValue = (String)unsavedValue;
            unsavedValueText = stringValue.startsWith("\"") && stringValue.endsWith("\"") ? (String)unsavedValue : GrStringUtil.getLiteralTextByValue((String)((String)unsavedValue));
        } else if (unsavedValue instanceof Integer || unsavedValue instanceof Boolean) {
            unsavedValueText = unsavedValue.toString();
        } else if (unsavedValue instanceof ReferenceTo) {
            unsavedValueText = ((ReferenceTo)unsavedValue).getText();
        }
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(context);
        if (factory == null) {
            return null;
        }
        return factory.createExpressionFromText(unsavedValueText);
    }

    @Nullable
    static PsiElement createNamedArgumentList(@NotNull GradleDslExpressionList expressionList) {
        if (expressionList == null) {
            GroovyDslUtil.$$$reportNull$$$0(8);
        }
        GradleDslElement parent = expressionList.getParent();
        assert (parent instanceof GradleDslExpressionMap);
        PsiElement parentPsiElement = parent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory.createExpressionFromText((CharSequence)"[]");
        if (expressionFromText instanceof GrListOrMap) {
            GrListOrMap list = (GrListOrMap)expressionFromText;
            expressionList.commitExpressions((PsiElement)list);
        }
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionList.getName(), expressionFromText);
        Object added = parentPsiElement instanceof GrArgumentList ? ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument) : parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = added;
            expressionList.setPsiElement((PsiElement)addedNameArgument.getExpression());
            return expressionList.getPsiElement();
        }
        return null;
    }

    @Nullable
    static PsiElement extractCorrectJavaVersionPsiElement(@NotNull JavaVersionDslElement element) {
        PsiElement psiElement;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(9);
        }
        if ((psiElement = element.getPsiElement()) instanceof GrCommandArgumentList) {
            psiElement = psiElement.getParent();
        }
        return psiElement;
    }

    @Nullable
    static String getInjectionName(@NotNull GrStringInjection injection) {
        if (injection == null) {
            GroovyDslUtil.$$$reportNull$$$0(10);
        }
        String variableName = null;
        GrClosableBlock closableBlock = injection.getClosableBlock();
        if (closableBlock != null) {
            String blockText = closableBlock.getText();
            variableName = blockText.substring(1, blockText.length() - 1);
        } else {
            GrExpression expression = injection.getExpression();
            if (expression != null) {
                variableName = expression.getText();
            }
        }
        return variableName;
    }

    @NotNull
    static String ensureUnquotedText(@NotNull String str) {
        if (str == null) {
            GroovyDslUtil.$$$reportNull$$$0(11);
        }
        if (StringUtil.isQuotedString((String)str)) {
            str = StringUtil.unquoteString((String)str);
        }
        String string = str;
        if (string == null) {
            GroovyDslUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsavedValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUnquotedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addConfigBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClosableBlock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNewEmptyBlockElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractUnsavedLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractUnsavedReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLiteral";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNamedArgumentList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractCorrectJavaVersionPsiElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureUnquotedText";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

