/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.tools.idea.gradle.eclipse.AdtImportBuilder;
import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class AdtImportLocationStep
extends ProjectImportWizardStep {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myDestDirText;
    private JBLabel myDestinationLabel;
    private boolean myIsPathChangedByUser;
    private File mySourceProject;

    AdtImportLocationStep(WizardContext context) {
        super(context);
        String suffix;
        File file;
        this.$$$setupUI$$$();
        this.myDestinationLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        String prev = context.getProjectFileDirectory();
        this.mySourceProject = new File(FileUtil.toSystemDependentName((String)prev));
        String name = new File(prev).getName();
        context.setProjectFileDirectory(null);
        String defaultDir = context.getProjectFileDirectory();
        int index = 0;
        do {
            suffix = index == 0 ? "" : Integer.toString(index);
            ++index;
        } while ((file = new File(defaultDir, name + suffix)).exists());
        this.myDestDirText.setText(file.getPath());
        context.setProjectFileDirectory(prev);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle("Choose Destination Directory");
        descriptor.setDescription("Pick a directory to import the given Eclipse Android project into");
        this.myDestDirText.addBrowseFolderListener(new TextBrowseFolderListener(descriptor){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                AdtImportLocationStep.this.myIsPathChangedByUser = true;
            }

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                AdtImportLocationStep.this.myIsPathChangedByUser = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/android/tools/idea/gradle/eclipse/AdtImportLocationStep$1", "onFileChosen"));
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public String getName() {
        return "ADT Import Location";
    }

    public void updateDataModel() {
        WizardContext context = this.getWizardContext();
        context.setProjectFileDirectory(this.getProjectFileDirectory());
        AdtImportBuilder builder = (AdtImportBuilder)context.getProjectBuilder();
        if (builder != null) {
            builder.setSelectedProject(this.mySourceProject);
        }
    }

    public String getProjectFileDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myDestDirText.getText().trim());
    }

    public String getProjectFilePath() {
        return this.getProjectFileDirectory() + (this.getWizardContext().getProject() == null ? ".ipr" : ".iml");
    }

    public boolean validate() throws ConfigurationException {
        File[] files;
        List<String> errors;
        WizardContext context = this.getWizardContext();
        GradleImport importer = AdtImportProvider.getImporter(context);
        if (importer != null && !(errors = importer.getErrors()).isEmpty()) {
            throw new ConfigurationException(errors.get(0));
        }
        String projectFileDirectory = this.getProjectFileDirectory();
        if (projectFileDirectory.isEmpty()) {
            throw new ConfigurationException(String.format("Enter %1$s file location", context.getPresentationName()));
        }
        boolean shouldPromptCreation = this.myIsPathChangedByUser;
        if (!ProjectWizardUtil.createDirectoryIfNotExists((String)String.format("The %1$s file directory\n", context.getPresentationName()), (String)projectFileDirectory, (boolean)shouldPromptCreation)) {
            return false;
        }
        boolean shouldContinue = true;
        File projectFile = new File(this.getProjectFileDirectory());
        String title = "New Project";
        if (projectFile.isFile()) {
            shouldContinue = false;
            String message = String.format("%s exists and is a file.\nPlease specify a different project location", projectFile.getAbsolutePath());
            Messages.showErrorDialog((String)message, (String)title);
        } else if (projectFile.isDirectory() && (files = projectFile.listFiles()) != null && files.length > 0) {
            String message = String.format("%1$s folder already exists and is not empty.\nIts content may be overwritten.\nContinue?", projectFile.getAbsolutePath());
            int answer = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getQuestionIcon());
            shouldContinue = answer == 0;
        }
        return shouldContinue;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDestDirText.getTextField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 162));
        this.myDestinationLabel = jBLabel = new JBLabel();
        jBLabel.setText("Import Destination Directory:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myDestDirText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 1, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>Importing a project creates a full copy of the project and does not alter the original Eclipse project.</html> ");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 7, 2, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 20), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

