/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.editor.entity.ExternalDependencyGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorEntityGroup;
import com.android.tools.idea.gradle.editor.entity.GradleEditorRepositoryEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.VersionGradleEditorEntity;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.parser.GradleEditorDependencyParser;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelCustomizer;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParseContext;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelParser;
import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.android.tools.idea.gradle.editor.value.BuildToolsValueManager;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.android.tools.idea.gradle.editor.value.LibraryVersionsManager;
import com.android.tools.idea.gradle.editor.value.SdkValueManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelParserV1
implements GradleEditorModelParser {
    private static final Logger LOG = Logger.getInstance(GradleEditorModelParserV1.class);
    private static final List<String> PROJECT_QUALIFIER = Collections.emptyList();

    @Override
    @NotNull
    public GradleCoordinate getMinSupportedAndroidGradlePluginVersion() {
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseVersionOnly((String)"0");
        if (gradleCoordinate == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(0);
        }
        return gradleCoordinate;
    }

    @Override
    @NotNull
    public GradleCoordinate getMaxSupportedAndroidGradlePluginVersion() {
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseVersionOnly((String)"100");
        if (gradleCoordinate == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(1);
        }
        return gradleCoordinate;
    }

    @Override
    @NotNull
    public List<GradleEditorEntityGroup> buildEntities(@NotNull GradleEditorModelParseContext context) {
        GradleEditorEntityGroup repositories;
        GradleEditorEntityGroup dependencies;
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(2);
        }
        List<Object> result = Lists.newArrayList();
        GradleEditorEntityGroup buildConfiguration = this.buildConfiguration(context);
        if (buildConfiguration != null) {
            result.add(buildConfiguration);
        }
        if ((dependencies = this.dependencies(context)) != null) {
            result.add(dependencies);
        }
        if ((repositories = this.repositories(context)) != null) {
            result.add(repositories);
        }
        for (GradleEditorModelCustomizer customizer : (GradleEditorModelCustomizer[])GradleEditorModelCustomizer.EP_NAME.getExtensions()) {
            result = customizer.postProcess(result, context);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    protected static GradleEditorEntityGroup combine(@NotNull String sectionText, GradleEditorEntity ... childEntities) {
        if (sectionText == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(4);
        }
        if (childEntities == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(5);
        }
        GradleEditorEntityGroup result = null;
        for (GradleEditorEntity childEntity : childEntities) {
            if (childEntity == null) continue;
            if (result == null) {
                result = new GradleEditorEntityGroup(sectionText);
            }
            result.addEntity(childEntity);
        }
        return result;
    }

    @Nullable
    protected GradleEditorEntityGroup buildConfiguration(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(6);
        }
        return GradleEditorModelParserV1.combine(AndroidBundle.message("android.gradle.editor.header.build", new Object[0]), GradleEditorModelParserV1.buildGradlePluginVersion(context), this.buildCompileSdkVersion(context), this.buildBuildSdkVersion(context));
    }

    @Nullable
    public static VersionGradleEditorEntity buildGradlePluginVersion(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(7);
        }
        GradleEditorModelParseContext.Variable variable = new GradleEditorModelParseContext.Variable("classpath", PROJECT_QUALIFIER);
        GradleEditorDependencyParser dependencyParser = new GradleEditorDependencyParser();
        for (GradleEditorModelParseContext.Assignment assignment : context.getAssignments(variable)) {
            GradleEditorEntity entity = dependencyParser.parse(assignment, context);
            if (!(entity instanceof ExternalDependencyGradleEditorEntity)) continue;
            ExternalDependencyGradleEditorEntity e = (ExternalDependencyGradleEditorEntity)entity;
            int i = "com.android.tools.build:gradle:".indexOf(58);
            String groupId = "com.android.tools.build:gradle:".substring(0, i);
            String artifactId = "com.android.tools.build:gradle:".substring(i + 1);
            if (artifactId.endsWith(":")) {
                artifactId = artifactId.substring(0, artifactId.length() - 1);
            }
            if (!groupId.equals(e.getGroupId()) || !artifactId.equals(e.getArtifactId())) continue;
            HashSet metaData = Sets.newHashSet(e.getMetaData());
            if (!e.getMetaData().contains(StdGradleEditorEntityMetaData.INJECTED)) {
                metaData.add(StdGradleEditorEntityMetaData.OUTGOING);
            }
            metaData.remove(StdGradleEditorEntityMetaData.REMOVABLE);
            return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.gradle.plugin", new Object[0]), e.getVersionSourceBindings(), e.getEntityLocation(), metaData, e.getDeclarationValueLocation(), e.getVersion(), (GradleEditorEntityValueManager)new LibraryVersionsManager(groupId, artifactId), "https://developer.android.com/studio/build/index.html#build-files");
        }
        return null;
    }

    @Nullable
    protected GradleEditorEntity buildCompileSdkVersion(@NotNull GradleEditorModelParseContext context) {
        SimpleEntityData entityData;
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(8);
        }
        if ((entityData = GradleEditorModelParserV1.buildSimpleEntityData(new GradleEditorModelParseContext.Variable("compileSdkVersion", PROJECT_QUALIFIER), context, null)) == null) {
            return null;
        }
        return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.sdk.compile", new Object[0]), entityData.definitionValueSourceBindings, entityData.wholeEntityLocation, entityData.metaData, entityData.declarationValueLocation, entityData.value, (GradleEditorEntityValueManager)new SdkValueManager(), null);
    }

    @Nullable
    protected GradleEditorEntity buildBuildSdkVersion(@NotNull GradleEditorModelParseContext context) {
        SimpleEntityData entityData;
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(9);
        }
        if ((entityData = GradleEditorModelParserV1.buildSimpleEntityData(new GradleEditorModelParseContext.Variable("buildToolsVersion", PROJECT_QUALIFIER), context, null)) == null) {
            return null;
        }
        return new VersionGradleEditorEntity(AndroidBundle.message("android.gradle.editor.version.build.tools", new Object[0]), entityData.definitionValueSourceBindings, entityData.wholeEntityLocation, entityData.metaData, entityData.declarationValueLocation, entityData.value, (GradleEditorEntityValueManager)new BuildToolsValueManager(), null);
    }

    @Nullable
    protected static SimpleEntityData buildSimpleEntityData(@NotNull GradleEditorModelParseContext.Variable lValue, @NotNull GradleEditorModelParseContext context, @Nullable GradleEditorModelUtil.AssignmentFilter assignmentFilter) {
        if (lValue == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(11);
        }
        GradleEditorModelParseContext.Assignment targetAssignment = null;
        for (GradleEditorModelParseContext.Assignment assignment : context.getAssignments(lValue)) {
            GradleEditorModelParseContext.Assignment assignmentToUse = assignmentFilter == null ? assignment : assignmentFilter.check(assignment);
            if (assignmentToUse == null) continue;
            if (targetAssignment == null) {
                targetAssignment = assignmentToUse;
                continue;
            }
            LOG.warn(String.format("More than one assignment for the same l-value (%s) is found at the target file (%s): '%s' and '%s',", lValue, context.getTargetFile().getPath(), targetAssignment, assignmentToUse));
            return null;
        }
        if (targetAssignment == null) {
            return null;
        }
        GradleEditorSourceBinding declarationValueLocation = GradleEditorModelUtil.buildSourceBinding(targetAssignment.rValueLocation, context.getProject());
        if (declarationValueLocation == null) {
            return null;
        }
        GradleEditorSourceBinding wholeEntityLocation = GradleEditorModelUtil.buildSourceBinding(targetAssignment, context.getProject());
        if (wholeEntityLocation == null) {
            return null;
        }
        GradleEditorModelUtil.EntityInfo entityInfo = GradleEditorModelUtil.collectInfo(Collections.singleton(lValue), context, assignmentFilter);
        if (entityInfo.sourceBindings.isEmpty()) {
            return null;
        }
        Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(targetAssignment, context);
        return new SimpleEntityData(entityInfo.sourceBindings, metaData, entityInfo.value, wholeEntityLocation, declarationValueLocation);
    }

    @Nullable
    protected static SimpleEntityData buildSimpleEntityData(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull GradleEditorModelParseContext context) {
        GradleEditorSourceBinding declarationValueLocation;
        if (assignment == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(12);
        }
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(13);
        }
        if ((declarationValueLocation = GradleEditorModelUtil.buildSourceBinding(assignment.rValueLocation, context.getProject())) == null) {
            return null;
        }
        GradleEditorSourceBinding wholeEntityLocation = GradleEditorModelUtil.buildSourceBinding(assignment, context.getProject());
        if (wholeEntityLocation == null) {
            return null;
        }
        Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(assignment, context);
        if (assignment.dependencies.isEmpty()) {
            return new SimpleEntityData(Collections.singleton(declarationValueLocation), metaData, assignment.value == null ? "" : assignment.value.value, wholeEntityLocation, declarationValueLocation);
        }
        GradleEditorModelUtil.EntityInfo info = GradleEditorModelUtil.collectInfo(assignment.dependencies.asMap().keySet(), context, null);
        ArrayList definitionValueSourceBindings = Lists.newArrayList(info.sourceBindings);
        if (assignment.value != null && assignment.value.value.isEmpty()) {
            definitionValueSourceBindings.add(declarationValueLocation);
        }
        String valueToUse = assignment.value == null ? info.value : assignment.value.value;
        return new SimpleEntityData(definitionValueSourceBindings, metaData, valueToUse, wholeEntityLocation, declarationValueLocation);
    }

    @NotNull
    protected static Set<GradleEditorEntityMetaData> buildMetaData(@NotNull GradleEditorModelParseContext.Assignment assignment, @NotNull GradleEditorModelParseContext context) {
        if (assignment == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(14);
        }
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(15);
        }
        HashSet result = Sets.newHashSet();
        if (context.getTargetFile().equals(assignment.lValueLocation.file)) {
            String topSection;
            if (!assignment.codeStructure.isEmpty() && ("allprojects".equals(topSection = assignment.codeStructure.get(0)) || "subprojects".equals(topSection))) {
                result.add(StdGradleEditorEntityMetaData.OUTGOING);
            }
        } else {
            result.add(StdGradleEditorEntityMetaData.INJECTED);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Nullable
    protected GradleEditorEntityGroup dependencies(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(17);
        }
        ArrayList dependencies = Lists.newArrayList();
        GradleEditorDependencyParser dependencyParser = new GradleEditorDependencyParser();
        Collection<GradleEditorModelParseContext.Assignment> currentDependencies = context.getAssignments(Collections.singletonList("dependencies"));
        Collection<GradleEditorModelParseContext.Assignment> subProjectDependencies = context.getAssignments(Lists.newArrayList((Object[])new String[]{"subprojects", "dependencies"}));
        Collection<GradleEditorModelParseContext.Assignment> allProjectDependencies = context.getAssignments(Lists.newArrayList((Object[])new String[]{"allprojects", "dependencies"}));
        for (GradleEditorModelParseContext.Assignment assignment : Iterables.concat(currentDependencies, subProjectDependencies, allProjectDependencies)) {
            GradleEditorEntity entity = dependencyParser.parse(assignment, context);
            if (entity == null) continue;
            dependencies.add(entity);
        }
        if (dependencies.isEmpty()) {
            return null;
        }
        String headerText = AndroidBundle.message("android.gradle.editor.header.dependencies", new Object[0]);
        return GradleEditorModelParserV1.combine(headerText, (GradleEditorEntity[])Iterables.toArray((Iterable)dependencies, GradleEditorEntity.class));
    }

    @Nullable
    protected GradleEditorEntityGroup repositories(@NotNull GradleEditorModelParseContext context) {
        if (context == null) {
            GradleEditorModelParserV1.$$$reportNull$$$0(18);
        }
        ArrayList repositories = Lists.newArrayList();
        ArrayList requestKeys = Lists.newArrayList();
        requestKeys.add(Arrays.asList("buildscript", "repositories"));
        requestKeys.add(Arrays.asList("buildscript", "repositories", "maven"));
        requestKeys.add(Arrays.asList("subprojects", "repositories"));
        requestKeys.add(Arrays.asList("subprojects", "repositories", "maven"));
        requestKeys.add(Arrays.asList("allprojects", "repositories"));
        requestKeys.add(Arrays.asList("allprojects", "repositories", "maven"));
        ArrayList assignments = Lists.newArrayList();
        for (List key : requestKeys) {
            assignments.addAll(context.getAssignments(key));
        }
        for (GradleEditorModelParseContext.Assignment assignment : assignments) {
            SimpleEntityData data;
            String topSection;
            if (assignment.value == null || !context.getTargetFile().equals(assignment.lValueLocation.file) && !assignment.codeStructure.isEmpty() && !"allprojects".equals(topSection = assignment.codeStructure.get(0)) && !"subprojects".equals(topSection)) continue;
            if ("()".equals(assignment.value.value)) {
                String name = null;
                String value = null;
                String helpId = null;
                if ("mavenCentral".equals(assignment.lValue.name)) {
                    name = AndroidBundle.message("android.gradle.editor.header.repository.maven", new Object[0]);
                    value = "http://central.maven.org/maven2";
                    helpId = "http://gradle.org/docs/current/userguide/userguide_single.html#sub:maven_central";
                } else if ("jcenter".equals(assignment.lValue.name)) {
                    name = AndroidBundle.message("android.gradle.editor.header.repository.jcenter", new Object[0]);
                    value = "https://jcenter.bintray.com";
                    helpId = "http://gradle.org/docs/current/userguide/userguide_single.html#mavenJcenter";
                }
                if (name == null) continue;
                Set<GradleEditorEntityMetaData> metaData = GradleEditorModelParserV1.buildMetaData(assignment, context);
                metaData.add(StdGradleEditorEntityMetaData.READ_ONLY);
                GradleEditorSourceBinding sourceBinding = GradleEditorModelUtil.buildSourceBinding(assignment, context.getProject());
                if (sourceBinding == null) continue;
                repositories.add(new GradleEditorRepositoryEntity(name, value, Collections.emptyList(), sourceBinding, metaData, sourceBinding, helpId));
                continue;
            }
            if (!"url".equals(assignment.lValue.name) || (data = GradleEditorModelParserV1.buildSimpleEntityData(assignment, context)) == null) continue;
            repositories.add(new GradleEditorRepositoryEntity(AndroidBundle.message("android.gradle.editor.header.repository.third.party", new Object[0]), data.value, data.definitionValueSourceBindings, data.wholeEntityLocation, data.metaData, data.declarationValueLocation, "http://gradle.org/docs/current/userguide/userguide_single.html#sub:maven_repo"));
        }
        if (repositories.isEmpty()) {
            return null;
        }
        String headerText = AndroidBundle.message("android.gradle.editor.header.repositories", new Object[0]);
        return GradleEditorModelParserV1.combine(headerText, (GradleEditorEntity[])Iterables.toArray((Iterable)repositories, GradleEditorEntity.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childEntities";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValue";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSupportedAndroidGradlePluginVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSupportedAndroidGradlePluginVersion";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntities";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildEntities";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildGradlePluginVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildCompileSdkVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildBuildSdkVersion";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildSimpleEntityData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildMetaData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dependencies";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "repositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleEntityData {
        @NotNull
        final Collection<GradleEditorSourceBinding> definitionValueSourceBindings;
        @NotNull
        final Set<GradleEditorEntityMetaData> metaData;
        @NotNull
        final String value;
        @NotNull
        final GradleEditorSourceBinding wholeEntityLocation;
        @NotNull
        final GradleEditorSourceBinding declarationValueLocation;

        SimpleEntityData(@NotNull Collection<GradleEditorSourceBinding> definitionValueSourceBindings, @NotNull Set<GradleEditorEntityMetaData> metaData, @NotNull String value, @NotNull GradleEditorSourceBinding wholeEntityLocation, @NotNull GradleEditorSourceBinding declarationValueLocation) {
            if (definitionValueSourceBindings == null) {
                SimpleEntityData.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                SimpleEntityData.$$$reportNull$$$0(1);
            }
            if (value == null) {
                SimpleEntityData.$$$reportNull$$$0(2);
            }
            if (wholeEntityLocation == null) {
                SimpleEntityData.$$$reportNull$$$0(3);
            }
            if (declarationValueLocation == null) {
                SimpleEntityData.$$$reportNull$$$0(4);
            }
            this.definitionValueSourceBindings = definitionValueSourceBindings;
            this.metaData = metaData;
            this.value = value;
            this.wholeEntityLocation = wholeEntityLocation;
            this.declarationValueLocation = declarationValueLocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "definitionValueSourceBindings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wholeEntityLocation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declarationValueLocation";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParserV1$SimpleEntityData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

