/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleValue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.ui.GuiTestingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidPluginGeneration {
    public static final AndroidPluginGeneration ORIGINAL = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            if ("gradle" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "gradle";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            if ("com.android.application" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "com.android.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            if ("com.android.library" == null) {
                1.$$$reportNull$$$0(2);
            }
            return "com.android.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            String string = this.getLatestKnownVersion(this);
            if (string == null) {
                1.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            if ("3.1.0" == null) {
                1.$$$reportNull$$$0(4);
            }
            return "3.1.0";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Android Gradle plugin" == null) {
                1.$$$reportNull$$$0(5);
            }
            return "Android Gradle plugin";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getApplicationPluginId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryPluginId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLatestKnownVersion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecommendedVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    public static final AndroidPluginGeneration COMPONENT = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            if ("gradle-experimental" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "gradle-experimental";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            if ("com.android.model.application" == null) {
                2.$$$reportNull$$$0(1);
            }
            return "com.android.model.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            if ("com.android.model.library" == null) {
                2.$$$reportNull$$$0(2);
            }
            return "com.android.model.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            String string = this.getLatestKnownVersion(this);
            if (string == null) {
                2.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            if ("" == null) {
                2.$$$reportNull$$$0(4);
            }
            return "";
        }

        @Override
        @NotNull
        public String getDescription() {
            if ("Android Gradle \"experimental\" plugin" == null) {
                2.$$$reportNull$$$0(5);
            }
            return "Android Gradle \"experimental\" plugin";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArtifactId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getApplicationPluginId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryPluginId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLatestKnownVersion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecommendedVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static AndroidPluginGeneration[] ourValues = new AndroidPluginGeneration[]{ORIGINAL, COMPONENT};

    public boolean isApplicationPluginIdIn(@NotNull Collection<String> pluginIds) {
        if (pluginIds == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(0);
        }
        return pluginIds.contains(this.getApplicationPluginId());
    }

    @NotNull
    protected abstract String getApplicationPluginId();

    protected abstract String getLibraryPluginId();

    public boolean isAndroidPlugin(@NotNull String artifactId, String groupId) {
        if (artifactId == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(1);
        }
        return this.getArtifactId().equals(artifactId) && AndroidPluginGeneration.getGroupId().equals(groupId);
    }

    @NotNull
    public abstract String getArtifactId();

    public static AndroidPluginGeneration find(@NotNull String artifactId, String groupId) {
        if (artifactId == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(2);
        }
        for (AndroidPluginGeneration generation : ourValues) {
            if (!generation.isAndroidPlugin(artifactId, groupId)) continue;
            return generation;
        }
        return null;
    }

    @NotNull
    public static String getGroupId() {
        if ("com.android.tools.build" == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(3);
        }
        return "com.android.tools.build";
    }

    @NotNull
    public static AndroidPluginGeneration[] values() {
        if (ourValues == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(4);
        }
        return ourValues;
    }

    public static AndroidPluginGeneration find(@NotNull Module module) {
        GradleBuildModel buildModel;
        AndroidModuleModel gradleModel;
        if (module == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(5);
        }
        if ((gradleModel = AndroidModuleModel.get(module)) != null) {
            try {
                return gradleModel.getAndroidProject().getPluginGeneration() == 2 ? COMPONENT : ORIGINAL;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if ((buildModel = GradleBuildModel.get(module)) != null) {
            List<String> appliedPlugins = GradleValue.getValues(buildModel.appliedPlugins());
            for (AndroidPluginGeneration generation : ourValues) {
                if (!appliedPlugins.contains(generation.getApplicationPluginId()) && !appliedPlugins.contains(generation.getLibraryPluginId())) continue;
                return generation;
            }
        }
        return null;
    }

    @NotNull
    public abstract String getLatestKnownVersion();

    @NotNull
    protected String getLatestKnownVersion(@NotNull AndroidPluginGeneration generation) {
        if (generation == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(6);
        }
        String artifactId = generation.getArtifactId();
        FileOp fileOp = FileOpUtils.create();
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        Optional<GradleCoordinate> highestValueCoordinate = repoPaths.stream().map(repoPath -> MavenRepositories.getHighestInstalledVersion((String)AndroidPluginGeneration.getGroupId(), (String)artifactId, (File)repoPath, null, (boolean)true, (FileOp)fileOp)).filter(Objects::nonNull).max(GradleCoordinate.COMPARE_PLUS_HIGHER);
        if (!highestValueCoordinate.isPresent()) {
            if (IdeInfo.getInstance().isAndroidStudio() && !GuiTestingService.getInstance().isGuiTestingMode() && !ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("Gradle plugin missing from the offline Maven repo");
            }
            String version = generation.getRecommendedVersion();
            this.getLog().info("'" + artifactId + "' plugin missing from the offline Maven repo, will use default " + version);
            String string = version;
            if (string == null) {
                AndroidPluginGeneration.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = highestValueCoordinate.get().getRevision();
        if (string == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected abstract String getRecommendedVersion();

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            AndroidPluginGeneration.$$$reportNull$$$0(9);
        }
        return logger;
    }

    @NotNull
    public abstract String getDescription();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginGeneration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestKnownVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationPluginIdIn";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidPlugin";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLatestKnownVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

