/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(0);
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
        if (androidPluginVersionUpdater == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(1);
        }
        return androidPluginVersionUpdater;
    }

    public AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(2);
        }
        if (syncState == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(3);
        }
        this(project, syncState, GradleSyncInvoker.getInstance(), new TextSearch(project));
    }

    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull TextSearch textSearch) {
        if (project == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(4);
        }
        if (syncState == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(5);
        }
        if (syncInvoker == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(6);
        }
        if (textSearch == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myTextSearch = textSearch;
    }

    public UpdateResult updatePluginVersionAndSync(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion, boolean invalidateLastSyncOnFailure) {
        String msg;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(8);
        }
        UpdateResult result = this.updatePluginVersion(pluginVersion, gradleVersion);
        Throwable pluginVersionUpdateError = result.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        this.handleUpdateResult(result, invalidateLastSyncOnFailure);
        return result;
    }

    @VisibleForTesting
    void handleUpdateResult(@NotNull UpdateResult result, boolean invalidateLastSyncOnFailure) {
        Throwable pluginVersionUpdateError;
        if (result == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(9);
        }
        if ((pluginVersionUpdateError = result.getPluginVersionUpdateError()) != null || result.getGradleVersionUpdateError() != null) {
            if (invalidateLastSyncOnFailure) {
                this.mySyncState.invalidateLastSync("Failed to update either Android plugin version or Gradle version");
            }
            if (pluginVersionUpdateError != null) {
                this.myTextSearch.execute();
            }
        } else if (result.isPluginVersionUpdated() || result.isGradleVersionUpdated()) {
            if (!this.mySyncState.lastSyncFailedOrHasIssues()) {
                this.mySyncState.syncEnded();
            }
            GradleSyncInvoker.Request request = GradleSyncInvoker.Request.projectModified();
            request.cleanProject = true;
            this.mySyncInvoker.requestProjectSync(this.myProject, request);
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause;
        if (msg == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(10);
        }
        if (error == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)(cause = error.getMessage()))) {
            msg = msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn(msg);
    }

    @NotNull
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(12);
        }
        UpdateResult result = new UpdateResult();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
            if (pluginVersion == null) {
                AndroidPluginVersionUpdater.$$$reportNull$$$0(19);
            }
            this.updateAndroidPluginVersion(pluginVersion, gradleVersion, result);
        });
        if (result.isPluginVersionUpdated() && gradleVersion != null) {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> this.updateGradleWrapperVersion(gradleVersion, result));
        }
        UpdateResult updateResult = result;
        if (updateResult == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(13);
        }
        return updateResult;
    }

    private void updateAndroidPluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion, @NotNull UpdateResult result) {
        boolean updateModels;
        if (pluginVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(14);
        }
        if (result == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(15);
        }
        ArrayList modelsToUpdate = new ArrayList();
        VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<GradleBuildModel>)((Processor)buildModel -> {
            if (pluginVersion == null) {
                AndroidPluginVersionUpdater.$$$reportNull$$$0(18);
            }
            DependenciesModel dependencies = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                String groupId;
                String artifactId = dependency.name().value();
                if (AndroidPluginGeneration.find(artifactId, groupId = (String)dependency.group().value()) == null) continue;
                String versionValue = (String)dependency.version().value();
                if (!StringUtil.isEmpty((String)versionValue) && pluginVersion.compareTo(versionValue) == 0) break;
                dependency.setVersion(pluginVersion.toString());
                if (gradleVersion != null) {
                    buildModel.buildscript().repositories().addGoogleMavenRepository(gradleVersion);
                } else {
                    buildModel.buildscript().repositories().addGoogleMavenRepository(this.myProject);
                }
                modelsToUpdate.add(buildModel);
                break;
            }
            return true;
        }), true);
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            try {
                for (GradleBuildModel buildModel2 : modelsToUpdate) {
                    buildModel2.applyChanges();
                }
                result.pluginVersionUpdated();
            }
            catch (Throwable e) {
                result.setPluginVersionUpdateError(e);
            }
        } else {
            result.setPluginVersionUpdateError(new RuntimeException("Failed to find gradle build models to update."));
        }
    }

    private void updateGradleWrapperVersion(@NotNull GradleVersion gradleVersion, @NotNull UpdateResult result) {
        String basePath;
        if (gradleVersion == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(16);
        }
        if (result == null) {
            AndroidPluginVersionUpdater.$$$reportNull$$$0(17);
        }
        if ((basePath = this.myProject.getBasePath()) == null) {
            return;
        }
        ArrayList<File> projectRootFolders = new ArrayList<File>();
        projectRootFolders.add(new File(FileUtils.toSystemDependentPath((String)basePath)));
        projectRootFolders.addAll(BuildFileProcessor.getCompositeBuildFolderPaths(this.myProject));
        for (File rootFolder : projectRootFolders) {
            if (rootFolder == null) continue;
            try {
                File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootFolder);
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath);
                String current = gradleWrapper.getGradleVersion();
                GradleVersion parsedCurrent = null;
                if (current != null) {
                    parsedCurrent = GradleVersion.tryParse((String)current);
                }
                if (parsedCurrent == null || GradleUtil.isSupportedGradleVersion(parsedCurrent)) continue;
                gradleWrapper.updateDistributionUrl(gradleVersion.toString());
                result.gradleVersionUpdated();
            }
            catch (Throwable e) {
                result.setGradleVersionUpdateError(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textSearch";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersion";
                break;
            }
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePluginVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginVersionAndSync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleUpdateResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logUpdateError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateAndroidPluginVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleWrapperVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateAndroidPluginVersion$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updatePluginVersion$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            if (project == null) {
                TextSearch.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            ApplicationManager.getApplication().invokeLater(() -> {
                Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
                String textToFind = AndroidPluginGeneration.getGroupId() + ":" + AndroidPluginGeneration.ORIGINAL.getArtifactId();
                SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$TextSearch", "<init>"));
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(0);
            }
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            if (error == null) {
                UpdateResult.$$$reportNull$$$0(1);
            }
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "error";
            objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginVersionUpdater$UpdateResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPluginVersionUpdateError";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGradleVersionUpdateError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

