/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GradleProjectBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final BuildSettings myBuildSettings;
    @NotNull
    private final GradleBuildInvoker myBuildInvoker;
    @NotNull
    private final CompilerManager myCompilerManager;

    @NotNull
    public static GradleProjectBuilder getInstance(@NotNull Project project) {
        if (project == null) {
            GradleProjectBuilder.$$$reportNull$$$0(0);
        }
        GradleProjectBuilder gradleProjectBuilder = (GradleProjectBuilder)ServiceManager.getService((Project)project, GradleProjectBuilder.class);
        if (gradleProjectBuilder == null) {
            GradleProjectBuilder.$$$reportNull$$$0(1);
        }
        return gradleProjectBuilder;
    }

    public GradleProjectBuilder(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull BuildSettings buildSettings, @NotNull GradleBuildInvoker buildInvoker, @NotNull CompilerManager compilerManager) {
        if (project == null) {
            GradleProjectBuilder.$$$reportNull$$$0(2);
        }
        if (androidProjectInfo == null) {
            GradleProjectBuilder.$$$reportNull$$$0(3);
        }
        if (gradleProjectInfo == null) {
            GradleProjectBuilder.$$$reportNull$$$0(4);
        }
        if (buildSettings == null) {
            GradleProjectBuilder.$$$reportNull$$$0(5);
        }
        if (buildInvoker == null) {
            GradleProjectBuilder.$$$reportNull$$$0(6);
        }
        if (compilerManager == null) {
            GradleProjectBuilder.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myBuildSettings = buildSettings;
        this.myBuildInvoker = buildInvoker;
        this.myCompilerManager = compilerManager;
    }

    public void compileJava() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                this.myBuildInvoker.compileJava(modules, TestCompileType.ALL);
                return;
            }
            this.buildProjectWithJps(BuildMode.COMPILE_JAVA);
        }
    }

    public void clean() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                this.myBuildInvoker.cleanProject();
                return;
            }
            this.buildProjectWithJps(BuildMode.CLEAN);
        }
    }

    public void cleanAndGenerateSources() {
        this.doGenerateSources(true);
    }

    public void generateSources() {
        this.doGenerateSources(false);
    }

    private void doGenerateSources(boolean cleanProject) {
        if (!this.isSourceGenerationEnabled()) {
            return;
        }
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                if (cleanProject) {
                    this.myBuildInvoker.cleanAndGenerateSources();
                    return;
                }
                this.myBuildInvoker.generateSources();
                return;
            }
            this.buildProjectWithJps(BuildMode.SOURCE_GEN);
        }
    }

    public boolean isSourceGenerationEnabled() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            int moduleCount = ModuleManager.getInstance((Project)this.myProject).getModules().length;
            GradleExperimentalSettings settings = GradleExperimentalSettings.getInstance();
            return GradleProjectBuilder.isSourceGenerationEnabled(settings, moduleCount);
        }
        return false;
    }

    @VisibleForTesting
    @Contract(pure=true)
    static boolean isSourceGenerationEnabled(@NotNull GradleExperimentalSettings settings, int moduleCount) {
        if (settings == null) {
            GradleProjectBuilder.$$$reportNull$$$0(8);
        }
        return !settings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC || moduleCount <= settings.MAX_MODULE_COUNT_FOR_SOURCE_GEN;
    }

    private void buildProjectWithJps(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            GradleProjectBuilder.$$$reportNull$$$0(9);
        }
        this.myBuildSettings.setBuildMode(buildMode);
        this.myCompilerManager.make(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/GradleProjectBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProjectInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildInvoker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/GradleProjectBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSourceGenerationEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildProjectWithJps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

