/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VersionIncompatibility {
    @NotNull
    private final Module myModule;
    @NotNull
    private final CompatibilityCheck myCompatibilityCheck;
    @NotNull
    private final Pair<ComponentVersionReader, String> myReaderAndVersion;
    @NotNull
    private final Component myRequirement;
    @NotNull
    private final ComponentVersionReader myRequirementVersionReader;
    @NotNull
    private final List<String> myMessages;

    VersionIncompatibility(@NotNull Module module, @NotNull CompatibilityCheck compatibilityCheck, @NotNull Pair<ComponentVersionReader, String> readerAndVersion, @NotNull Component requirement, @NotNull ComponentVersionReader requirementVersionReader) {
        if (module == null) {
            VersionIncompatibility.$$$reportNull$$$0(0);
        }
        if (compatibilityCheck == null) {
            VersionIncompatibility.$$$reportNull$$$0(1);
        }
        if (readerAndVersion == null) {
            VersionIncompatibility.$$$reportNull$$$0(2);
        }
        if (requirement == null) {
            VersionIncompatibility.$$$reportNull$$$0(3);
        }
        if (requirementVersionReader == null) {
            VersionIncompatibility.$$$reportNull$$$0(4);
        }
        this.myMessages = new ArrayList<String>();
        this.myModule = module;
        this.myCompatibilityCheck = compatibilityCheck;
        this.myReaderAndVersion = readerAndVersion;
        this.myRequirement = requirement;
        this.myRequirementVersionReader = requirementVersionReader;
    }

    boolean hasMessages() {
        return !this.myMessages.isEmpty();
    }

    void addMessage(@NotNull String message) {
        if (message == null) {
            VersionIncompatibility.$$$reportNull$$$0(5);
        }
        this.myMessages.add(message);
    }

    /*
     * WARNING - void declaration
     */
    void reportMessages(@NotNull Project project) {
        void var11_14;
        if (project == null) {
            VersionIncompatibility.$$$reportNull$$$0(6);
        }
        ComponentVersionReader reader = (ComponentVersionReader)this.myReaderAndVersion.getFirst();
        String componentName = reader.getComponentName();
        String version = (String)this.myReaderAndVersion.getSecond();
        String requirementComponentName = this.myRequirementVersionReader.getComponentName();
        StringBuilder msg = new StringBuilder();
        msg.append(componentName).append(" ").append(version);
        PositionInFile position = reader.getVersionSource(this.myModule);
        if (!reader.isProjectLevel() && position == null) {
            msg.append(", in module '").append(this.myModule.getName()).append(",'");
        }
        msg.append(" requires ").append(requirementComponentName).append(" ");
        VersionRange requirementVersionRange = this.myRequirement.getVersionRange();
        msg.append(requirementVersionRange.getDescription());
        int messageCount = this.myMessages.size();
        if (messageCount == 1) {
            msg.append(" ").append(this.myMessages.get(0));
        } else if (messageCount > 1) {
            msg.append("<ul>");
            for (String string : this.myMessages) {
                msg.append("<li>").append(string).append("</li>");
            }
            msg.append("</ul>");
        }
        MessageType messageType = this.myCompatibilityCheck.getType();
        ArrayList<String> textLines = new ArrayList<String>();
        textLines.add(msg.toString());
        String failureMsg = this.myRequirement.getFailureMessage();
        if (failureMsg != null) {
            List lines = Splitter.on((String)"\\n").omitEmptyStrings().splitToList((CharSequence)failureMsg);
            textLines.addAll(lines);
        }
        String[] text = ArrayUtil.toStringArray(textLines);
        if (position != null) {
            SyncMessage syncMessage = new SyncMessage(project, "Version Compatibility Issues", messageType, position, text);
        } else {
            SyncMessage syncMessage = new SyncMessage("Version Compatibility Issues", messageType, text);
        }
        var11_14.add(this.myRequirementVersionReader.getQuickFixes(this.myModule, requirementVersionRange, position));
        GradleSyncMessages.getInstance(project).report((SyncMessage)var11_14);
    }

    @NotNull
    MessageType getType() {
        MessageType messageType = this.myCompatibilityCheck.getType();
        if (messageType == null) {
            VersionIncompatibility.$$$reportNull$$$0(7);
        }
        return messageType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compatibilityCheck";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readerAndVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementVersionReader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/compatibility/VersionIncompatibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportMessages";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

