/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.StopGradleDaemonsHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class ClassLoadingErrorHandler
extends SyncErrorHandler {
    private static final Pattern CLASS_NOT_FOUND_PATTERN = Pattern.compile("(.+) not found.");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        Sdk jdk;
        String text;
        if (error == null) {
            ClassLoadingErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            ClassLoadingErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ClassLoadingErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = ClassLoadingErrorHandler.findErrorMessage(this.getRootCause((Throwable)error))) == null) {
            return false;
        }
        String firstLine = ClassLoadingErrorHandler.getFirstLineMessage(text);
        boolean classNotFound = firstLine.startsWith("Unable to load class");
        OpenProjectStructureHyperlink openJdkSettingsHyperlink = null;
        NotificationHyperlink syncProjectHyperlink = SyncProjectWithExtraCommandLineOptionsHyperlink.syncProjectRefreshingDependencies();
        NotificationHyperlink stopDaemonsHyperlink = StopGradleDaemonsHyperlink.createStopGradleDaemonsHyperlink();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        boolean isJdk7 = false;
        JdkVersionDetector.JdkVersionInfo jdkVersion = null;
        if (unitTestMode) {
            isJdk7 = true;
        } else if (classNotFound && (jdk = IdeSdks.getInstance().getJdk()) != null) {
            JavaSdkVersion version;
            String jdkHomePath = jdk.getHomePath();
            if (jdkHomePath != null) {
                jdkVersion = SdkVersionUtil.getJdkVersionInfo((String)jdkHomePath);
            }
            isJdk7 = (version = JavaSdk.getInstance().getVersion(jdk)) == JavaSdkVersion.JDK_1_7;
        }
        String jdk7Hint = "";
        if (isJdk7) {
            jdk7Hint = "<li>";
            if (jdkVersion != null) {
                jdk7Hint = jdk7Hint + String.format("You are using JDK version '%1$s'. ", jdkVersion.version);
            }
            jdk7Hint = jdk7Hint + "Some versions of JDK 1.7 (e.g. 1.7.0_10) may cause class loading errors in Gradle.\nPlease update to a newer version (e.g. 1.7.0_67).";
            if (!unitTestMode && (openJdkSettingsHyperlink = OpenProjectStructureHyperlink.openJdkSettings(project)) != null) {
                jdk7Hint = jdk7Hint + "\n" + openJdkSettingsHyperlink.toHtml();
            }
            jdk7Hint = jdk7Hint + "</li>";
        }
        String newMsg = firstLine + "\nPossible causes for this unexpected error include:<ul>" + jdk7Hint + "<li>Gradle's dependency cache may be corrupt (this sometimes occurs after a network connection timeout.)\n" + syncProjectHyperlink.toHtml() + "</li><li>The state of a Gradle build process (daemon) may be corrupt. Stopping all Gradle daemons may solve this problem.\n" + stopDaemonsHyperlink.toHtml() + "</li><li>Your project may be using a third-party plugin which is not compatible with the other plugins in the project or the version of Gradle requested by the project.</li></ul>In the case of corrupt Gradle processes, you can also try closing the IDE and then killing all Java processes.";
        notification.setTitle("Gradle Sync Issues");
        notification.setMessage(newMsg);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (openJdkSettingsHyperlink != null) {
            hyperlinks.add(openJdkSettingsHyperlink);
        }
        hyperlinks.add(syncProjectHyperlink);
        hyperlinks.add(stopDaemonsHyperlink);
        GradleSyncMessages.getInstance(project).addNotificationListener(notification, hyperlinks);
        return true;
    }

    private static String findErrorMessage(@NotNull Throwable rootCause) {
        if (rootCause == null) {
            ClassLoadingErrorHandler.$$$reportNull$$$0(3);
        }
        String text = rootCause.getMessage();
        if (rootCause instanceof ClassNotFoundException) {
            String className = Strings.nullToEmpty((String)text);
            Matcher matcher = CLASS_NOT_FOUND_PATTERN.matcher(className);
            if (matcher.matches()) {
                className = matcher.group(1);
            }
            ClassLoadingErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.CLASS_NOT_FOUND, className);
            return String.format("Unable to load class '%1$s'.", className);
        }
        if (rootCause instanceof NoSuchMethodError) {
            String methodName = Strings.nullToEmpty((String)text);
            ClassLoadingErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.METHOD_NOT_FOUND, methodName);
            return String.format("Unable to find method '%1$s'.", methodName);
        }
        if (StringUtil.isNotEmpty((String)text) && text.contains("cannot be cast to")) {
            ClassLoadingErrorHandler.updateUsageTracker();
            return text;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/ClassLoadingErrorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

