/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.ProjectImportErrorHandler;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ErrorAndLocation {
    @NotNull
    private final ExternalSystemException myError;
    @Nullable
    private final PositionInFile myPositionInFile;

    @VisibleForTesting
    ErrorAndLocation(@NotNull ExternalSystemException error, @Nullable PositionInFile positionInFile) {
        if (error == null) {
            ErrorAndLocation.$$$reportNull$$$0(0);
        }
        this.myError = error;
        this.myPositionInFile = positionInFile;
    }

    @NotNull
    ExternalSystemException getError() {
        ExternalSystemException externalSystemException = this.myError;
        if (externalSystemException == null) {
            ErrorAndLocation.$$$reportNull$$$0(1);
        }
        return externalSystemException;
    }

    @Nullable
    PositionInFile getPositionInFile() {
        return this.myPositionInFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/ErrorAndLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/ErrorAndLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ErrorAndLocation create(@NotNull Throwable error) {
            if (error == null) {
                Factory.$$$reportNull$$$0(0);
            }
            Throwable rootCause = error;
            String location = null;
            while (true) {
                if (location == null) {
                    location = Factory.getLocationFrom(rootCause);
                }
                if (rootCause.getCause() == null || rootCause.getCause().getMessage() == null) break;
                rootCause = rootCause.getCause();
            }
            PositionInFile positionInFile = Factory.createPositionInFile(location);
            ErrorAndLocation errorAndLocation = new ErrorAndLocation(Factory.createErrorToReport(rootCause), positionInFile);
            if (errorAndLocation == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return errorAndLocation;
        }

        @NotNull
        private static ExternalSystemException createErrorToReport(@NotNull Throwable rootCause) {
            if (rootCause == null) {
                Factory.$$$reportNull$$$0(2);
            }
            String errMessage = ProjectImportErrorHandler.createErrorMessage(rootCause);
            ExternalSystemException exception = new ExternalSystemException(errMessage);
            exception.initCause(rootCause);
            ExternalSystemException externalSystemException = exception;
            if (externalSystemException == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return externalSystemException;
        }

        @Nullable
        private static String getLocationFrom(@NotNull Throwable error) {
            String location;
            String errorToString;
            if (error == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if ((errorToString = error.toString()).contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
                String[] lines = StringUtil.splitByLines((String)location);
                return lines.length > 0 ? lines[0] : null;
            }
            return null;
        }

        @Nullable
        private static PositionInFile createPositionInFile(@Nullable String location) {
            VirtualFile errorFile;
            Pair<String, Integer> pair;
            if (StringUtil.isNotEmpty((String)location) && (pair = SyncErrorHandler.getErrorLocation(location)) != null && (errorFile = VfsUtil.findFileByIoFile((File)new File((String)pair.getFirst()), (boolean)true)) != null) {
                return new PositionInFile(errorFile, (Integer)pair.getSecond(), -1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/ErrorAndLocation$Factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/ErrorAndLocation$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createErrorToReport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createErrorToReport";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocationFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

