/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myVersion;
    @Nullable
    private final VirtualFile myBuildFile;

    public InstallBuildToolsHyperlink(@NotNull String version, @Nullable VirtualFile buildFile) {
        if (version == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(0);
        }
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version, buildFile));
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @NotNull
    private static String getText(@NotNull String version, @Nullable VirtualFile buildFile) {
        if (version == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(1);
        }
        String msg = String.format("Install Build Tools %1$s", version);
        msg = buildFile != null ? msg + ", update version in build file and sync project" : msg + " and sync project";
        String string = msg;
        if (string == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            InstallBuildToolsHyperlink.$$$reportNull$$$0(3);
        }
        ArrayList requested = Lists.newArrayList();
        Revision minBuildToolsRev = Revision.parseRevision((String)this.myVersion);
        requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog != null && dialog.showAndGet()) {
            if (this.myBuildFile != null) {
                FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
            } else {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallBuildToolsHyperlink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallBuildToolsHyperlink";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

