/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleModelDataService<T extends ModuleModel>
extends AbstractProjectDataService<T, Void> {
    public final void importData(@NotNull Collection<DataNode<T>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleModelDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModuleModelDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(2);
        }
        if (toImport.isEmpty()) {
            if (projectData != null && GradleUtil.GRADLE_SYSTEM_ID.equals((Object)projectData.getOwner())) {
                this.onModelsNotFound(modelsProvider);
            }
            return;
        }
        try {
            this.importData(toImport, project, modelsProvider);
        }
        catch (Throwable e) {
            this.getLog().info(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
            String msg = e.getMessage();
            GradleSyncState.getInstance(project).syncFailed(StringUtil.isNotEmpty((String)msg) ? msg : e.getClass().getCanonicalName());
        }
    }

    protected void onModelsNotFound(@NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(3);
        }
        for (Module module : modelsProvider.getModules()) {
            this.onModelNotFound(module, modelsProvider);
        }
    }

    protected void onModelNotFound(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            ModuleModelDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(5);
        }
    }

    private void importData(final @NotNull Collection<DataNode<T>> toImport, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) throws Throwable {
        RunResult result;
        Throwable error;
        if (toImport == null) {
            ModuleModelDataService.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ModuleModelDataService.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            ModuleModelDataService.$$$reportNull$$$0(8);
        }
        if ((error = (result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() {
                if (project.isDisposed()) {
                    return;
                }
                Map modelsByModuleName = ModuleModelDataService.this.indexByModuleName(toImport);
                ModuleModelDataService.this.importData(toImport, project, modelsProvider, modelsByModuleName);
            }
        }.execute()).getThrowable()) != null) {
            throw error;
        }
    }

    protected abstract void importData(@NotNull Collection<DataNode<T>> var1, @NotNull Project var2, @NotNull IdeModifiableModelsProvider var3, @NotNull Map<String, T> var4);

    @NotNull
    private Map<String, T> indexByModuleName(@NotNull Collection<DataNode<T>> dataNodes) {
        if (dataNodes == null) {
            ModuleModelDataService.$$$reportNull$$$0(9);
        }
        if (dataNodes.isEmpty()) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ModuleModelDataService.$$$reportNull$$$0(10);
            }
            return map;
        }
        HashMap<String, ModuleModel> index = new HashMap<String, ModuleModel>();
        for (DataNode<T> dataNode : dataNodes) {
            ModuleModel model = (ModuleModel)dataNode.getData();
            index.put(model.getModuleName(), model);
        }
        HashMap<String, ModuleModel> hashMap = index;
        if (hashMap == null) {
            ModuleModelDataService.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        if (logger == null) {
            ModuleModelDataService.$$$reportNull$$$0(12);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/data/service/ModuleModelDataService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "indexByModuleName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onModelsNotFound";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onModelNotFound";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexByModuleName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

