/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.issues.BaseSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.BuildToolsTooLowReporter;
import com.android.tools.idea.gradle.project.sync.issues.ExternalNdkBuildIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.MissingSdkPackageSyncIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnhandledIssuesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.issues.UnsupportedGradleReporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncIssuesReporter {
    @NotNull
    private final Map<Integer, BaseSyncIssuesReporter> myStrategies;
    @NotNull
    private final BaseSyncIssuesReporter myDefaultMessageFactory;

    @NotNull
    public static SyncIssuesReporter getInstance() {
        SyncIssuesReporter syncIssuesReporter = (SyncIssuesReporter)ServiceManager.getService(SyncIssuesReporter.class);
        if (syncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(0);
        }
        return syncIssuesReporter;
    }

    public SyncIssuesReporter(@NotNull UnresolvedDependenciesReporter unresolvedDependenciesReporter) {
        if (unresolvedDependenciesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(1);
        }
        this(unresolvedDependenciesReporter, new ExternalNdkBuildIssuesReporter(), new UnsupportedGradleReporter(), new BuildToolsTooLowReporter(), new MissingSdkPackageSyncIssuesReporter());
    }

    @VisibleForTesting
    SyncIssuesReporter(BaseSyncIssuesReporter ... strategies) {
        if (strategies == null) {
            SyncIssuesReporter.$$$reportNull$$$0(2);
        }
        this.myStrategies = new HashMap<Integer, BaseSyncIssuesReporter>(5);
        for (BaseSyncIssuesReporter strategy : strategies) {
            int issueType = strategy.getSupportedIssueType();
            this.myStrategies.put(issueType, strategy);
        }
        this.myDefaultMessageFactory = new UnhandledIssuesReporter();
    }

    public void report(@NotNull Collection<SyncIssue> syncIssues, @NotNull Module module) {
        if (syncIssues == null) {
            SyncIssuesReporter.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SyncIssuesReporter.$$$reportNull$$$0(4);
        }
        if (syncIssues.isEmpty()) {
            return;
        }
        boolean hasSyncErrors = false;
        VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
        for (SyncIssue syncIssue : syncIssues) {
            if (syncIssue.getSeverity() == 2) {
                hasSyncErrors = true;
            }
            this.report(syncIssue, module, buildFile);
        }
        if (hasSyncErrors) {
            Project project = module.getProject();
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    private void report(@NotNull SyncIssue syncIssue, @NotNull Module module, @Nullable VirtualFile buildFile) {
        int type;
        BaseSyncIssuesReporter strategy;
        if (syncIssue == null) {
            SyncIssuesReporter.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SyncIssuesReporter.$$$reportNull$$$0(6);
        }
        if ((strategy = this.myStrategies.get(type = syncIssue.getType())) == null) {
            strategy = this.myDefaultMessageFactory;
        }
        strategy.report(syncIssue, module, buildFile);
    }

    @VisibleForTesting
    @NotNull
    Map<Integer, BaseSyncIssuesReporter> getStrategies() {
        Map<Integer, BaseSyncIssuesReporter> map = this.myStrategies;
        if (map == null) {
            SyncIssuesReporter.$$$reportNull$$$0(7);
        }
        return map;
    }

    @VisibleForTesting
    @NotNull
    BaseSyncIssuesReporter getDefaultMessageFactory() {
        BaseSyncIssuesReporter baseSyncIssuesReporter = this.myDefaultMessageFactory;
        if (baseSyncIssuesReporter == null) {
            SyncIssuesReporter.$$$reportNull$$$0(8);
        }
        return baseSyncIssuesReporter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedDependenciesReporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SyncIssuesReporter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessageFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

