/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.ng.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class ProjectDataNodeSetup {
    public void setupProjectDataNode(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        if (projectModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(1);
        }
        String projectFolder = project.getBasePath();
        assert (projectFolder != null);
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, project.getName(), projectFolder, projectFolder);
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (String gradlePath : projectModels.getProjectPaths()) {
            GradleModuleModels moduleModels = projectModels.getModels(gradlePath);
            if (moduleModels == null) continue;
            DataNode<ModuleData> moduleData = ProjectDataNodeSetup.createModuleDataNode(moduleModels, (DataNode<ProjectData>)projectDataNode);
            ProjectDataNodeSetup.createTaskDataNode(moduleModels, moduleData);
        }
        InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, projectFolder, projectDataNode);
        ProjectDataManager.getInstance().updateExternalProjectData(project, (ExternalProjectInfo)projectInfo);
    }

    @NotNull
    private static DataNode<ModuleData> createModuleDataNode(@NotNull GradleModuleModels moduleModels, @NotNull DataNode<ProjectData> projectDataNode) {
        String moduleConfigPath;
        if (moduleModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(2);
        }
        if (projectDataNode == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(3);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        try {
            moduleConfigPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            moduleConfigPath = GradleUtil.getConfigPath((GradleProject)gradleProject, (String)((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath());
        }
        String moduleName = moduleModels.getModuleName();
        String gradlePath = gradleProject.getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, GradleConstants.SYSTEM_ID, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        moduleData.setDescription(gradleProject.getDescription());
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(4);
        }
        return dataNode;
    }

    private static void createTaskDataNode(@NotNull GradleModuleModels moduleModels, @NotNull DataNode<ModuleData> moduleData) {
        if (moduleModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(5);
        }
        if (moduleData == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(6);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        for (GradleTask task : gradleProject.getTasks()) {
            String taskGroup;
            String taskName = task.getName();
            try {
                taskGroup = task.getGroup();
            }
            catch (UnsupportedMethodException e) {
                taskGroup = null;
            }
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask((String)taskName, (String)taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, gradleProject.getPath(), task.getDescription());
            taskData.setGroup(taskGroup);
            moduleData.createChild(ProjectKeys.TASK, (Object)taskData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ProjectDataNodeSetup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectDataNodeSetup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleDataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectDataNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDataNode";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTaskDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

