/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.precheck.AndroidSdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.JdkPreSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.SyncCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreSyncChecks {
    @NotNull
    private final List<SyncCheck> myStrategies;

    @NotNull
    public static PreSyncChecks getInstance() {
        PreSyncChecks preSyncChecks = (PreSyncChecks)ServiceManager.getService(PreSyncChecks.class);
        if (preSyncChecks == null) {
            PreSyncChecks.$$$reportNull$$$0(0);
        }
        return preSyncChecks;
    }

    public PreSyncChecks() {
        this(new AndroidSdkPreSyncCheck(), new JdkPreSyncCheck());
    }

    @VisibleForTesting
    PreSyncChecks(SyncCheck ... strategies) {
        if (strategies == null) {
            PreSyncChecks.$$$reportNull$$$0(1);
        }
        this.myStrategies = Lists.newArrayList((Object[])strategies);
    }

    @NotNull
    public PreSyncCheckResult canSync(@NotNull Project project) {
        if (project == null) {
            PreSyncChecks.$$$reportNull$$$0(2);
        }
        for (SyncCheck condition : this.myStrategies) {
            PreSyncCheckResult result = condition.canSync(project);
            if (result.isSuccess()) continue;
            PreSyncCheckResult preSyncCheckResult = result;
            if (preSyncCheckResult == null) {
                PreSyncChecks.$$$reportNull$$$0(3);
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            PreSyncChecks.$$$reportNull$$$0(4);
        }
        return preSyncCheckResult;
    }

    @VisibleForTesting
    @NotNull
    List<SyncCheck> getStrategies() {
        List<SyncCheck> list = this.myStrategies;
        if (list == null) {
            PreSyncChecks.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/precheck/PreSyncChecks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canSync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canSync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

