/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.util.GradleProjects;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ModuleFinder {
    @NotNull
    public static final ModuleFinder EMPTY = new ModuleFinder();
    @NotNull
    private final Map<String, Module> myModulesByGradlePath;
    @NotNull
    private final Map<String, Module> myModulesByModuleId;
    @NotNull
    private final Map<String, String> myIncludedProjectFolderByModuleFolder;

    private ModuleFinder() {
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, String>();
    }

    public ModuleFinder(@NotNull Project project) {
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(0);
        }
        this.myModulesByGradlePath = new HashMap<String, Module>();
        this.myModulesByModuleId = new HashMap<String, Module>();
        this.myIncludedProjectFolderByModuleFolder = new HashMap<String, String>();
        this.populateIncludedProjectFolderByModuleFolder(project);
    }

    private void populateIncludedProjectFolderByModuleFolder(@NotNull Project project) {
        String projectPath;
        if (project == null) {
            ModuleFinder.$$$reportNull$$$0(1);
        }
        if ((projectPath = project.getBasePath()) == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return;
        }
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            for (String modulePath : participant.getProjects()) {
                this.myIncludedProjectFolderByModuleFolder.put(modulePath, participant.getRootPath());
            }
        }
    }

    public void addModule(@NotNull Module module, @NotNull String gradlePath) {
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(2);
        }
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(3);
        }
        this.myModulesByGradlePath.put(gradlePath, module);
        String projectFolder = this.getProjectFolder(module);
        if (projectFolder != null) {
            this.myModulesByModuleId.put(ModuleFinder.getModuleId(projectFolder, gradlePath), module);
        }
    }

    @Nullable
    private String getProjectFolder(@NotNull Module module) {
        String modulePath;
        File moduleFolder;
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(4);
        }
        if ((moduleFolder = GradleProjects.findModuleRootFolderPath(module)) != null && this.myIncludedProjectFolderByModuleFolder.containsKey(modulePath = moduleFolder.getPath())) {
            return this.myIncludedProjectFolderByModuleFolder.get(modulePath);
        }
        return module.getProject().getBasePath();
    }

    @NotNull
    public static String getModuleId(@NotNull String projectFolder, @NotNull String gradlePath) {
        if (projectFolder == null) {
            ModuleFinder.$$$reportNull$$$0(5);
        }
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(6);
        }
        String string = projectFolder + gradlePath;
        if (string == null) {
            ModuleFinder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Module findModuleByGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            ModuleFinder.$$$reportNull$$$0(8);
        }
        return this.myModulesByGradlePath.get(gradlePath);
    }

    @Nullable
    public Module findModuleByModuleId(@NotNull String moduleId) {
        if (moduleId == null) {
            ModuleFinder.$$$reportNull$$$0(9);
        }
        return this.myModulesByModuleId.get(moduleId);
    }

    public boolean isCompositeBuild(@NotNull Module module) {
        File moduleFolder;
        if (module == null) {
            ModuleFinder.$$$reportNull$$$0(10);
        }
        if ((moduleFolder = GradleProjects.findModuleRootFolderPath(module)) != null) {
            return this.myIncludedProjectFolderByModuleFolder.containsKey(moduleFolder.getPath());
        }
        return false;
    }

    public String toString() {
        return "ModuleFinder{myModulesByGradlePath=" + this.myModulesByGradlePath + ", myModulesByModuleId=" + this.myModulesByModuleId + ", myIncludedProjectFolderByModuleFolder=" + this.myIncludedProjectFolderByModuleFolder + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "populateIncludedProjectFolderByModuleFolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFolder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleId";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByGradlePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByModuleId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        @NotNull
        public ModuleFinder create(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ModuleFinder moduleFinder = new ModuleFinder(project);
            if (moduleFinder == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return moduleFinder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/ModuleFinder$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

