/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DisposedModules
implements Disposable {
    @VisibleForTesting
    static final Key<DisposedModules> KEY = Key.create((String)"com.android.tools.gradle.sync.DisposedModules");
    @NotNull
    private final List<File> myFilesToDelete = new ArrayList<File>();
    private static Factory ourFactory = new Factory();

    @NotNull
    public static DisposedModules getInstance(@NotNull Project project) {
        DisposedModules disposedModules;
        if (project == null) {
            DisposedModules.$$$reportNull$$$0(0);
        }
        if ((disposedModules = (DisposedModules)project.getUserData(KEY)) == null || disposedModules.isDisposed()) {
            disposedModules = ourFactory.createNewInstance();
            project.putUserData(KEY, (Object)disposedModules);
        }
        DisposedModules disposedModules2 = disposedModules;
        if (disposedModules2 == null) {
            DisposedModules.$$$reportNull$$$0(1);
        }
        return disposedModules2;
    }

    public void markImlFilesForDeletion(@NotNull List<File> filesToDelete) {
        if (filesToDelete == null) {
            DisposedModules.$$$reportNull$$$0(2);
        }
        this.checkNotDisposed();
        this.myFilesToDelete.clear();
        if (!filesToDelete.isEmpty()) {
            this.myFilesToDelete.addAll(filesToDelete);
        }
    }

    public void deleteImlFilesForDisposedModules() {
        this.checkNotDisposed();
        for (File imlFile : this.myFilesToDelete) {
            boolean deleted;
            if (!imlFile.isFile() || (deleted = FileUtil.delete((File)imlFile))) continue;
            Logger.getInstance(DisposedModules.class).info("Failed to delete '" + imlFile.getPath() + "'");
        }
        Disposer.dispose((Disposable)this);
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @VisibleForTesting
    boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        this.myFilesToDelete.clear();
    }

    @VisibleForTesting
    @NotNull
    List<File> getFilesToDelete() {
        List<File> list = this.myFilesToDelete;
        if (list == null) {
            DisposedModules.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static void restoreFactory() {
        DisposedModules.setFactory(new Factory());
    }

    public static void setFactory(@NotNull Factory factory) {
        if (factory == null) {
            DisposedModules.$$$reportNull$$$0(4);
        }
        ourFactory = factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/project/DisposedModules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/DisposedModules";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markImlFilesForDeletion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static class Factory {
        @NotNull
        public DisposedModules createNewInstance() {
            DisposedModules disposedModules = new DisposedModules();
            if (disposedModules == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return disposedModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/project/DisposedModules$Factory", "createNewInstance"));
        }
    }
}

