/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedPluginPreviewVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        AndroidPluginGeneration pluginGeneration;
        GradleVersion recommended;
        if (project == null) {
            ForcedPluginPreviewVersionUpgradeStep.$$$reportNull$$$0(0);
        }
        if (pluginInfo == null) {
            ForcedPluginPreviewVersionUpgradeStep.$$$reportNull$$$0(1);
        }
        if (!ForcedPluginPreviewVersionUpgradeStep.shouldPreviewBeForcedToUpgradePluginVersion(recommended = GradleVersion.parse((String)(pluginGeneration = pluginInfo.getPluginGeneration()).getLatestKnownVersion()), pluginInfo.getPluginVersion())) {
            return false;
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        syncState.syncEnded();
        boolean userAcceptsForcedUpgrade = (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (project == null) {
                ForcedPluginPreviewVersionUpgradeStep.$$$reportNull$$$0(3);
            }
            if (pluginInfo == null) {
                ForcedPluginPreviewVersionUpgradeStep.$$$reportNull$$$0(4);
            }
            return new ForcedPluginPreviewVersionUpgradeDialog(project, pluginInfo).showAndGet();
        });
        if (userAcceptsForcedUpgrade) {
            AndroidPluginVersionUpdater versionUpdater = AndroidPluginVersionUpdater.getInstance(project);
            versionUpdater.updatePluginVersionAndSync(recommended, GradleVersion.parse((String)"4.4"), true);
        } else {
            String[] text = new String[]{"The project is using an incompatible version of the " + pluginGeneration.getDescription() + ".", "Please update your project to use version " + pluginGeneration.getLatestKnownVersion() + "."};
            SyncMessage msg = new SyncMessage("Gradle Sync Issues", MessageType.ERROR, text);
            String pluginName = AndroidPluginGeneration.getGroupId() + ":" + pluginGeneration.getArtifactId();
            SearchInBuildFilesHyperlink quickFix = new SearchInBuildFilesHyperlink(pluginName);
            msg.add(quickFix);
            GradleSyncMessages.getInstance(project).report(msg);
            syncState.invalidateLastSync("Force plugin upgrade declined");
        }
        return true;
    }

    @VisibleForTesting
    static boolean shouldPreviewBeForcedToUpgradePluginVersion(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (recommended == null) {
            ForcedPluginPreviewVersionUpgradeStep.$$$reportNull$$$0(2);
        }
        if (current != null && current.getPreviewType() != null) {
            if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            if (recommended.isAtLeast(2, 4, 0, "alpha", 8, false)) {
                if (current.compareTo(recommended) >= 0) {
                    return false;
                }
                boolean isOlderPreviewAllowed = current.isPreview() && current.getMajor() == 2 && current.getMinor() == 4 && current.compareTo(recommended) < 0;
                return !isOlderPreviewAllowed;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommended";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/ForcedPluginPreviewVersionUpgradeStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndPerformUpgrade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldPreviewBeForcedToUpgradePluginVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkAndPerformUpgrade$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

