/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgradeStep;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.TimeBasedUpgradeReminder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecommendedPluginVersionUpgradeStep
extends PluginVersionUpgradeStep {
    @NotNull
    private final RecommendedPluginVersionUpgradeDialog.Factory myUpgradeDialogFactory;
    @NotNull
    private final TimeBasedUpgradeReminder myUpgradeReminder;

    public RecommendedPluginVersionUpgradeStep() {
        this(new RecommendedPluginVersionUpgradeDialog.Factory(), new TimeBasedUpgradeReminder());
    }

    @VisibleForTesting
    RecommendedPluginVersionUpgradeStep(@NotNull RecommendedPluginVersionUpgradeDialog.Factory upgradeDialogFactory, @NotNull TimeBasedUpgradeReminder upgradeReminder) {
        if (upgradeDialogFactory == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(0);
        }
        if (upgradeReminder == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(1);
        }
        this.myUpgradeDialogFactory = upgradeDialogFactory;
        this.myUpgradeReminder = upgradeReminder;
    }

    @Override
    public boolean checkAndPerformUpgrade(@NotNull Project project, @NotNull AndroidPluginInfo pluginInfo) {
        if (project == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(2);
        }
        if (pluginInfo == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(3);
        }
        if (this.myUpgradeReminder.shouldRecommendUpgrade(project) && RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(pluginInfo)) {
            GradleVersion latestGradleVersion;
            AndroidPluginVersionUpdater updater;
            AndroidPluginVersionUpdater.UpdateResult result;
            GradleVersion current = pluginInfo.getPluginVersion();
            assert (current != null);
            AndroidPluginGeneration pluginGeneration = pluginInfo.getPluginGeneration();
            GradleVersion recommended = GradleVersion.parse((String)pluginGeneration.getLatestKnownVersion());
            Computable promptUserTask = () -> {
                if (project == null) {
                    RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(6);
                }
                RecommendedPluginVersionUpgradeDialog updateDialog = this.myUpgradeDialogFactory.create(project, current, recommended);
                return updateDialog.showAndGet();
            };
            boolean userAcceptsUpgrade = ApplicationManager.getApplication().isUnitTestMode() ? ((Boolean)promptUserTask.compute()).booleanValue() : ((Boolean)UIUtil.invokeAndWaitIfNeeded((Computable)promptUserTask)).booleanValue();
            if (userAcceptsUpgrade && (result = (updater = AndroidPluginVersionUpdater.getInstance(project)).updatePluginVersionAndSync(recommended, latestGradleVersion = GradleVersion.parse((String)"4.4"), false)).versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldRecommendUpgrade(@NotNull AndroidPluginInfo androidPluginInfo) {
        if (androidPluginInfo == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(4);
        }
        GradleVersion current = androidPluginInfo.getPluginVersion();
        GradleVersion recommended = GradleVersion.parse((String)androidPluginInfo.getPluginGeneration().getLatestKnownVersion());
        return RecommendedPluginVersionUpgradeStep.shouldRecommendUpgrade(recommended, current);
    }

    @VisibleForTesting
    static boolean shouldRecommendUpgrade(@NotNull GradleVersion recommended, @Nullable GradleVersion current) {
        if (recommended == null) {
            RecommendedPluginVersionUpgradeStep.$$$reportNull$$$0(5);
        }
        if (current != null) {
            if (recommended.isSnapshot() && current.getPreviewType() != null && current.compareIgnoringQualifiers(recommended) == 0) {
                return false;
            }
            return current.compareTo(recommended) < 0;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeDialogFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeReminder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidPluginInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommended";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndPerformUpgrade";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRecommendUpgrade";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkAndPerformUpgrade$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

