/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class GradleAwareSourceRootRenameValidator
implements RenameInputValidatorEx {
    private boolean myShowWarning;

    @Nullable
    public String getErrorMessage(String newName2, Project project) {
        return this.myShowWarning ? AndroidBundle.message("android.refactoring.gradle.warning.rename.source.root", new Object[0]) : null;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(PsiDirectory.class);
    }

    public boolean isInputValid(String newName2, PsiElement element, ProcessingContext context) {
        Module[] modules;
        this.myShowWarning = false;
        if (!(element instanceof PsiDirectory)) {
            assert (false);
            return true;
        }
        VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
        for (Module module : modules = ModuleManager.getInstance((Project)element.getProject()).getModules()) {
            VirtualFile[] sourceRoots;
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (Module)module) || StringUtil.isEmpty((String)ExternalSystemApiUtil.getExternalProjectPath((Module)module))) continue;
            for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false)) {
                if (!sourceRoot.equals(virtualFile)) continue;
                this.myShowWarning = true;
                return true;
            }
        }
        return true;
    }
}

