/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue myMainQueue;
    @NotNull
    private final MergingUpdateQueue myResultsUpdaterQueue;
    @NotNull
    private final AtomicBoolean myRunning;
    @NotNull
    private final EventDispatcher<AvailableUpdatesListener> myEventDispatcher;

    public PsLibraryUpdateCheckerDaemon(@NotNull PsContext context) {
        if (context == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(0);
        }
        super(context);
        this.myRunning = new AtomicBoolean(true);
        this.myEventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        this.myMainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.myResultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
    }

    public void queueAutomaticUpdateCheck() {
        long elapsed;
        long daysPastSinceLastUpdate;
        long searchTimeMillis = this.getAvailableUpdates().lastSearchTimeMillis;
        if (searchTimeMillis > 0L && (daysPastSinceLastUpdate = TimeUnit.MILLISECONDS.toDays(elapsed = System.currentTimeMillis() - searchTimeMillis)) < 3L) {
            this.myResultsUpdaterQueue.queue((Update)new UpdatesAvailable());
            return;
        }
        this.queueUpdateCheck();
    }

    public void queueUpdateCheck() {
        this.myMainQueue.queue((Update)new SearchForAvailableUpdates());
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myMainQueue;
        if (mergingUpdateQueue == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(1);
        }
        return mergingUpdateQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myResultsUpdaterQueue;
        if (mergingUpdateQueue == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(2);
        }
        return mergingUpdateQueue;
    }

    @NotNull
    public AvailableLibraryUpdateStorage.AvailableLibraryUpdates getAvailableUpdates() {
        Project project = this.getContext().getProject().getResolvedModel();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates availableLibraryUpdates = AvailableLibraryUpdateStorage.getInstance(project).getState();
        if (availableLibraryUpdates == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(3);
        }
        return availableLibraryUpdates;
    }

    public void add(@NotNull AvailableUpdatesListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(5);
        }
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.myRunning.get();
    }

    private void search(@NotNull Collection<ArtifactRepository> repositories, @NotNull Collection<LibraryUpdateId> ids) {
        if (repositories == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(6);
        }
        if (ids == null) {
            PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(7);
        }
        this.myRunning.set(true);
        this.getAvailableUpdates().clear();
        int resultCount = repositories.size() * ids.size();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)resultCount);
        HashSet requests = Sets.newHashSet();
        ids.forEach(id -> {
            SearchRequest request = new SearchRequest(id.getName(), id.getGroupId(), 1, 0);
            requests.add(request);
        });
        HashSet results = Sets.newHashSet();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            List<FoundArtifact> artifacts;
            if (repositories == null) {
                PsLibraryUpdateCheckerDaemon.$$$reportNull$$$0(8);
            }
            for (ArtifactRepository repository : repositories) {
                for (SearchRequest request : requests) {
                    jobs.add(application.executeOnPooledThread(() -> repository.search(request)));
                }
            }
            for (Future job : jobs) {
                try {
                    FoundArtifact artifact;
                    SearchResult result = (SearchResult)Futures.getChecked((Future)job, Exception.class);
                    artifacts = result.getArtifacts();
                    if (artifacts.size() != 1 || (artifact = artifacts.get(0)).getVersions().isEmpty()) continue;
                    results.add(result);
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            AvailableLibraryUpdateStorage.AvailableLibraryUpdates updates = this.getAvailableUpdates();
            for (SearchResult result : results) {
                artifacts = result.getArtifacts();
                updates.add(artifacts.get(0));
            }
            updates.lastSearchTimeMillis = System.currentTimeMillis();
            this.myResultsUpdaterQueue.queue((Update)new UpdatesAvailable());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsUpdaterQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$search$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AvailableUpdatesListener
    extends EventListener {
        public void availableUpdates();
    }

    private class UpdatesAvailable
    extends Update {
        UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }

        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.myEventDispatcher.getMulticaster()).availableUpdates();
            PsLibraryUpdateCheckerDaemon.this.myRunning.set(false);
        }
    }

    private class SearchForAvailableUpdates
    extends Update {
        SearchForAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }

        public void run() {
            HashSet repositories = Sets.newHashSet();
            HashSet ids = Sets.newHashSet();
            PsLibraryUpdateCheckerDaemon.this.getContext().getProject().forEachModule(module -> {
                repositories.addAll(module.getArtifactRepositories());
                if (module instanceof PsAndroidModule) {
                    PsAndroidModule androidModule = (PsAndroidModule)module;
                    androidModule.forEachDeclaredDependency(dependency -> {
                        GradleVersion version;
                        PsLibraryDependency libraryDependency;
                        PsArtifactDependencySpec spec;
                        if (dependency instanceof PsLibraryDependency && (spec = (libraryDependency = (PsLibraryDependency)((Object)dependency)).getDeclaredSpec()) != null && StringUtil.isNotEmpty((String)spec.getVersion()) && (version = GradleVersion.tryParse((String)spec.getVersion())) != null) {
                            ids.add(new LibraryUpdateId(spec.getName(), spec.getGroup()));
                        }
                    });
                }
            });
            if (!repositories.isEmpty() && !ids.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, ids);
            }
        }
    }
}

