/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.tools.idea.structure.EditorPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericEditor<E extends EditorPanel>
implements ModuleConfigurationEditor {
    private static final Logger LOG = Logger.getInstance(GenericEditor.class);
    private final String myName;
    private E myPanel;
    private final Callable<E> myPanelFactory;

    public GenericEditor(String name, Callable<E> panelFactory) {
        this.myName = name;
        this.myPanelFactory = panelFactory;
    }

    @Nullable
    public JComponent createComponent() {
        try {
            this.myPanel = (EditorPanel)this.myPanelFactory.call();
        }
        catch (Exception e) {
            LOG.error("Error while creating dialog", (Throwable)e);
        }
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel != null && ((EditorPanel)this.myPanel).isModified();
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myName;
        if (string == null) {
            GenericEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                try {
                    WriteAction.run(GenericEditor.this.myPanel::apply);
                }
                catch (Exception e) {
                    LOG.error("Error while applying changes", (Throwable)e);
                }
            }
        });
    }

    public void reset() {
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/GenericEditor", "getDisplayName"));
    }
}

