/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsParsedDependencies {
    @NotNull
    private final Multimap<String, ModuleDependencyModel> myParsedModuleDependencies = ArrayListMultimap.create();
    @NotNull
    private final Multimap<String, ArtifactDependencyModel> myParsedArtifactDependencies = ArrayListMultimap.create();

    public PsParsedDependencies(@Nullable GradleBuildModel parsedModel) {
        this.reset(parsedModel);
    }

    void reset(@Nullable GradleBuildModel parsedModel) {
        this.myParsedArtifactDependencies.clear();
        this.myParsedModuleDependencies.clear();
        if (parsedModel != null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (DependencyModel parsedDependency : parsedModel.dependencies().all()) {
                    if (parsedDependency instanceof ArtifactDependencyModel) {
                        ArtifactDependencyModel artifact = (ArtifactDependencyModel)parsedDependency;
                        this.myParsedArtifactDependencies.put((Object)PsParsedDependencies.createIdFrom(artifact), (Object)artifact);
                        continue;
                    }
                    if (!(parsedDependency instanceof ModuleDependencyModel)) continue;
                    ModuleDependencyModel module = (ModuleDependencyModel)parsedDependency;
                    this.myParsedModuleDependencies.put((Object)module.path().value(), (Object)module);
                }
            });
        }
    }

    @NotNull
    private static String createIdFrom(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            PsParsedDependencies.$$$reportNull$$$0(0);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{(String)dependency.group().value(), dependency.name().value()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            PsParsedDependencies.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<ArtifactDependencyModel> findLibraryDependencies(@NotNull PsArtifactDependencySpec spec, @Nullable Predicate<ArtifactDependencyModel> predicate) {
        if (spec == null) {
            PsParsedDependencies.$$$reportNull$$$0(2);
        }
        String id = PsParsedDependencies.createIdFrom(spec);
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)id);
        if (predicate != null) {
            List<ArtifactDependencyModel> list = potentialMatches.stream().filter(predicate).collect(Collectors.toList());
            if (list == null) {
                PsParsedDependencies.$$$reportNull$$$0(3);
            }
            return list;
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)potentialMatches);
        if (immutableList == null) {
            PsParsedDependencies.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    private static String createIdFrom(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            PsParsedDependencies.$$$reportNull$$$0(5);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            PsParsedDependencies.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull GradleCoordinate coordinates, @NotNull Predicate<ArtifactDependencyModel> predicate) {
        if (coordinates == null) {
            PsParsedDependencies.$$$reportNull$$$0(7);
        }
        if (predicate == null) {
            PsParsedDependencies.$$$reportNull$$$0(8);
        }
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(coordinates));
        for (ArtifactDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull GradleCoordinate coordinates) {
        if (coordinates == null) {
            PsParsedDependencies.$$$reportNull$$$0(9);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{coordinates.getGroupId(), coordinates.getArtifactId()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            PsParsedDependencies.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull GradleModuleVersion moduleVersion) {
        GradleVersion parsedVersion;
        Collection potentialMatches;
        if (moduleVersion == null) {
            PsParsedDependencies.$$$reportNull$$$0(11);
        }
        if ((potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(moduleVersion))).size() == 1) {
            return (ArtifactDependencyModel)ContainerUtil.getFirstItem((Collection)potentialMatches);
        }
        String version = Strings.nullToEmpty((String)moduleVersion.getVersion());
        HashMap dependenciesByVersion = Maps.newHashMap();
        for (ArtifactDependencyModel potentialMatch : potentialMatches) {
            GradleVersion parsedVersion2;
            String potentialVersion = Strings.nullToEmpty((String)((String)potentialMatch.version().value()));
            if (version.equals(potentialVersion)) {
                return potentialMatch;
            }
            if (!StringUtil.isNotEmpty((String)potentialVersion) || (parsedVersion2 = GradleVersion.tryParse((String)potentialVersion)) == null) continue;
            dependenciesByVersion.put(parsedVersion2, potentialMatch);
        }
        if (StringUtil.isNotEmpty((String)version) && !dependenciesByVersion.isEmpty() && (parsedVersion = GradleVersion.tryParse((String)version)) != null) {
            for (String potentialVersion : dependenciesByVersion.keySet()) {
                if (parsedVersion.compareTo((GradleVersion)potentialVersion) <= 0) continue;
                return (ArtifactDependencyModel)dependenciesByVersion.get(potentialVersion);
            }
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull GradleModuleVersion moduleVersion) {
        if (moduleVersion == null) {
            PsParsedDependencies.$$$reportNull$$$0(12);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{moduleVersion.getGroup(), moduleVersion.getName()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            PsParsedDependencies.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String joinAsGradlePath(@NotNull List<String> segments) {
        if (segments == null) {
            PsParsedDependencies.$$$reportNull$$$0(14);
        }
        String string = Joiner.on((String)":").skipNulls().join(segments);
        if (string == null) {
            PsParsedDependencies.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public ModuleDependencyModel findModuleDependency(@NotNull String gradlePath, @NotNull Predicate<ModuleDependencyModel> predicate) {
        if (gradlePath == null) {
            PsParsedDependencies.$$$reportNull$$$0(16);
        }
        if (predicate == null) {
            PsParsedDependencies.$$$reportNull$$$0(17);
        }
        Collection potentialMatches = this.myParsedModuleDependencies.get((Object)gradlePath);
        for (ModuleDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/PsParsedDependencies";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleVersion";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/PsParsedDependencies";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdFrom";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findLibraryDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "joinAsGradlePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIdFrom";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryDependencies";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryDependency";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "joinAsGradlePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findModuleDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

