/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.helpers;

import com.android.tools.idea.gradle.structure.model.meta.ParsedValue;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a5\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0006\b\u0000\u0010\u0006\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\bH\u0086\b\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"parseBoolean", "Lcom/android/tools/idea/gradle/structure/model/meta/ParsedValue;", "", "text", "", "parseEnum", "T", "parser", "Lkotlin/Function1;", "parseFile", "Ljava/io/File;", "parseInt", "", "parseString", "intellij.android"})
public final class InputParsersKt {
    @NotNull
    public static final ParsedValue<String> parseString(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? (ParsedValue)new ParsedValue.NotSet() : (ParsedValue)new ParsedValue.Set.Parsed(text, null, 2, null);
    }

    @NotNull
    public static final ParsedValue<File> parseFile(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? (ParsedValue)new ParsedValue.NotSet() : (ParsedValue)new ParsedValue.Set.Parsed(new File(text), null, 2, null);
    }

    private static final <T> ParsedValue<T> parseEnum(String text, Function1<? super String, ? extends T> parser) {
        ParsedValue parsedValue;
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            parsedValue = new ParsedValue.NotSet();
        } else {
            ParsedValue.Set set;
            Object parsed = parser.invoke((Object)text);
            if (parsed != null) {
                set = new ParsedValue.Set.Parsed(parsed, null, 2, null);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append('\'').append(text).append("' is not a valid value of type ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                set = new ParsedValue.Set.Invalid(text, stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).toString());
            }
            parsedValue = set;
        }
        return parsedValue;
    }

    @NotNull
    public static final ParsedValue<Boolean> parseBoolean(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)text, (Object)"") ? (ParsedValue)new ParsedValue.NotSet() : (StringsKt.equals((String)text, (String)"true", (boolean)true) ? (ParsedValue)new ParsedValue.Set.Parsed(true, null, 2, null) : (StringsKt.equals((String)text, (String)"false", (boolean)true) ? (ParsedValue)new ParsedValue.Set.Parsed(false, null, 2, null) : (ParsedValue)new ParsedValue.Set.Invalid(text, "Unknown boolean value: '" + text + "'. Expected 'true' or 'false'")));
    }

    @NotNull
    public static final ParsedValue<Integer> parseInt(@NotNull String text) {
        ParsedValue parsedValue;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)text, (Object)"")) {
            parsedValue = new ParsedValue.NotSet();
        } else {
            Object object;
            try {
                ParsedValue.Set.Parsed parsed;
                object = text;
                ParsedValue.Set.Parsed parsed2 = parsed;
                ParsedValue.Set.Parsed parsed3 = parsed;
                int n = Integer.parseInt((String)object);
                parsed2(n, null, 2, null);
                object = parsed3;
            }
            catch (NumberFormatException ex) {
                object = new ParsedValue.Set.Invalid(text, '\'' + text + "' is not a valid integer value");
            }
            parsedValue = (ParsedValue)object;
        }
        return parsedValue;
    }
}

